#ifndef MSGTGT_H
#define MSGTGT_H

/*!
  @ingroup diag_message_service
  @file msgtgt.h
  @brief
  Target-specific configuration file for Diagnostic Message 2.0 Service
  @par
  MSG 2.0 offers the ability to utilize more build-time and run-time
  filtering of debug messages.
  @par
  This file is used to customize MSG 2.0 for a specific build.  All
  definitions here override their counterparts in msgcfg.h.
  @par
  This file may contain, but is not limited to any or all of the following:
  @par
  Build masks for known SSIDs , default build mask , max string length
  (used to avoid endless strcpy).
  @par
  Build masks are 32 bits, each specifying a category within a SSID.  The
  first 5 LSBs are reserved for legacy (Low, Med, High, Error, Fatal).  These
  can be reused with the tradeoff of any legacy tool interpreting those bits
  as legacy message levels.The 27 MSBs in the mask are defined at the discretion
  of the technology area associated with the SSID.  These are to be published,
  so changing the meaning is not allowed.
  @note
  The definitions of all these constants are omitted in the document for the
  sake of brevity.
*/

/*
Copyright (c) 2002-2017 by Qualcomm Technologies, Inc.
All Rights Reserved.
Qualcomm Technologies Confidential and Proprietary
*/

/*===========================================================================
                        EDIT HISTORY FOR FILE

  $Header: //source/qcom/qct/core/api/services/diag/main/latest/msgtgt.h#49 $

when       who     what, where, why
--------   ---     ----------------------------------------------------------
03/31/14   xy      Added new message SSIDs
02/25/14   xy      Update levels of MSG_BUILD_MASK_MSG_SSID_LTE_RRC
01/29/14   xy      Added new message SSIDs
12/03/13   xy      Added new message SSIDs
10/09/13   xy      Update levels of MSG_BUILD_MASK_MSG_SSID_HDR_DEBUG
09/25/13   xy      Added new message SSIDs
07/30/13   sr      Added new message SSIDs
06/26/13   sr      Added new message SSIDs
05/08/13   sr      Added new message SSIDs
04/17/13   sr      Support to disable F3 msgs by target team
03/22/13   sr      Added new message SSIDs
03/12/13   sr      Added new message SSIDs
01/22/13   sr      Added new message SSIDs
12/07/12   sr      Added new message SSIDs
11/27/12   sr      Added new message SSIDs
10/15/12   sr      Added new message SSIDs
07/16/12   rh      Added new message SSIDs
06/22/12   rh      Added new message SSIDs
06/06/12   rh      Updated several SSIDs to have different build-time masks.
03/26/12   rh      Expanded the TDSCDMA L1 mask to encompass more level categories
02/29/12   rh      Added new message SSIDs
02/21/12   is      Add MSG_BUILD_MASK_LEGACY catergory to support F3 listener testing
02/17/12   rs      Added build mask for MSG_SSID_SEC_WIDEVINE
01/12/12   rh      Changed priority level for TDSCDMA SSIDs
01/05/12   rh      Added build mask for QCNEA SSIDs
12/08/11   rh      Added build mask for MSG_SSID_ADC
11/29/11   rh      Added SSID category for CTA
10/18/11   hm      Renamed reserved MCS SSIDs
09/01/11   hm      Added new WCDMA and TDSCDMA SSIDs
08/05/11   hm      Added new SSID
07/01/11   hm      Added new SSID
06/10/11   hm      Changed default level of AVS SSIDs
05/20/11   hm      Changed default level of QCHAT SSIDs
04/25/11   hm      Added new SSID
04/05/11   hm      Added new SSID for PPM module
03/24/11   hm      Reverted Octopus Changes and added new QCHAT SSIDs
03/07/11   hm      Added new set of SSIDs for Octopus
02/03/11   hm      Changed MSG level for Audio Packet Router (for 8k+9k Fusion)
01/21/11   hm      Enabled ML1 messages 21 and 22
07/27/10   sg      Added new ssid for Multimedia team
07/07/10   sg      Added new SSID for data services team
07/06/10   sg      Changed MSG_SSID_MCS_RESERVED_1 to  MSG_SSID_FWS
06/28/10   sg      Changing MSG_BUILD_MASK_MSG_SSID_RF level to MSG_LVL_LOW
06/10/10   mad     Doxygenated
04/27/10   sg      Added new SSIDS for Sound Routing Driver , DAL
04/20/10   sg      Added new SSIDS for Audio Team
04/09/10   sg      Added new SSIDS for OMA device management
                   Secure Instant Wireless Access
04/02/10   sg      Added inclusion of msg_mask.h
03/04/10   sg      Added new SSIDs for IMS Team
02/22/10   sg      Added new SSIDs for Data Services
02/12/10   sg      Modified message level for LTE ML1 SSID
02/08/10   sg      Added new SSIDs for IMS team
01/13/10   sg      Added new SSID for CAD team
12/22/09   sg      Added New SSID for Connectivity Engine Team
11/24/09   sg      Changes made to allow target team to define MSG_BUILD_MASK_DFLT,
                   MSG_BUILD_MASK_MSG_SSID_DFLT
10/28/09   sg      Added New SSID for Chaos CoOrdinator Service
10/27/09   sg      Added new SSID for  Data Services team
10/26/09   sg      Fixed the ECALL SSID typo
09/30/09   as      Removed feature T_MSM6200 and T_MSM6250
09/23/09   sg      Added new SSIDS for ECALL
09/02/09   JV      Added new SSIDs for the HDR team
07/27/09   JV      New SSID for ANDROID data and DS apps
07/18/09   mad     Mainlined FEATUREs: IS2000, HDR, WCDMA, GSM, WLAN, DS, DATA,
                   HIT.
06/11/09   JV      New SSID for data services
05/26/09   JV      Added custom levels for LTE F3 SSIDs
05/11/09   JV      New SSIDs for Android QCRIL and A2 modules
04/23/09   JV      Added SSIDs for the WLAN libra module.
04/10/09   JV      Added SSIDs for MCS.
03/16/09   mad     Featurized inclusion of customer.h
12/14/04   as      Reallocated SSID's used by WinCE to L4LINUX.
03/07/03   lad     First SSID deployment.
12/03/02   lad     Created file.

===========================================================================*/
#include "comdef.h"
#include "customer.h"            /* Feature definitions and settings. */

#include "msg.h"

/*!
@name Default build mask
@ingroup diag_message_service
*/
/*!
 Default build mask for all uncategorizerd (default) messages. */
#ifndef MSG_BUILD_MASK_DFLT
#define MSG_BUILD_MASK_DFLT MSG_LVL_ERROR
#endif

#ifndef MSG_BUILD_MASK_LEGACY
#define MSG_BUILD_MASK_LEGACY MSG_LVL_HIGH
#endif

/*!
@cond DOXYGEN_BLOAT
*/
/* General SSIDs */
#ifndef MSG_BUILD_MASK_MSG_SSID_DFLT
#define MSG_BUILD_MASK_MSG_SSID_DFLT      (MSG_LVL_HIGH)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_LEGACY
#define MSG_BUILD_MASK_MSG_SSID_LEGACY    (MSG_LVL_HIGH)
#endif

#define MSG_BUILD_MASK_MSG_SSID_AUDFMT    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_AVS       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_BOOT      (MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_BT        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_CM        (MSG_LVL_MED) //AST req
#define MSG_BUILD_MASK_MSG_SSID_CMX       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DIAG      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_DSM       (MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_FTM       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_FS        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_HS        (MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_GPS       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MDSP      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MMOC      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_QDSP      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_REX       (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_RF        (MSG_LVL_LOW | MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8)
#define MSG_BUILD_MASK_MSG_SSID_RUIM      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_SIO       (MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_SD        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_SRM       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_TMC       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_VS        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WMS       (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_MMGPS     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_SLEEP     (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_SAM       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_SFAT      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_JOYST     (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MFLO      (MSG_LVL_MED|MSG_MASK_7 | \
               MSG_MASK_8|MSG_MASK_9|MSG_MASK_10|MSG_MASK_11|MSG_MASK_12 | \
               MSG_MASK_13|MSG_MASK_14|MSG_MASK_15|MSG_MASK_16 | \
               MSG_MASK_17|MSG_MASK_18|MSG_MASK_19|MSG_MASK_20|MSG_MASK_21)
#define MSG_BUILD_MASK_MSG_SSID_DTV       (MSG_LVL_MED|MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8|MSG_MASK_9|MSG_MASK_10| \
             MSG_MASK_11|MSG_MASK_12|MSG_MASK_13|MSG_MASK_14| \
             MSG_MASK_15|MSG_MASK_16|MSG_MASK_17)
#define MSG_BUILD_MASK_MSG_SSID_TCXOMGR   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_EFS       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_IRDA      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_FM_RADIO  (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_AAM       (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_BM        (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_PE        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_QIPCALL   (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_FLUTE     (MSG_LVL_MED|MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8)
#define MSG_BUILD_MASK_MSG_SSID_CAMERA    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_HSUSB     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_FC        (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_USBHOST   (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_PROFILER  (MSG_LVL_HIGH)
#ifndef MSG_BUILD_MASK_MSG_SSID_MGP
  #define MSG_BUILD_MASK_MSG_SSID_MGP       (MSG_LVL_MED)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_MGPME
  #define MSG_BUILD_MASK_MSG_SSID_MGPME     (MSG_LVL_MED|MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8|MSG_MASK_9|MSG_MASK_10| \
             MSG_MASK_11|MSG_MASK_12|MSG_MASK_13|MSG_MASK_14|MSG_MASK_15| \
             MSG_MASK_16|MSG_MASK_17|MSG_MASK_18|MSG_MASK_19|MSG_MASK_20| \
             MSG_MASK_21|MSG_MASK_22|MSG_MASK_23|MSG_MASK_24|MSG_MASK_25)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_MGPPE
  #define MSG_BUILD_MASK_MSG_SSID_MGPPE     (MSG_LVL_MED|MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8|MSG_MASK_9|MSG_MASK_10)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_GPSOS
  #define MSG_BUILD_MASK_MSG_SSID_GPSOS     (MSG_LVL_MED)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_GPSSM
  #define MSG_BUILD_MASK_MSG_SSID_GPSSM     (MSG_LVL_LOW)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_IMS
  #define MSG_BUILD_MASK_MSG_SSID_IMS       (MSG_LVL_LOW)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_MBP_RF
  #define MSG_BUILD_MASK_MSG_SSID_MBP_RF    (MSG_LVL_MED)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_SNS
  #define MSG_BUILD_MASK_MSG_SSID_SNS       (MSG_LVL_LOW)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_WM
  #define MSG_BUILD_MASK_MSG_SSID_WM        (MSG_LVL_LOW)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_LK
  #define MSG_BUILD_MASK_MSG_SSID_LK        (MSG_LVL_LOW)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_PWRDB
  #define MSG_BUILD_MASK_MSG_SSID_PWRDB     (MSG_LVL_HIGH)
#endif

#define MSG_BUILD_MASK_MSG_SSID_DCVS        (MSG_LVL_LOW) /* Dynamic Clock and Voltage Scaling (asw.power req) */

#define MSG_BUILD_MASK_MSG_SSID_ANDROID_ADB (MSG_LVL_LOW) /* Created for Android messages drained from logcat */

#define MSG_BUILD_MASK_MSG_SSID_VIDEO_ENCODER   (MSG_LVL_LOW | MSG_MASK_5 | \
            MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8)         /* Video Encoder request */
#define MSG_BUILD_MASK_MSG_SSID_VENC_OMX        (MSG_LVL_LOW | MSG_MASK_5 | \
            MSG_MASK_6)                                   /* Video Encoder request */

#define MSG_BUILD_MASK_MSG_SSID_GAN         (MSG_LVL_MED) /* Generic Access Network  (Requested by Priya Ahire) */
#define MSG_BUILD_MASK_MSG_SSID_KINETO_GAN  (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_ANDROID_QCRIL (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_A2    (MSG_LVL_MED | MSG_MASK_5 | \
            MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9 | MSG_MASK_10 | \
            MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | \
            MSG_MASK_16 | MSG_MASK_17 | MSG_MASK_18 | MSG_MASK_19 | MSG_MASK_20)
#define MSG_BUILD_MASK_MSG_SSID_LINUX_DATA            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ECALL            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_CHORD            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNE             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_CAD_GENERAL (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_OMADM            (MSG_LVL_HIGH) /* OMA device management */
#define MSG_BUILD_MASK_MSG_SSID_SIWA             (MSG_LVL_HIGH) /* Secure Instant Wireless Access */
#define MSG_BUILD_MASK_MSG_SSID_APR_MODEM (MSG_LVL_LOW) /* Audio Packet Router Modem */
#define MSG_BUILD_MASK_MSG_SSID_APR_APPS  (MSG_LVL_LOW) /* Audio Packet Router Apps*/
#define MSG_BUILD_MASK_MSG_SSID_APR_ADSP  (MSG_LVL_LOW) /* Audio Packet Router Adsp*/
#define MSG_BUILD_MASK_MSG_SSID_SRD_GENERAL (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ACDB_GENERAL (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DALTF  (MSG_LVL_HIGH | MSG_MASK_21)
#define MSG_BUILD_MASK_MSG_SSID_CFM    (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_PMIC   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_GPS_SDP   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TLE   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TLE_XTM   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TLE_TLM   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TLE_TLM_MM   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WWAN_LOC     (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_GNSS_LOCMW   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QSET         (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_QBI          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADC          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MMODE_QMI    (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_MCFG         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_SSM          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_MPOWER       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_RMTS         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADIE         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_VT_VCEL      (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_FLASH_SCRUB  (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_STRIDE       (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_POLICYMAN    (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_TMS          (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_LWIP         (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_RFS          (MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_RFS_ACCESS   (MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_RLC          (MSG_LVL_MED | MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_MEMHEAP      (MSG_LVL_MED | MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_WCI2         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_LOWI_TEST    (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_AOSTLM       (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_LOWI_AP      (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_LOWI_MP      (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_LOWI_LP      (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_MRE          (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_SLIM         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_WLE          (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_WLM          (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_Q6ZIP        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_RF_DEBUG     (MSG_LVL_NONE) /* compiled out */
#define MSG_BUILD_MASK_MSG_SSID_NV           (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_QDR          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WDSP         (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_GNSS_HLOS    (MSG_LVL_HIGH)

/* ONCRPC related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_MISC_MODEM (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_MISC_APPS  (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_CM_MODEM   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_CM_APPS    (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_DB         (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_ONCRPC_SND        (MSG_LVL_HIGH)

/* 1X related SSIDs */

#define MSG_BUILD_MASK_MSG_SSID_1X                (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_1X_ACP            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_1X_DCP            (MSG_LVL_MED) //AST req
#define MSG_BUILD_MASK_MSG_SSID_1X_DEC            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_1X_ENC            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_1X_GPSSRCH        (MSG_LVL_MED|MSG_MASK_5)
#ifndef MSG_BUILD_MASK_MSG_SSID_1X_MUX
 #define MSG_BUILD_MASK_MSG_SSID_1X_MUX           (MSG_LVL_MED)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_1X_SRCH
 #define MSG_BUILD_MASK_MSG_SSID_1X_SRCH          (MSG_LVL_MED)
#endif


/* HDR related SSIDs */

#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_PROT
#define MSG_BUILD_MASK_MSG_SSID_HDR_PROT    (MSG_LVL_MED)
#endif
#define MSG_BUILD_MASK_MSG_SSID_HDR_DATA    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_HDR_SRCH    (MSG_LVL_MED)
#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_DRIVERS
#define MSG_BUILD_MASK_MSG_SSID_HDR_DRIVERS (MSG_LVL_MED)
#endif
#define MSG_BUILD_MASK_MSG_SSID_HDR_IS890   (MSG_LVL_MED)
#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_DEBUG
 #define MSG_BUILD_MASK_MSG_SSID_HDR_DEBUG  (MSG_LVL_MED | MSG_MASK_5 | MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9 | MSG_MASK_10)
#endif
#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_HIT
 #define MSG_BUILD_MASK_MSG_SSID_HDR_HIT    (MSG_LVL_MED)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_PCP
 #define MSG_BUILD_MASK_MSG_SSID_HDR_PCP    (MSG_LVL_MED)
#endif

#ifndef MSG_BUILD_MASK_MSG_SSID_HDR_HEAPMEM
 #define MSG_BUILD_MASK_MSG_SSID_HDR_HEAPMEM    (MSG_LVL_MED)
#endif


/* HIT related SSIDs */

#ifndef MSG_BUILD_MASK_MSG_SSID_HIT
#define MSG_BUILD_MASK_MSG_SSID_HIT         (MSG_LVL_MED)
#endif


/* QDSP6 related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_QDSP6       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_SVC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_ENCDEC      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_VOC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_VS          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_MIDI        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_POSTPROC    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_PREPROC     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_AFE         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_MSESSION    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_DSESSION    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_AUD_DCM         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_ENC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_ENCRPC      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_DEC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_DECRPC      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_COMMONSW    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_VID_HWDRIVER    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_JPG_ENC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_JPG_DEC         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_OMM             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_PWRDEM          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_RESMGR          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_CORE            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSP_RDA             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DSP_TOUCH_TAFE_HAL   (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_DSP_TOUCH_ALGORITHM  (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_DSP_TOUCH_FRAMEWORK  (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_DSP_TOUCH_SRE        (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)
#define MSG_BUILD_MASK_MSG_SSID_DSP_TOUCH_TAFE_DRIVER (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)

/* UMB related SSIDs*/
#define MSG_BUILD_MASK_MSG_SSID_UMB         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_UMB_APP     (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_UMB_DS      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_UMB_CP      (MSG_LVL_MED | MSG_MASK_6 | \
            MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9)
#define MSG_BUILD_MASK_MSG_SSID_UMB_RLL     (MSG_LVL_MED | MSG_MASK_5 | \
            MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9 | MSG_MASK_10 | \
            MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | \
            MSG_MASK_16 | MSG_MASK_17)
#define MSG_BUILD_MASK_MSG_SSID_UMB_MAC     (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_UMB_SRCH    (MSG_LVL_MED | MSG_MASK_5 | \
            MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9 | MSG_MASK_10 | \
            MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | \
            MSG_MASK_16 | MSG_MASK_17 | MSG_MASK_18 | MSG_MASK_19 | MSG_MASK_20 | \
            MSG_MASK_21 | MSG_MASK_22)
#define MSG_BUILD_MASK_MSG_SSID_UMB_FW      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_UMB_PLT     (MSG_LVL_MED)

/* LTE related SSIDs*/
#define MSG_BUILD_MASK_MSG_SSID_LTE         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_LTE_RRC     (MSG_LVL_LOW | MSG_MASK_8 | MSG_MASK_9 | MSG_MASK_10 | \
            MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | \
            MSG_MASK_16 | MSG_MASK_17 | MSG_MASK_18 | MSG_MASK_19 | MSG_MASK_20 | \
            MSG_MASK_21 | MSG_MASK_22 | MSG_MASK_23 | MSG_MASK_24 | MSG_MASK_25 | \
            MSG_MASK_26 | MSG_MASK_27 | MSG_MASK_28 | MSG_MASK_29 | MSG_MASK_30)
#define MSG_BUILD_MASK_MSG_SSID_LTE_MACUL   (MSG_LVL_LOW | MSG_MASK_5 | MSG_MASK_6)
#define MSG_BUILD_MASK_MSG_SSID_LTE_MACDL   (MSG_LVL_LOW | MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_LTE_MACCTRL (MSG_LVL_LOW | MSG_MASK_5 | MSG_MASK_6)
#define MSG_BUILD_MASK_MSG_SSID_LTE_RLCUL   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_LTE_RLCDL   (MSG_LVL_LOW | MSG_MASK_5 | \
                                      MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9)
#define MSG_BUILD_MASK_MSG_SSID_LTE_PDCPUL  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_LTE_PDCPDL  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_LTE_ML1     (MSG_LVL_LOW | MSG_MASK_5 | MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | \
            MSG_MASK_9 | MSG_MASK_10 | MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | MSG_MASK_16 | \
            MSG_MASK_20 | MSG_MASK_21 | MSG_MASK_22)
#define MSG_BUILD_MASK_MSG_SSID_LTE_DISCOVERY     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_NR5G              (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_RRC          (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_MACUL        (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_MACDL        (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_MACCTRL      (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_RLCUL        (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_RLCDL        (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_PDCPUL       (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_PDCPDL       (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_ML1          (MSG_BUILD_MASK_DFLT)
#define MSG_BUILD_MASK_MSG_SSID_NR5G_DISCOVERY    (MSG_BUILD_MASK_DFLT)

/* UMTS related SSIDs */

#define MSG_BUILD_MASK_MSG_SSID_UMTS        (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_L1    (MSG_LVL_HIGH | MSG_MASK_5 | MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | \
            MSG_MASK_9 | MSG_MASK_10 | MSG_MASK_11 | MSG_MASK_12 | MSG_MASK_13 | MSG_MASK_14 | MSG_MASK_15 | MSG_MASK_16 | \
            MSG_MASK_20 | MSG_MASK_21 | MSG_MASK_22)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_L2    (MSG_LVL_HIGH | MSG_MASK_5 | MSG_MASK_6)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_MAC   (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_RLC   (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_RRC   (MSG_LVL_HIGH | MSG_MASK_5 | MSG_MASK_6 | MSG_MASK_7)
#define MSG_BUILD_MASK_MSG_SSID_NAS_CNM     (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_MM      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_MN      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_RABM    (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_REG     (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_SM      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_TC      (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_NAS_CB           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_WCDMA_LEVEL      (MSG_LVL_LOW)


/* GSM related SSIDs */

#define MSG_BUILD_MASK_MSG_SSID_GSM              (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_GSM_L1           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_L2           (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_GSM_RR           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GCOMMON (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GLLC    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GMAC    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GPL1    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GRLC    (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GRR     (MSG_LVL_MED|MSG_MASK_5 | MSG_MASK_6 | MSG_MASK_7 | MSG_MASK_8 | MSG_MASK_9)
#define MSG_BUILD_MASK_MSG_SSID_GSM_GPRS_GSNDCP  (MSG_LVL_MED)



#define MSG_BUILD_MASK_MSG_SSID_WLAN                        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_ADP                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_CP                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_FTM                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_OEM                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SEC                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TRP                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_1             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_2             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_3             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_4             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_5             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_6             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_7             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_8             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_9             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESERVED_10            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TL                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_BAL                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SAL                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SSC                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_HDD                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SME                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PE                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_HAL                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SYS                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_VOSS                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_ATHOS                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_WMI                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_HTT                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PS_STA                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PS_IBSS                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PS_AP                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SMPS_STA               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_WHAL                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_COEX                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_ROAM                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RESMGR                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PROTO                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SCAN                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_BATCH_SCAN             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_EXTSCAN                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RC                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_BLOCKACK               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TXRX_DATA              (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TXRX_MGMT              (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_BEACON                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_OFFLOAD_MGR            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MACCORE                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PCIELP                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RTT                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_DCS                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_CACHEMGR               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_ANI                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_P2P                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_CSA                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_NLO                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_CHATTER                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_WOW                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_WMMAC                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TDLS                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_HB                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_TXBF                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_THERMAL                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_DFS                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RMC                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_STATS                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_NAN                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_HIF_UART               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_LPI                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MLME                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_SUPPL                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_ERE                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_OCB                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_PLATFORM               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_RSSI_MONITOR           (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_WPM             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_CSS             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_PPS             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_SCAN_CH_PREDICT (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_MAWC            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_CMC_QMIC        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_HALPHY          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_WLAN_MODULE_ENQ             (MSG_LVL_LOW)


#define MSG_BUILD_MASK_MSG_SSID_ATS              (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MSGR             (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPMGR           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_QTF              (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_FWS              (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_SRCH4            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_CMAPI            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MMAL             (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_QRARB            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_LMTSMGR          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MCS_RESERVED_7   (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_MCS_RESERVED_8   (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_IRATMAN          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_CXM              (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_VSTMR            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_CFCM             (MSG_LVL_LOW | MSG_LVL_MED | MSG_LVL_HIGH | MSG_LVL_ERROR | MSG_LVL_FATAL)

/* DS related SSIDs */

#define MSG_BUILD_MASK_MSG_SSID_DS                (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_RLP            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_PPP            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_TCPIP          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_IS707          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_3GMGR          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_PS             (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_MIP            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_UMTS           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_GPRS           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_GSM            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_SOCKETS        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_ATCOP          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_SIO            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_BCMCS          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_MLRLP          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_RTP            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DS_SIPSTACK       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DS_ROHC           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_DOQOS          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_IPC            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_SHIM           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_ACLPOLICY      (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_APPS           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_MUX            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_3GPP           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_LTE            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_WCDMA          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_ACLPOLICY_APPS (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_HDR            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_IPA            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_EPC            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_APPSRV         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_DS_TX             (MSG_LVL_HIGH)

#define MSG_BUILD_MASK_MSG_SSID_SEC            (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_CRYPTO     (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_SSL        (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_IPSEC      (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_SFS        (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_TEST       (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_CNTAGENT   (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_RIGHTSMGR  (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_ROAP       (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_MEDIAMGR   (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_IDSTORE    (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_IXFILE     (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_IXSQL      (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_IXCOMMON   (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_BCASTCNTAGENT (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_PLAYREADY (MSG_LVL_MED|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_SEC_WIDEVINE  (MSG_LVL_MED|MSG_MASK_5)

/* APPS related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_APPS        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_APPMGR (MSG_LVL_ERROR)
#define MSG_BUILD_MASK_MSG_SSID_APPS_UI     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV    (MSG_LVL_LOW|MSG_MASK_5 | \
             MSG_MASK_6|MSG_MASK_7|MSG_MASK_8|MSG_MASK_9|MSG_MASK_10| \
             MSG_MASK_11|MSG_MASK_12|MSG_MASK_13|MSG_MASK_14|MSG_MASK_15| \
             MSG_MASK_16|MSG_MASK_17|MSG_MASK_18|MSG_MASK_19|MSG_MASK_20| \
             MSG_MASK_21|MSG_MASK_22)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP    (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_STATISTICS  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_VENCODER    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_MODEM       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_UI          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_STACK       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QVP_VDECODER    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_ACM             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_HEAP_PROFILE    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_GENERAL     (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_DEBUG       (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_STATISTICS  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_UI_TASK     (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_MP4_PLAYER  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_AUDIO_TASK  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_VIDEO_TASK  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_STREAMING   (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_MPEG4_TASK  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_FILE_OPS    (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_RTP         (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_RTCP        (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_RTSP        (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_SDP_PARSE   (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_ATOM_PARSE  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_TEXT_TASK   (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_DEC_DSP_IF  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_STREAM_RECORDING  (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_CONFIGURATION     (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QCAMERA               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QCAMCORDER            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_BREW                  (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QDJ                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QDTX                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_QTV_BCAST_FLO   (MSG_LVL_LOW|MSG_MASK_5)
#define MSG_BUILD_MASK_MSG_SSID_APPS_MDP_GENERAL     (MSG_LVL_LOW|MSG_MASK_0| \
          MSG_MASK_1|MSG_MASK_2|MSG_MASK_3|MSG_MASK_4|MSG_MASK_5|MSG_MASK_6)
#define MSG_BUILD_MASK_MSG_SSID_APPS_PBM                   (MSG_LVL_HIGH)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_GENERAL      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_EGL          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_OPENGL       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_DIRECT3D     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_SVG          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_OPENVG       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_2D           (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_QXPROFILER   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_DSP          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_GRP          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_GRAPHICS_MDP          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_CAD                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_DPL               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_FW                (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_SIP               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_REGMGR            (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RTP               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_SDP               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_VS                (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_XDM               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_HOM               (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_IM_ENABLER        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_IMS_CORE          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_FWAPI             (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_SERVICES          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_POLICYMGR         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_PRESENCE          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_QIPCALL           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_SIGCOMP           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_PSVT              (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_UNKNOWN           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_SETTINGS          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_OMX_COMMON                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_CD            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_IM            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_FT            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_IS            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_AUTO_CONFIG   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_RCS_COMMON        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_UT                (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_XML               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_APPS_IMS_COM               (MSG_LVL_MED)

/* ADSP tasks related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_KERNEL          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AFETASK         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VOICEPROCTASK   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VOCDECTASK      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VOCENCTASK      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VIDEOTASK       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VFETASK         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_VIDEOENCTASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_JPEGTASK        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPPTASK       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPLAY0TASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPLAY1TASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPLAY2TASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPLAY3TASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPLAY4TASK    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_LPMTASK         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_DIAGTASK        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDRECTASK      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_AUDPREPROCTASK  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_MODMATHTASK     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_ADSPTASKS_GRAPHICSTASK    (MSG_LVL_LOW)

/* L4 LINUX KERNEL related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_L4LINUX_KERNEL       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4LINUX_KEYPAD       (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4LINUX_APPS         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4LINUX_QDDAEMON     (MSG_LVL_MED)

/* L4 IGUANA related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_IGUANASERVER  (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_EFS2          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_QDMS          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_REX           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_SMMS          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_FRAMEBUFFER   (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_KEYPAD        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_NAMING        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_SDIO          (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_SERIAL        (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_TIMER         (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4IGUANA_TRAMP         (MSG_LVL_MED)

/* L4 AMSS related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_L4AMSS_QDIAG           (MSG_LVL_MED)
#define MSG_BUILD_MASK_MSG_SSID_L4AMSS_APS             (MSG_LVL_MED)

/* QCHAT related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_QCHAT                               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_CAPP                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_CENG                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_CREG                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_CMED                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_CAUTH                         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_QBAL                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_OSAL                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_OEMCUST                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_MULTI_PROC                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCHAT_UPK                           (MSG_LVL_LOW)

/* TDSCDMA related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_TDSCDMA_L1                          (MSG_LVL_LOW|MSG_MASK_5|MSG_MASK_6|MSG_MASK_7|MSG_MASK_8|MSG_MASK_9|MSG_MASK_10|MSG_MASK_11|MSG_MASK_12)
#define MSG_BUILD_MASK_MSG_SSID_TDSCDMA_L2                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TDSCDMA_MAC                         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TDSCDMA_RLC                         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_TDSCDMA_RRC                         (MSG_LVL_LOW)

/* CTA related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_CTA                                 (MSG_LVL_HIGH)

/* QCNEA related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_QCNEA                               (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CAC                           (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_CAS                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_CDE                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_COM                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_LEE                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_QMI                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_CORE_SRM                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_GENERIC                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NETLINK                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NIMS                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NSRM                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NSRM_CORE                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NSRM_GATESM                   (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_NSRM_TRG                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_PLCY                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_PLCY_ANDSF                    (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_TEST                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE                           (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE_BQE                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE_CQE                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE_ICD                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE_IFSEL                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_WQE_IFSELRSM                  (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_ATP                           (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_ATP_PLCY                      (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_QCNEA_ATP_RPRT                      (MSG_LVL_LOW)

/* DPM related SSIDs */
#define MSG_BUILD_MASK_MSG_SSID_DPM                                 (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_COMMON                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_COM                             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_QMI                             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_DSM                             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_CONFIG                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_GENERIC                         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_NETLINK                         (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_FD_MGR                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_CT_MGR                          (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_NSRM                            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_NSRM_CORE                       (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_NSRM_GATESM                     (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_NSRM_TRG                        (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_TEST                            (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_TCM                             (MSG_LVL_LOW)
#define MSG_BUILD_MASK_MSG_SSID_DPM_DM                              (MSG_LVL_LOW)

/* Example: specify a build mask for SSID_FOO */
#if 0
#define MSG_BUILD_MASK_MSG_SSID_FOO       (MSG_LVL_MED | 0x00ff00)
#endif

/*!
@endcond DOXYGEN_BLOAT
*/
#endif /* MSGTGT_H */
