#ifndef EVENT_DEFS_H
#define EVENT_DEFS_H

/*!
@ingroup event_service
@file event_defs.h

@brief
Diagnostic Event Reporting Service ID and Payload Definitions

@details
This file contains all enumeration constants for event Identifiers
(event_id_enum_type) and the typedefines for event payload structures used by
clients of Diagnostic event reporting service.Please refer to 80-V6196-1 for
details.

@note
DO NOT MODIFY THIS FILE WITHOUT PRIOR APPROVAL

Event IDs, by design, are a tightly controlled set of values.  Developers
may not create event IDs at will.

Request new events using the folloiwng process:

 1. Send email to asw.diag.request requesting event ID assignments.
 2. Identify each event needed by name.
 3. Provide a brief description for each event.
 4. Describe the payload and size, if any.

*/

/*=======================================================================
  Copyright (c) 2001-2017 by Qualcomm Technologies, Inc.  All Rights Reserved.
===========================================================================*/

/*===========================================================================
                          Edit History

$Header: //source/qcom/qct/core/api/services/diag/main/latest/event_defs.h#104 $

when       who     what, where, why
--------   ---     ----------------------------------------------------------
10/14/14   xy      Added new events
10/01/14   xy      Added new events
08/21/14   xy      Added new events
08/04/14   xy      Added new events
07/16/14   xy      Added new events
06/18/14   xy      Added new events
05/27/14   xy      Added new events
04/23/14   xy      Added new events
03/31/14   xy      Added new events
02/25/14   xy      Added new events
01/29/14   xy      Added new events
01/14/14   xy      Added new events
11/13/13   xy      Added new events
10/09/13   xy      Added new events
09/25/13   xy      Added new events
09/09/13   sr      Added new events
08/26/13   sr      Added new events
08/09/13   sr      Added new events
07/30/13   sr      Added new events
06/26/13   sr      Added new events
05/08/13   sr      Added new events
03/12/13   sr      Added new events
02/06/13   sr      Added new events
01/22/13   sr      Added new events
11/27/12   sr      Added new events
11/08/12   sr      Added new events
10/31/12   sr      Added new events
10/15/12   sr      Added new events
09/20/12   rh      Added new events
08/29/12   rh      Added new events
08/08/12   rh      Added new events
07/16/12   rh      Added new events
06/06/12   rh      Added new events
03/26/12   rh      Added new events
02/29/12   rh      Added new GSM events
02/03/12   rh      Added SSR power events
01/12/12   rh      Added new events
11/29/11   rh      Added new event
09/14/11   hm      Added new events
08/19/11   hm      Added two new WCDMA events
08/05/11   hm      Reserved new event codes for TDSCDMA
06/13/11   hm      Added new RRC events
06/10/11   hm      Added new event
05/20/11   hm      Added new events for Sensors and Geran
04/29/11   hm      Added new events
04/25/11   hm      Added new events
04/18/11   hm      Added new events for LTE and WCDMA
04/05/11   hm      Added new events for LTE NAS
03/14/11   hm      Added new events for GPS and WCDMA
01/19/11   hm      Added new event for LTE ML1 (Tx Power backoff)
10/07/10   sg      Added new event for LTE ML1
05/21/10   sg      Doxygenated the file
08/24/09   mad     Removed inclusion of customer.h
10/03/08   vg      Updated code to use PACK() vs. PACKED
05/21/01   jal     Removed the #ifndef FEATURE_DIAG_NO_EVENTS -- this stuff
                   still needs to be there, even if the service is turned off.
05/21/01   sfh     Added EVENT_WCDMA_L1_STATE.
05/21/01   lad     Removed version check (now in event.c).
05/08/01   sfh     Merged events dropped when branch was made.  Added ba
                   approved HDR events.
04/17/01   lad     Created file from event.h.

===========================================================================*/

#include "comdef.h"   /* Definitions for byte, word, etc. */

/* -------------------------------------------------------------------------
** Definitions and Declarations
** ------------------------------------------------------------------------- */

/*!
@cond DOXYGEN_BLOAT
*/

typedef enum
{
  EVENT_DROP_ID = 0,

  EVENT_BAND_CLASS_CHANGE                                                        = 0x100, /* 0256 */
  EVENT_CDMA_CH_CHANGE                                                           = 0x101, /* 0257 */
  EVENT_BS_P_REV_CHANGE                                                          = 0x102, /* 0258 */
  EVENT_P_REV_IN_USE_CHANGE                                                      = 0x103, /* 0259 */
  EVENT_SID_CHANGE                                                               = 0x104, /* 0260 */
  EVENT_NID_CHANGE                                                               = 0x105, /* 0261 */
  EVENT_PZID_CHANGE                                                              = 0x106, /* 0262 */
  EVENT_PDE_SESSION_END                                                          = 0x107, /* 0263 */
  EVENT_OP_MODE_CHANGE                                                           = 0x108, /* 0264 */
  EVENT_MESSAGE_RECEIVED                                                         = 0x109, /* 0265 */
  EVENT_MESSAGE_TRANSMITTED                                                      = 0x10A, /* 0266 */
  EVENT_TIMER_EXPIRED                                                            = 0x10B, /* 0267 */
  EVENT_COUNTER_THRESHOLD                                                        = 0x10C, /* 0268 */
  EVENT_CALL_PROCESSING_STATE_CHANGE                                             = 0x10D, /* 0269 */
  EVENT_CALL_CONTROL_INSTANTIATED                                                = 0x10E, /* 0270 */
  EVENT_CALL_CONTROL_STATE_CHANGE                                                = 0x10F, /* 0271 */
  EVENT_CALL_CONTROL_TERMINATED                                                  = 0x110, /* 0272 */
  EVENT_REG_ZONE_CHANGE                                                          = 0x111, /* 0273 */
  EVENT_SLOTTED_MODE_OPERATION                                                   = 0x112, /* 0274 */
  EVENT_QPCH_IN_USE                                                              = 0x113, /* 0275 */
  EVENT_IDLE_HANDOFF                                                             = 0x114, /* 0276 */
  EVENT_ACCESS_HANDOFF                                                           = 0x115, /* 0277 */
  EVENT_ACCESS_PROBE_HANDOFF                                                     = 0x116, /* 0278 */
  EVENT_SOFT_HANDOFF                                                             = 0x117, /* 0279 */
  EVENT_HARD_HANDOFF_FREQ_CHANGE                                                 = 0x118, /* 0280 */
  EVENT_HARD_HANDOFF_FRAME_OFFSET_CHANGE                                         = 0x119, /* 0281 */
  EVENT_HARD_HANDOFF_DISJOINT_ASET                                               = 0x11A, /* 0282 */
  EVENT_UNSUCCESSFUL_HARD_HANDOFF                                                = 0x11B, /* 0283 */
  EVENT_TMSI_ASSIGNED                                                            = 0x11C, /* 0284 */
  EVENT_SERVICE_NEGOTIATION_COMPLETED                                            = 0x11D, /* 0285 */
  EVENT_SO_NEGOTIATION_COMPLETED                                                 = 0x11E, /* 0286 */
  EVENT_ENTER_CONTROL_HOLD_MODE                                                  = 0x11F, /* 0287 */
  EVENT_EXIT_CONTROL_HOLD_MODE                                                   = 0x120, /* 0288 */
  EVENT_START_FWD_SUPP_BURST_ASSGN                                               = 0x121, /* 0289 */
  EVENT_END_FWD_SUPP_BURST_ASSGN                                                 = 0x122, /* 0290 */
  EVENT_START_REV_SUPP_BURST_ASSGN                                               = 0x123, /* 0291 */
  EVENT_END_REV_SUPP_BURST_ASSGN                                                 = 0x124, /* 0292 */
  EVENT_DTX                                                                      = 0x125, /* 0293 */
  EVENT_T_ADD_ABORT                                                              = 0x126, /* 0294 */
  EVENT_CH_IND_CHANGE                                                            = 0x127, /* 0295 */
  EVENT_TRANSMITTER_DISABLED                                                     = 0x128, /* 0296 */
  EVENT_TRANSMITTER_ENABLED                                                      = 0x129, /* 0297 */
  EVENT_SMS_RECEIVED                                                             = 0x12A, /* 0298 */
  EVENT_SMS_SENT                                                                 = 0x12B, /* 0299 */
  EVENT_INACTIVITY_TIMER_EXPIRED                                                 = 0x12C, /* 0300 */
  EVENT_DORMANT_TIMER_EXPIRED                                                    = 0x12D, /* 0301 */
  EVENT_ACCESS_ATTEMPT_FAIL_MAX_PROBES_SENT                                      = 0x12E, /* 0302 */
  EVENT_ACCESS_ATTEMPT_FAIL_LOSS_OF_PC_OR_FCCC                                   = 0x12F, /* 0303 */
  EVENT_PCH_ACQUIRED                                                             = 0x130, /* 0304 */
  EVENT_BCCH_ACQUIRED                                                            = 0x131, /* 0305 */
  EVENT_FFCH_ACQUIRED                                                            = 0x132, /* 0306 */
  EVENT_FDCCH_ACQUIRED                                                           = 0x133, /* 0307 */
  EVENT_FFCH_PLUS_DCCH_ACQUIRED                                                  = 0x134, /* 0308 */
  EVENT_REGISTRATION_PERFORMED                                                   = 0x135, /* 0309 */
  EVENT_NEW_SYSTEM_IDLE_HANDOFF                                                  = 0x136, /* 0310 */
  EVENT_SYSTEM_RESELECTION                                                       = 0x137, /* 0311 */
  EVENT_RESCAN                                                                   = 0x138, /* 0312 */
  EVENT_PROTOCOL_MISMATCH                                                        = 0x139, /* 0313 */
  EVENT_LOCK                                                                     = 0x13A, /* 0314 */
  EVENT_UNLOCK                                                                   = 0x13B, /* 0315 */
  EVENT_ACCESS_DENIED                                                            = 0x13C, /* 0316 */
  EVENT_NDSS_OFF                                                                 = 0x13D, /* 0317 */
  EVENT_RELEASE                                                                  = 0x13E, /* 0318 */
  EVENT_ERROR                                                                    = 0x13F, /* 0319 */
  EVENT_REDIRECTION                                                              = 0x140, /* 0320 */
  EVENT_REGISTRATION_REJECTED                                                    = 0x141, /* 0321 */
  EVENT_WRONG_SYSTEM                                                             = 0x142, /* 0322 */
  EVENT_WRONG_NETWORK                                                            = 0x143, /* 0323 */
  EVENT_LOSS_OF_ACQ_AFTER_SLEEP                                                  = 0x144, /* 0324 */
  EVENT_POWER_DOWN                                                               = 0x145, /* 0325 */
  EVENT_CALL_RELEASE_REQUEST                                                     = 0x146, /* 0326 */
  EVENT_SERVICE_INACTIVE                                                         = 0x147, /* 0327 */
  EVENT_EXTENDED_RELEASE                                                         = 0x148, /* 0328 */
  EVENT_HDR_MSG_RX                                                               = 0x149, /* 0329 */
  EVENT_HDR_RXMSG_IGNORED_STATE                                                  = 0x14A, /* 0330 */
  EVENT_HDR_RXMSG_IGNORED_SEQ                                                    = 0x14B, /* 0331 */
  EVENT_HDR_TXMSG_ACKED                                                          = 0x14C, /* 0332 */
  EVENT_HDR_TXMSG_DROPPED                                                        = 0x14D, /* 0333 */
  EVENT_HDR_STATE_CHANGE                                                         = 0x14E, /* 0334 */
  EVENT_HDR_ALMP_OBEYING_REDIRECTION                                             = 0x14F, /* 0335 */
  EVENT_HDR_ALMP_CONNECTION_CLOSED                                               = 0x150, /* 0336 */
  EVENT_HDR_ALMP_T_SD_RESELECT                                                   = 0x151, /* 0337 */
  EVENT_HDR_ALMP_CONNECTION_OPENED                                               = 0x152, /* 0338 */
  EVENT_HDR_HMP_QUEUED_MSG                                                       = 0x153, /* 0339 */
  EVENT_HDR_HMP_SENT_MSG                                                         = 0x154, /* 0340 */
  EVENT_HDR_HMP_ABORTING_ACMAC_ACTIVATION                                        = 0x155, /* 0341 */
  EVENT_HDR_IDLE_T_CONFIG_RSP                                                    = 0x156, /* 0342 */
  EVENT_HDR_IDLE_T_AT_SETUP                                                      = 0x157, /* 0343 */
  EVENT_HDR_IDLE_T_SUSPEND                                                       = 0x158, /* 0344 */
  EVENT_HDR_IDLE_CONNECTION_DENIED                                               = 0x159, /* 0345 */
  EVENT_HDR_INIT_T_SYNC_ACQ                                                      = 0x15A, /* 0346 */
  EVENT_HDR_INIT_PROTOCOL_MISMATCH                                               = 0x15B, /* 0347 */
  EVENT_HDR_OVHD_INFO_CURRENT                                                    = 0x15C, /* 0348 */
  EVENT_HDR_OVHD_T_QC_SUPERVISION                                                = 0x15D, /* 0349 */
  EVENT_HDR_OVHD_T_SP_SUPERVISION                                                = 0x15E, /* 0350 */
  EVENT_HDR_OVHD_T_AP_SUPERVISION                                                = 0x15F, /* 0351 */
  EVENT_HDR_OVHD_IGNORED_MSG_UNEXPECTED_LINK                                     = 0x160, /* 0352 */
  EVENT_HDR_OVHD_IGNORED_SP_MSG_DIFF_SEC_SIG                                     = 0x161, /* 0353 */
  EVENT_HDR_OVHD_IGNORED_AP_MSG_DIFF_ACC_SIG                                     = 0x162, /* 0354 */
  EVENT_HDR_OVHD_IGNORED_SP_MSG_DIFF_SEC_ID                                      = 0x163, /* 0355 */
  EVENT_HDR_OVHD_SP_MSG_RX                                                       = 0x164, /* 0356 */
  EVENT_HDR_OVHD_AP_MSG_RX                                                       = 0x165, /* 0357 */
  EVENT_HDR_RUP_T_CONNECTION_SETUP                                               = 0x166, /* 0358 */
  EVENT_HDR_SLP_MAX_RETRIES                                                      = 0x167, /* 0359 */
  EVENT_HDR_LMAC_ACQ_FAIL_PILOT                                                  = 0x168, /* 0360 */
  EVENT_HDR_LMAC_ACQ_SUCCESS                                                     = 0x169, /* 0361 */
  EVENT_HDR_LMAC_NETWORK_LOST                                                    = 0x16A, /* 0362 */
  EVENT_HDR_LMAC_IDLE_HO                                                         = 0x16B, /* 0363 */
  EVENT_HDR_LMAC_CHAN_CHANGE_COMPLETE                                            = 0x16C, /* 0364 */
  EVENT_HDR_LMAC_ACCESS_HO_NEEDED                                                = 0x16D, /* 0365 */
  EVENT_HDR_LMAC_ACCESS_HO_COMPLETE                                              = 0x16E, /* 0366 */
  EVENT_HDR_LMAC_ACQUIRE                                                         = 0x16F, /* 0367 */
  EVENT_HDR_LMAC_CHANGING_CC_HASH                                                = 0x170, /* 0368 */
  EVENT_HDR_LMAC_IDLE_CHAN_CHANGE                                                = 0x171, /* 0369 */
  EVENT_HDR_CMAC_T_SUPERVISION                                                   = 0x172, /* 0370 */
  EVENT_HDR_AMAC_START_ACCESS                                                    = 0x173, /* 0371 */
  EVENT_HDR_AMAC_PROBING_STOPPED                                                 = 0x174, /* 0372 */
  EVENT_HDR_AMAC_ACCESS_COMPLETE                                                 = 0x175, /* 0373 */
  EVENT_HDR_AMAC_ACCESS_ABORTED                                                  = 0x176, /* 0374 */
  EVENT_HDR_AMAC_MAX_PROBES                                                      = 0x177, /* 0375 */
  EVENT_HDR_FMAC_DROP_PKT                                                        = 0x178, /* 0376 */
  EVENT_HDR_RMAC_T_RATE_LIMIT                                                    = 0x179, /* 0377 */
  EVENT_HDR_RMAC_TX_STARTED                                                      = 0x17A, /* 0378 */
  EVENT_HDR_RMAC_TX_STOPPED                                                      = 0x17B, /* 0379 */
  EVENT_HDR_SMP_T_KEEP_ALIVE                                                     = 0x17C, /* 0380 */
  EVENT_HDR_AMP_ASSIGN_MSG_IGNORED_FRESH                                         = 0x17D, /* 0381 */
  EVENT_HDR_AMP_T_AT_RESPONSE                                                    = 0x17E, /* 0382 */
  EVENT_HDR_AMP_T_DUAL_ADDRESS                                                   = 0x17F, /* 0383 */
  EVENT_HDR_SCP_BEGIN_CONFIGURATION                                              = 0x180, /* 0384 */
  EVENT_HDR_SCP_T_CONFIG_RSP                                                     = 0x181, /* 0385 */
  EVENT_HDR_SCP_T_AN_INIT_STATE                                                  = 0x182, /* 0386 */
  EVENT_WCDMA_L1_STATE                                                           = 0x183, /* 0387 */
  EVENT_WCDMA_IMSI                                                               = 0x184, /* 0388 */
  EVENT_GSM_L1_STATE                                                             = 0x185, /* 0389 */
  EVENT_RANDOM_ACCESS_REQUEST                                                    = 0x186, /* 0390 */
  EVENT_HIGH_LEVEL_CALL_PROCESSING_STATE_CHANGE                                  = 0x187, /* 0391 */
  EVENT_ENCRYPTION_FAILURE                                                       = 0x188, /* 0392 */
  EVENT_ACCT_BLOCKED                                                             = 0x189, /* 0393 */
  EVENT_COMMON_CHANNEL_MONITORED                                                 = 0x18A, /* 0394 */
  EVENT_SOFT_HANDOFF_V2                                                          = 0x18B, /* 0395 */
  EVENT_HARD_HANDOFF_FREQ_CHANGE_V2                                              = 0x18C, /* 0396 */
  EVENT_HARD_HANDOFF_FRAME_OFFSET_CHANGE_V2                                      = 0x18D, /* 0397 */
  EVENT_HARD_HANDOFF_DISJOINT_ASET_V2                                            = 0x18E, /* 0398 */
  EVENT_WCDMA_NEW_REFERENCE_CELL                                                 = 0x18F, /* 0399 */
  EVENT_CALL_CONTROL_CONREF_CHANGE                                               = 0x190, /* 0400 */
  EVENT_GPS_SESSION_BEGIN                                                        = 0x191, /* 0401 */
  EVENT_GPS_SESSION_END                                                          = 0x192, /* 0402 */
  EVENT_GPS_WAITING_ON_SA                                                        = 0x193, /* 0403 */
  EVENT_GPS_PPM_START                                                            = 0x194, /* 0404 */
  EVENT_GPS_PPM_RESULTS                                                          = 0x195, /* 0405 */
  EVENT_GPS_PPM_END                                                              = 0x196, /* 0406 */
  EVENT_GPS_VISIT_BEGIN                                                          = 0x197, /* 0407 */
  EVENT_GPS_VISIT_END                                                            = 0x198, /* 0408 */
  EVENT_GPS_CDMA_RESUMED_AFTER_GPS_VISIT                                         = 0x199, /* 0409 */
  EVENT_GPS_PD_SESSION_BEGIN                                                     = 0x19A, /* 0410 */
  EVENT_GPS_PD_SESSION_END                                                       = 0x19B, /* 0411 */
  EVENT_GPS_IS801_RX                                                             = 0x19C, /* 0412 */
  EVENT_GPS_IS801_TX                                                             = 0x19D, /* 0413 */
  EVENT_POWERUP                                                                  = 0x19E, /* 0414 */
  EVENT_WCDMA_ASET                                                               = 0x19F, /* 0415 */
  EVENT_CM_CALL_STATE                                                            = 0x1A0, /* 0416 */
  EVENT_CM_OPERATIONAL_MODE                                                      = 0x1A1, /* 0417 */
  EVENT_CM_SYSTEM_MODE                                                           = 0x1A2, /* 0418 */
  EVENT_DEEP_SLEEP                                                               = 0x1A3, /* 0419 */
  EVENT_WAKEUP                                                                   = 0x1A4, /* 0420 */
  EVENT_ACQUISITION_MODE                                                         = 0x1A5, /* 0421 */
  EVENT_ACQUISITION_TYPE                                                         = 0x1A6, /* 0422 */
  EVENT_ACP_EXIT                                                                 = 0x1A7, /* 0423 */
  EVENT_CDMA_EXIT                                                                = 0x1A8, /* 0424 */
  EVENT_HDR_HYBRID_POWER_SAVE                                                    = 0x1A9, /* 0425 */
  EVENT_HDR_DEEP_SLEEP                                                           = 0x1AA, /* 0426 */
  EVENT_HDR_RESELECTION                                                          = 0x1AB, /* 0427 */
  EVENT_SAM_LOCK_GRANTED                                                         = 0x1AC, /* 0428 */
  EVENT_SAM_LOCK_RELEASED                                                        = 0x1AD, /* 0429 */
  EVENT_GSM_HANDOVER_START                                                       = 0x1AE, /* 0430 */
  EVENT_GSM_HANDOVER_END                                                         = 0x1AF, /* 0431 */
  EVENT_GSM_LINK_FAILURE                                                         = 0x1B0, /* 0432 */
  EVENT_GSM_RESELECT_START                                                       = 0x1B1, /* 0433 */
  EVENT_GSM_RESELECT_END                                                         = 0x1B2, /* 0434 */
  EVENT_GSM_CAMP_ATTEMPT_START                                                   = 0x1B3, /* 0435 */
  EVENT_GSM_RR_IN_SERVICE                                                        = 0x1B4, /* 0436 */
  EVENT_GSM_RR_OUT_OF_SERVICE                                                    = 0x1B5, /* 0437 */
  EVENT_GSM_PAGE_RECEIVED                                                        = 0x1B6, /* 0438 */
  EVENT_GSM_CAMP_ATTEMPT_END                                                     = 0x1B7, /* 0439 */
  EVENT_GPS_IS801_TIMEOUT                                                        = 0x1B8, /* 0440 */
  EVENT_GPS_IS801_DISCARD                                                        = 0x1B9, /* 0441 */
  EVENT_GSM_CELL_SELECTION_START                                                 = 0x1BA, /* 0442 */
  EVENT_GSM_CELL_SELECTION_END                                                   = 0x1BB, /* 0443 */
  EVENT_GSM_POWER_SCAN_STATUS                                                    = 0x1BC, /* 0444 */
  EVENT_GSM_PLMN_LIST_START                                                      = 0x1BD, /* 0445 */
  EVENT_GSM_PLMN_LIST_END                                                        = 0x1BE, /* 0446 */
  EVENT_WCDMA_INTER_RAT_HANDOVER_START                                           = 0x1BF, /* 0447 */
  EVENT_WCDMA_INTER_RAT_HANDOVER_END                                             = 0x1C0, /* 0448 */
  EVENT_GSM_MESSAGE_SENT                                                         = 0x1C1, /* 0449 */
  EVENT_GSM_MESSAGE_RECEIVED                                                     = 0x1C2, /* 0450 */
  EVENT_GSM_TIMER_EXPIRED                                                        = 0x1C3, /* 0451 */
  EVENT_GSM_COUNTER_EXPIRED                                                      = 0x1C4, /* 0452 */
  EVENT_NAS_MESSAGE_SENT                                                         = 0x1C5, /* 0453 */
  EVENT_NAS_MESSAGE_RECEIVED                                                     = 0x1C6, /* 0454 */
  EVENT_RRC_MESSAGE_SENT                                                         = 0x1C7, /* 0455 */
  EVENT_RRC_MESSAGE_RECEIVED                                                     = 0x1C8, /* 0456 */
  EVENT_CAMERA_CANNOT_CAPTURE                                                    = 0x1C9, /* 0457 */
  EVENT_CAMERA_CANNOT_CONFIG_JPEG                                                = 0x1CA, /* 0458 */
  EVENT_CAMERA_CANNOT_CONFIG_VFE                                                 = 0x1CB, /* 0459 */
  EVENT_CAMERA_CANNOT_ENCODE                                                     = 0x1CC, /* 0460 */
  EVENT_CAMERA_CANNOT_IDLE_DSP                                                   = 0x1CD, /* 0461 */
  EVENT_CAMERA_CANNOT_LOAD_DSP                                                   = 0x1CE, /* 0462 */
  EVENT_CAMERA_DSP_FATAL                                                         = 0x1CF, /* 0463 */
  EVENT_CAMERA_DSP_REQ_ILLEGAL                                                   = 0x1D0, /* 0464 */
  EVENT_CAMERA_EFS_FAILED                                                        = 0x1D1, /* 0465 */
  EVENT_CAMERA_EXIT                                                              = 0x1D2, /* 0466 */
  EVENT_CAMERA_FORMAT_NOT_SUPPORTED                                              = 0x1D3, /* 0467 */
  EVENT_CAMERA_FUNCTION_REJECTED                                                 = 0x1D4, /* 0468 */
  EVENT_CAMERA_IMAGE_CORRUPT                                                     = 0x1D5, /* 0469 */
  EVENT_CAMERA_INVALID_CONFIG_PARM                                               = 0x1D6, /* 0470 */
  EVENT_CAMERA_INVALID_SET_ID                                                    = 0x1D7, /* 0471 */
  EVENT_CAMERA_INVALID_STATE                                                     = 0x1D8, /* 0472 */
  EVENT_CAMERA_JPEG_ENCODED                                                      = 0x1D9, /* 0473 */
  EVENT_CAMERA_NO_MEMORY                                                         = 0x1DA, /* 0474 */
  EVENT_CAMERA_NO_PICTURE                                                        = 0x1DB, /* 0475 */
  EVENT_CAMERA_PICTURE_SAVED                                                     = 0x1DC, /* 0476 */
  EVENT_CAMERA_PICTURE_TAKEN                                                     = 0x1DD, /* 0477 */
  EVENT_CAMERA_PREVIEW                                                           = 0x1DE, /* 0478 */
  EVENT_CAMERA_RECORD                                                            = 0x1DF, /* 0479 */
  EVENT_CAMERA_SAVE_PICTURE                                                      = 0x1E0, /* 0480 */
  EVENT_CAMERA_SET_FAILED                                                        = 0x1E1, /* 0481 */
  EVENT_CAMERA_SET_SUCCEEDED                                                     = 0x1E2, /* 0482 */
  EVENT_CAMERA_START                                                             = 0x1E3, /* 0483 */
  EVENT_CAMERA_STOP                                                              = 0x1E4, /* 0484 */
  EVENT_CAMERA_TAKE_PICTURE                                                      = 0x1E5, /* 0485 */
  EVENT_DIAG_STRESS_TEST_NO_PAYLOAD                                              = 0x1E6, /* 0486 */
  EVENT_DIAG_STRESS_TEST_WITH_PAYLOAD                                            = 0x1E7, /* 0487 */
  EVENT_CM_CALL_ORIG_START_P1                                                    = 0x1E8, /* 0488 */
  EVENT_CM_CALL_ORIG_START_P2                                                    = 0x1E9, /* 0489 */
  EVENT_CM_CALL_ORIG_START_P3                                                    = 0x1EA, /* 0490 */
  EVENT_CM_CALL_ORIG_SWITCH_TO_HDR                                               = 0x1EB, /* 0491 */
  EVENT_CM_CALL_ORIG_REDIAL                                                      = 0x1EC, /* 0492 */
  EVENT_CM_CALL_ORIG_SEND_HDR_ORIG                                               = 0x1ED, /* 0493 */
  EVENT_CM_CALL_ORIG_SEND_MC_ORIG                                                = 0x1EE, /* 0494 */
  EVENT_CM_CALL_ORIG_END                                                         = 0x1EF, /* 0495 */
  EVENT_CM_CALL_ORIG_CONNECTED                                                   = 0x1F0, /* 0496 */
  EVENT_MT_SMS_NOTIFY                                                            = 0x1F1, /* 0497 */
  EVENT_SMS_SLOT_WAKEUP                                                          = 0x1F2, /* 0498 */
  EVENT_MO_SMS_STATUS                                                            = 0x1F3, /* 0499 */
  EVENT_GPRS_SURROUND_SEARCH_START                                               = 0x1F4, /* 0500 */
  EVENT_GPRS_SURROUND_SEARCH_END                                                 = 0x1F5, /* 0501 */
  EVENT_GPRS_MAC_RESELECT_IND                                                    = 0x1F6, /* 0502 */
  EVENT_GPRS_PAGE_RECEIVED                                                       = 0x1F7, /* 0503 */
  EVENT_GPRS_LINK_FAILURE                                                        = 0x1F8, /* 0504 */
  EVENT_GPRS_CELL_UPDATE_START                                                   = 0x1F9, /* 0505 */
  EVENT_GPRS_CELL_UPDATE_END                                                     = 0x1FA, /* 0506 */
  EVENT_GPRS_EARLY_CAMPING                                                       = 0x1FB, /* 0507 */
  EVENT_PACKET_RANDOM_ACCESS_REQ                                                 = 0x1FC, /* 0508 */
  EVENT_GPRS_MAC_MSG_SENT                                                        = 0x1FD, /* 0509 */
  EVENT_GPRS_MAC_MSG_RECEIVED                                                    = 0x1FE, /* 0510 */
  EVENT_GPRS_SMGMM_MSG_SENT                                                      = 0x1FF, /* 0511 */
  EVENT_GPRS_SMGMM_MSG_RECEIVED                                                  = 0x200, /* 0512 */
  EVENT_CP_MATCHED_MSG                                                           = 0x201, /* 0513 */
  EVENT_PREF_SYS_RESEL                                                           = 0x202, /* 0514 */
  EVENT_WCDMA_LAYER1_PRACH                                                       = 0x203, /* 0515 */
  EVENT_WCDMA_LAYER1_MEASUREMENT                                                 = 0x204, /* 0516 */
  EVENT_MOBILITY_MANAGEMENT_STATE_CHANGE                                         = 0x205, /* 0517 */
  EVENT_LSM_STATE_CHANGE                                                         = 0x206, /* 0518 */
  EVENT_RLP                                                                      = 0x207, /* 0519 */
  EVENT_CM_MODE_PREF                                                             = 0x208, /* 0520 */
  EVENT_CM_BAND_PREF                                                             = 0x209, /* 0521 */
  EVENT_CM_ROAM_PREF                                                             = 0x20A, /* 0522 */
  EVENT_CM_SRV_DOMAIN_PREF                                                       = 0x20B, /* 0523 */
  EVENT_CM_GW_ACQ_ORDER_PREF                                                     = 0x20C, /* 0524 */
  EVENT_CM_HYBRID_PREF                                                           = 0x20D, /* 0525 */
  EVENT_CM_NETWORK_SEL_MODE_PREF                                                 = 0x20E, /* 0526 */
  EVENT_WCDMA_L1_SUSPEND                                                         = 0x20F, /* 0527 */
  EVENT_WCDMA_L1_RESUME                                                          = 0x210, /* 0528 */
  EVENT_WCDMA_L1_STOPPED                                                         = 0x211, /* 0529 */
  EVENT_WCDMA_TO_WCDMA_RESELECTION_START                                         = 0x212, /* 0530 */
  EVENT_WCDMA_TO_GSM_RESELECTION_START                                           = 0x213, /* 0531 */
  EVENT_WCDMA_TO_GSM_RESELECTION_END                                             = 0x214, /* 0532 */
  EVENT_WCDMA_TO_WCDMA_RESELECTION_END                                           = 0x215, /* 0533 */
  EVENT_WCDMA_RACH_ATTEMPT                                                       = 0x216, /* 0534 */
  EVENT_START_FWD_SUPP_BURST_ASSIGN                                              = 0x217, /* 0535 */
  EVENT_START_REV_SUPP_BURST_ASSIGN                                              = 0x218, /* 0536 */
  EVENT_REV_FCH_GATING_IN_USE                                                    = 0x219, /* 0537 */
  EVENT_PPP                                                                      = 0x21A, /* 0538 */
  EVENT_MIP                                                                      = 0x21B, /* 0539 */
  EVENT_TCP                                                                      = 0x21C, /* 0540 */
  EVENT_CAMERA_EXIF_FAILED                                                       = 0x21D, /* 0541 */
  EVENT_CAMERA_VIDEO_FAILED                                                      = 0x21E, /* 0542 */
  EVENT_CAMERA_NO_SENSOR                                                         = 0x21F, /* 0543 */
  EVENT_CAMERA_ABORT                                                             = 0x220, /* 0544 */
  EVENT_CM_BLOCK_HDR_ORIG_DURING_GPS                                             = 0x221, /* 0545 */
  EVENT_CM_ALLOW_HDR_ORIG_DURING_GPS                                             = 0x222, /* 0546 */
  EVENT_GSM_AMR_STATE_CHANGE                                                     = 0x223, /* 0547 */
  EVENT_GSM_RATSCCH_IN_DTX                                                       = 0x224, /* 0548 */
  EVENT_GSM_FACCH_IN_DTX                                                         = 0x225, /* 0549 */
  EVENT_GSM_FACCH_AND_RATSCCH_COLLISION                                          = 0x226, /* 0550 */
  EVENT_GSM_FACCH_AND_SID_UPDATE_COLLISION                                       = 0x227, /* 0551 */
  EVENT_GSM_RATSCCH_AND_SID_UPDATE_COLLISION                                     = 0x228, /* 0552 */
  EVENT_GSM_RATSCCH_CMI_PHASE_CHANGE                                             = 0x229, /* 0553 */
  EVENT_GSM_RATSCCH_REQ_ACT_TIMER_EXPIRY                                         = 0x22A, /* 0554 */
  EVENT_GSM_RATSCCH_ACK_ACT_TIMER_EXPIRY                                         = 0x22B, /* 0555 */
  EVENT_GSM_AMR_CMC_TURNAROUND_TIME                                              = 0x22C, /* 0556 */
  EVENT_CM_PLMN_FOUND                                                            = 0x22D, /* 0557 */
  EVENT_CM_SERVICE_CONFIRMED                                                     = 0x22E, /* 0558 */
  EVENT_GPRS_MAC_CAMPED_ON_CELL                                                  = 0x22F, /* 0559 */
  EVENT_GPRS_LLC_READY_TIMER_START                                               = 0x230, /* 0560 */
  EVENT_GPRS_LLC_READY_TIMER_END                                                 = 0x231, /* 0561 */
  EVENT_WCDMA_PHYCHAN_ESTABLISHED                                                = 0x232, /* 0562 */
  EVENT_HS_DISPLAY_BMP_CAPTURE_STATUS                                            = 0x233, /* 0563 */
  EVENT_WCDMA_CELL_SELECTED                                                      = 0x234, /* 0564 */
  EVENT_WCDMA_PAGE_RECEIVED                                                      = 0x235, /* 0565 */
  EVENT_WCDMA_SEND_KEY                                                           = 0x236, /* 0566 */
  EVENT_WCDMA_RL_FAILURE                                                         = 0x237, /* 0567 */
  EVENT_WCDMA_MAX_RESET                                                          = 0x238, /* 0568 */
  EVENT_WCDMA_CALL_SETUP                                                         = 0x239, /* 0569 */
  EVENT_WCDMA_CALL_DROPPED                                                       = 0x23A, /* 0570 */
  EVENT_WCDMA_RRC_STATE                                                          = 0x23B, /* 0571 */
  EVENT_GPS_PD_CONNECTION_TIMEOUT                                                = 0x23C, /* 0572 */
  EVENT_GPS_PD_DISCONNECTION_COMPLETE                                            = 0x23D, /* 0573 */
  EVENT_MEDIA_PLAYER_START                                                       = 0x23E, /* 0574 */
  EVENT_MEDIA_PLAYER_STOP                                                        = 0x23F, /* 0575 */
  EVENT_MEDIA_PLAYER_SEEK                                                        = 0x240, /* 0576 */
  EVENT_GPS_SRCH_START                                                           = 0x241, /* 0577 */
  EVENT_GPS_SRCH_END                                                             = 0x242, /* 0578 */
  EVENT_GPS_PPM_PAUSE                                                            = 0x243, /* 0579 */
  EVENT_GPS_PPM_RESUME                                                           = 0x244, /* 0580 */
  EVENT_GPS_SA_RECEIVED                                                          = 0x245, /* 0581 */
  EVENT_GPS_CLK_ON                                                               = 0x246, /* 0582 */
  EVENT_GPS_CLK_OFF                                                              = 0x247, /* 0583 */
  EVENT_GPS_VISIT_REQUEST                                                        = 0x248, /* 0584 */
  EVENT_GPS_VISIT_RESPONSE                                                       = 0x249, /* 0585 */
  EVENT_GPS_TA_START                                                             = 0x24A, /* 0586 */
  EVENT_GPS_DSP_READY                                                            = 0x24B, /* 0587 */
  EVENT_GPS_DSP_CHANNEL_START                                                    = 0x24C, /* 0588 */
  EVENT_GPS_DSP_CHANNEL_DONE                                                     = 0x24D, /* 0589 */
  EVENT_GPS_DSP_STOP                                                             = 0x24E, /* 0590 */
  EVENT_GPS_DSP_DONE                                                             = 0x24F, /* 0591 */
  EVENT_GPS_TB_END                                                               = 0x250, /* 0592 */
  EVENT_GPS_SRCH_LARGE_DOPP_WIN                                                  = 0x251, /* 0593 */
  EVENT_GPS_SRCH_EXCEPTION                                                       = 0x252, /* 0594 */
  EVENT_GPS_SRCH_HW_POLLING1                                                     = 0x253, /* 0595 */
  EVENT_GPS_SRCH_HW_POLLING2                                                     = 0x254, /* 0596 */
  EVENT_GPS_PGI_ACTION_PROCESS                                                   = 0x255, /* 0597 */
  EVENT_GPS_GSC_ACTION_PROCESS                                                   = 0x256, /* 0598 */
  EVENT_GPS_PGI_ABORT                                                            = 0x257, /* 0599 */
  EVENT_GPS_GSC_ABORT                                                            = 0x258, /* 0600 */
  EVENT_GPS_PD_FIX_START                                                         = 0x259, /* 0601 */
  EVENT_GPS_PD_FIX_END                                                           = 0x25A, /* 0602 */
  EVENT_GPS_DATA_DOWNLOAD_START                                                  = 0x25B, /* 0603 */
  EVENT_GPS_DATA_DOWNLOAD_END                                                    = 0x25C, /* 0604 */
  EVENT_GPS_PD_SESSION_START                                                     = 0x25D, /* 0605 */
  EVENT_GPS_DORMANCY_BEGIN                                                       = 0x25E, /* 0606 */
  EVENT_GPS_DORMANCY_END                                                         = 0x25F, /* 0607 */
  EVENT_GPS_PRQ_TIMEOUT                                                          = 0x260, /* 0608 */
  EVENT_GPS_PD_CONNECTION_START                                                  = 0x261, /* 0609 */
  EVENT_GPS_PD_CONNECTION_ESTABLISHED                                            = 0x262, /* 0610 */
  EVENT_GPS_PD_DISCONNECTION_START                                               = 0x263, /* 0611 */
  EVENT_GPS_FTEST_FIX_START                                                      = 0x264, /* 0612 */
  EVENT_GPS_FTEST_FIX_END                                                        = 0x265, /* 0613 */
  EVENT_GPS_PD_POSITION                                                          = 0x266, /* 0614 */
  EVENT_GPS_E911_START                                                           = 0x267, /* 0615 */
  EVENT_GPS_E911_END                                                             = 0x268, /* 0616 */
  EVENT_GPS_DBM_SEND_FAILURE                                                     = 0x269, /* 0617 */
  EVENT_GPS_UAPDMS_STATE_CHANGE                                                  = 0x26A, /* 0618 */
  EVENT_WCDMA_OUT_OF_SERVICE                                                     = 0x26B, /* 0619 */
  EVENT_GSM_L1_SUBSTATE                                                          = 0x26C, /* 0620 */
  EVENT_SD_EVENT_ACTION                                                          = 0x26D, /* 0621 */
  EVENT_SD_EVENT_ACTION_HYBR                                                     = 0x26E, /* 0622 */
  EVENT_UMTS_CALLS_STATISTICS                                                    = 0x26F, /* 0623 */
  EVENT_PZID_HAT_STARTED                                                         = 0x270, /* 0624 */
  EVENT_WCDMA_DRX_CYCLE                                                          = 0x271, /* 0625 */
  EVENT_WCDMA_RE_ACQUISITION_FAIL                                                = 0x272, /* 0626 */
  EVENT_WCDMA_RRC_RB0_SETUP_FAILURE                                              = 0x273, /* 0627 */
  EVENT_WCDMA_RRC_PHYCHAN_EST_FAILURE                                            = 0x274, /* 0628 */
  EVENT_CM_CALL_EVENT_ORIG                                                       = 0x275, /* 0629 */
  EVENT_CM_CALL_EVENT_CONNECT                                                    = 0x276, /* 0630 */
  EVENT_CM_CALL_EVENT_END                                                        = 0x277, /* 0631 */
  EVENT_CM_ENTER_EMERGENCY_CB                                                    = 0x278, /* 0632 */
  EVENT_CM_EXIT_EMERGENCY_CB                                                     = 0x279, /* 0633 */
  EVENT_PZID_HAT_EXPIRED                                                         = 0x27A, /* 0634 */
  EVENT_HDR_SMP_SESSION_CLOSED                                                   = 0x27B, /* 0635 */
  EVENT_WCDMA_MEMORY_LEAK                                                        = 0x27C, /* 0636 */
  EVENT_PZID_HT_STARTED                                                          = 0x27D, /* 0637 */
  EVENT_PZID_HT_EXPIRED                                                          = 0x27E, /* 0638 */
  EVENT_ACCESS_ENTRY_HANDOFF                                                     = 0x27F, /* 0639 */
  EVENT_BREW_APP_START                                                           = 0x280, /* 0640 */
  EVENT_BREW_APP_STOP                                                            = 0x281, /* 0641 */
  EVENT_BREW_APP_PAUSE                                                           = 0x282, /* 0642 */
  EVENT_BREW_APP_RESUME                                                          = 0x283, /* 0643 */
  EVENT_BREW_EXT_MODULE_START                                                    = 0x284, /* 0644 */
  EVENT_BREW_EXT_MODULE_STOP                                                     = 0x285, /* 0645 */
  EVENT_BREW_ERROR                                                               = 0x286, /* 0646 */
  EVENT_BREW_RESERVED_647                                                        = 0x287, /* 0647 */
  EVENT_BREW_RESERVED_648                                                        = 0x288, /* 0648 */
  EVENT_BREW_RESERVED_649                                                        = 0x289, /* 0649 */
  EVENT_BREW_RESERVED_650                                                        = 0x28A, /* 0650 */
  EVENT_BREW_RESERVED_651                                                        = 0x28B, /* 0651 */
  EVENT_BREW_RESERVED_652                                                        = 0x28C, /* 0652 */
  EVENT_BREW_RESERVED_653                                                        = 0x28D, /* 0653 */
  EVENT_BREW_RESERVED_654                                                        = 0x28E, /* 0654 */
  EVENT_BREW_RESERVED_655                                                        = 0x28F, /* 0655 */
  EVENT_BREW_USER_656                                                            = 0x290, /* 0656 */
  EVENT_BREW_GENERIC                                                             = 0x291, /* 0657 */
  EVENT_BREW_MEDIAPLAYER_SELECT_FILE                                             = 0x292, /* 0658 */
  EVENT_BREW_MEDIAPLAYER_CONTROL                                                 = 0x293, /* 0659 */
  EVENT_BREW_APP_FORMITEM_STACK_CHANGE                                           = 0x294, /* 0660 */
  EVENT_BREW_CATAPP_RECV_PROACTIVE_CMD                                           = 0x295, /* 0661 */
  EVENT_BREW_CATAPP_TERMINAL_RSP                                                 = 0x296, /* 0662 */
  EVENT_BREW_CATAPP_NO_DISPLAY                                                   = 0x297, /* 0663 */
  EVENT_BREW_SIRIUS_EMAIL_DELETE                                                 = 0x298, /* 0664 */
  EVENT_BREW_SIRIUS_EMAIL_OPERATION_COMPLETE                                     = 0x299, /* 0665 */
  EVENT_BREW_SIRIUS_EMAIL_NEW_EMAIL_NOTIFICATION                                 = 0x29A, /* 0666 */
  EVENT_BREW_UNDEFINED_667                                                       = 0x29B, /* 0667 */
  EVENT_BREW_UNDEFINED_668                                                       = 0x29C, /* 0668 */
  EVENT_BREW_UNDEFINED_669                                                       = 0x29D, /* 0669 */
  EVENT_BREW_UNDEFINED_670                                                       = 0x29E, /* 0670 */
  EVENT_BREW_UNDEFINED_671                                                       = 0x29F, /* 0671 */
  EVENT_BREW_UNDEFINED_672                                                       = 0x2A0, /* 0672 */
  EVENT_BREW_UNDEFINED_673                                                       = 0x2A1, /* 0673 */
  EVENT_BREW_UNDEFINED_674                                                       = 0x2A2, /* 0674 */
  EVENT_BREW_UNDEFINED_675                                                       = 0x2A3, /* 0675 */
  EVENT_BREW_UNDEFINED_676                                                       = 0x2A4, /* 0676 */
  EVENT_BREW_UNDEFINED_677                                                       = 0x2A5, /* 0677 */
  EVENT_BREW_UNDEFINED_678                                                       = 0x2A6, /* 0678 */
  EVENT_BREW_UNDEFINED_679                                                       = 0x2A7, /* 0679 */
  EVENT_BREW_UNDEFINED_680                                                       = 0x2A8, /* 0680 */
  EVENT_BREW_UNDEFINED_681                                                       = 0x2A9, /* 0681 */
  EVENT_BREW_UNDEFINED_682                                                       = 0x2AA, /* 0682 */
  EVENT_BREW_UNDEFINED_683                                                       = 0x2AB, /* 0683 */
  EVENT_BREW_UNDEFINED_684                                                       = 0x2AC, /* 0684 */
  EVENT_BREW_UNDEFINED_685                                                       = 0x2AD, /* 0685 */
  EVENT_BREW_UNDEFINED_686                                                       = 0x2AE, /* 0686 */
  EVENT_BREW_UNDEFINED_687                                                       = 0x2AF, /* 0687 */
  EVENT_BREW_UNDEFINED_688                                                       = 0x2B0, /* 0688 */
  EVENT_BREW_UNDEFINED_689                                                       = 0x2B1, /* 0689 */
  EVENT_BREW_UNDEFINED_690                                                       = 0x2B2, /* 0690 */
  EVENT_BREW_UNDEFINED_691                                                       = 0x2B3, /* 0691 */
  EVENT_BREW_UNDEFINED_692                                                       = 0x2B4, /* 0692 */
  EVENT_BREW_UNDEFINED_693                                                       = 0x2B5, /* 0693 */
  EVENT_BREW_UNDEFINED_694                                                       = 0x2B6, /* 0694 */
  EVENT_BREW_UNDEFINED_695                                                       = 0x2B7, /* 0695 */
  EVENT_BREW_UNDEFINED_696                                                       = 0x2B8, /* 0696 */
  EVENT_BREW_UNDEFINED_697                                                       = 0x2B9, /* 0697 */
  EVENT_BREW_UNDEFINED_698                                                       = 0x2BA, /* 0698 */
  EVENT_BREW_UNDEFINED_699                                                       = 0x2BB, /* 0699 */
  EVENT_BREW_UNDEFINED_700                                                       = 0x2BC, /* 0700 */
  EVENT_BREW_UNDEFINED_701                                                       = 0x2BD, /* 0701 */
  EVENT_BREW_UNDEFINED_702                                                       = 0x2BE, /* 0702 */
  EVENT_BREW_UNDEFINED_703                                                       = 0x2BF, /* 0703 */
  EVENT_BREW_UNDEFINED_704                                                       = 0x2C0, /* 0704 */
  EVENT_BREW_UNDEFINED_705                                                       = 0x2C1, /* 0705 */
  EVENT_BREW_UNDEFINED_706                                                       = 0x2C2, /* 0706 */
  EVENT_BREW_UNDEFINED_707                                                       = 0x2C3, /* 0707 */
  EVENT_BREW_UNDEFINED_708                                                       = 0x2C4, /* 0708 */
  EVENT_BREW_UNDEFINED_709                                                       = 0x2C5, /* 0709 */
  EVENT_BREW_UNDEFINED_710                                                       = 0x2C6, /* 0710 */
  EVENT_BREW_UNDEFINED_711                                                       = 0x2C7, /* 0711 */
  EVENT_BREW_UNDEFINED_712                                                       = 0x2C8, /* 0712 */
  EVENT_BREW_UNDEFINED_713                                                       = 0x2C9, /* 0713 */
  EVENT_BREW_UNDEFINED_714                                                       = 0x2CA, /* 0714 */
  EVENT_BREW_UNDEFINED_715                                                       = 0x2CB, /* 0715 */
  EVENT_BREW_UNDEFINED_716                                                       = 0x2CC, /* 0716 */
  EVENT_BREW_UNDEFINED_717                                                       = 0x2CD, /* 0717 */
  EVENT_BREW_UNDEFINED_718                                                       = 0x2CE, /* 0718 */
  EVENT_BREW_UNDEFINED_719                                                       = 0x2CF, /* 0719 */
  EVENT_BREW_UNDEFINED_720                                                       = 0x2D0, /* 0720 */
  EVENT_BREW_UNDEFINED_721                                                       = 0x2D1, /* 0721 */
  EVENT_BREW_UNDEFINED_722                                                       = 0x2D2, /* 0722 */
  EVENT_BREW_UNDEFINED_723                                                       = 0x2D3, /* 0723 */
  EVENT_BREW_UNDEFINED_724                                                       = 0x2D4, /* 0724 */
  EVENT_BREW_UNDEFINED_725                                                       = 0x2D5, /* 0725 */
  EVENT_BREW_UNDEFINED_726                                                       = 0x2D6, /* 0726 */
  EVENT_BREW_UNDEFINED_727                                                       = 0x2D7, /* 0727 */
  EVENT_BREW_UNDEFINED_728                                                       = 0x2D8, /* 0728 */
  EVENT_BREW_UNDEFINED_729                                                       = 0x2D9, /* 0729 */
  EVENT_BREW_UNDEFINED_730                                                       = 0x2DA, /* 0730 */
  EVENT_BREW_UNDEFINED_731                                                       = 0x2DB, /* 0731 */
  EVENT_BREW_UNDEFINED_732                                                       = 0x2DC, /* 0732 */
  EVENT_BREW_UNDEFINED_733                                                       = 0x2DD, /* 0733 */
  EVENT_BREW_UNDEFINED_734                                                       = 0x2DE, /* 0734 */
  EVENT_BREW_UNDEFINED_735                                                       = 0x2DF, /* 0735 */
  EVENT_BREW_UNDEFINED_736                                                       = 0x2E0, /* 0736 */
  EVENT_BREW_UNDEFINED_737                                                       = 0x2E1, /* 0737 */
  EVENT_BREW_UNDEFINED_738                                                       = 0x2E2, /* 0738 */
  EVENT_BREW_UNDEFINED_739                                                       = 0x2E3, /* 0739 */
  EVENT_BREW_UNDEFINED_740                                                       = 0x2E4, /* 0740 */
  EVENT_BREW_UNDEFINED_741                                                       = 0x2E5, /* 0741 */
  EVENT_BREW_UNDEFINED_742                                                       = 0x2E6, /* 0742 */
  EVENT_BREW_UNDEFINED_743                                                       = 0x2E7, /* 0743 */
  EVENT_BREW_UNDEFINED_744                                                       = 0x2E8, /* 0744 */
  EVENT_BREW_UNDEFINED_745                                                       = 0x2E9, /* 0745 */
  EVENT_BREW_UNDEFINED_746                                                       = 0x2EA, /* 0746 */
  EVENT_BREW_UNDEFINED_747                                                       = 0x2EB, /* 0747 */
  EVENT_BREW_UNDEFINED_748                                                       = 0x2EC, /* 0748 */
  EVENT_BREW_UNDEFINED_749                                                       = 0x2ED, /* 0749 */
  EVENT_BREW_UNDEFINED_750                                                       = 0x2EE, /* 0750 */
  EVENT_BREW_UNDEFINED_751                                                       = 0x2EF, /* 0751 */
  EVENT_BREW_UNDEFINED_752                                                       = 0x2F0, /* 0752 */
  EVENT_BREW_UNDEFINED_753                                                       = 0x2F1, /* 0753 */
  EVENT_BREW_UNDEFINED_754                                                       = 0x2F2, /* 0754 */
  EVENT_BREW_UNDEFINED_755                                                       = 0x2F3, /* 0755 */
  EVENT_BREW_UNDEFINED_756                                                       = 0x2F4, /* 0756 */
  EVENT_BREW_UNDEFINED_757                                                       = 0x2F5, /* 0757 */
  EVENT_BREW_UNDEFINED_758                                                       = 0x2F6, /* 0758 */
  EVENT_BREW_UNDEFINED_759                                                       = 0x2F7, /* 0759 */
  EVENT_BREW_UNDEFINED_760                                                       = 0x2F8, /* 0760 */
  EVENT_BREW_UNDEFINED_761                                                       = 0x2F9, /* 0761 */
  EVENT_BREW_UNDEFINED_762                                                       = 0x2FA, /* 0762 */
  EVENT_BREW_UNDEFINED_763                                                       = 0x2FB, /* 0763 */
  EVENT_BREW_UNDEFINED_764                                                       = 0x2FC, /* 0764 */
  EVENT_BREW_UNDEFINED_765                                                       = 0x2FD, /* 0765 */
  EVENT_BREW_UNDEFINED_766                                                       = 0x2FE, /* 0766 */
  EVENT_BREW_UNDEFINED_767                                                       = 0x2FF, /* 0767 */
  EVENT_BREW_UNDEFINED_768                                                       = 0x300, /* 0768 */
  EVENT_BREW_UNDEFINED_769                                                       = 0x301, /* 0769 */
  EVENT_BREW_UNDEFINED_770                                                       = 0x302, /* 0770 */
  EVENT_BREW_UNDEFINED_771                                                       = 0x303, /* 0771 */
  EVENT_BREW_UNDEFINED_772                                                       = 0x304, /* 0772 */
  EVENT_BREW_UNDEFINED_773                                                       = 0x305, /* 0773 */
  EVENT_BREW_UNDEFINED_774                                                       = 0x306, /* 0774 */
  EVENT_BREW_UNDEFINED_775                                                       = 0x307, /* 0775 */
  EVENT_BREW_UNDEFINED_776                                                       = 0x308, /* 0776 */
  EVENT_BREW_UNDEFINED_777                                                       = 0x309, /* 0777 */
  EVENT_BREW_UNDEFINED_778                                                       = 0x30A, /* 0778 */
  EVENT_BREW_UNDEFINED_779                                                       = 0x30B, /* 0779 */
  EVENT_BREW_UNDEFINED_780                                                       = 0x30C, /* 0780 */
  EVENT_BREW_UNDEFINED_781                                                       = 0x30D, /* 0781 */
  EVENT_BREW_UNDEFINED_782                                                       = 0x30E, /* 0782 */
  EVENT_BREW_UNDEFINED_783                                                       = 0x30F, /* 0783 */
  EVENT_BREW_UNDEFINED_784                                                       = 0x310, /* 0784 */
  EVENT_BREW_UNDEFINED_785                                                       = 0x311, /* 0785 */
  EVENT_BREW_UNDEFINED_786                                                       = 0x312, /* 0786 */
  EVENT_BREW_UNDEFINED_787                                                       = 0x313, /* 0787 */
  EVENT_BREW_UNDEFINED_788                                                       = 0x314, /* 0788 */
  EVENT_BREW_UNDEFINED_789                                                       = 0x315, /* 0789 */
  EVENT_BREW_UNDEFINED_790                                                       = 0x316, /* 0790 */
  EVENT_BREW_UNDEFINED_791                                                       = 0x317, /* 0791 */
  EVENT_BREW_UNDEFINED_792                                                       = 0x318, /* 0792 */
  EVENT_BREW_UNDEFINED_793                                                       = 0x319, /* 0793 */
  EVENT_BREW_UNDEFINED_794                                                       = 0x31A, /* 0794 */
  EVENT_BREW_UNDEFINED_795                                                       = 0x31B, /* 0795 */
  EVENT_BREW_UNDEFINED_796                                                       = 0x31C, /* 0796 */
  EVENT_BREW_UNDEFINED_797                                                       = 0x31D, /* 0797 */
  EVENT_BREW_UNDEFINED_798                                                       = 0x31E, /* 0798 */
  EVENT_BREW_UNDEFINED_799                                                       = 0x31F, /* 0799 */
  EVENT_BREW_UNDEFINED_800                                                       = 0x320, /* 0800 */
  EVENT_BREW_UNDEFINED_801                                                       = 0x321, /* 0801 */
  EVENT_BREW_UNDEFINED_802                                                       = 0x322, /* 0802 */
  EVENT_BREW_UNDEFINED_803                                                       = 0x323, /* 0803 */
  EVENT_BREW_UNDEFINED_804                                                       = 0x324, /* 0804 */
  EVENT_BREW_UNDEFINED_805                                                       = 0x325, /* 0805 */
  EVENT_BREW_UNDEFINED_806                                                       = 0x326, /* 0806 */
  EVENT_BREW_UNDEFINED_807                                                       = 0x327, /* 0807 */
  EVENT_BREW_UNDEFINED_808                                                       = 0x328, /* 0808 */
  EVENT_BREW_UNDEFINED_809                                                       = 0x329, /* 0809 */
  EVENT_BREW_UNDEFINED_810                                                       = 0x32A, /* 0810 */
  EVENT_BREW_UNDEFINED_811                                                       = 0x32B, /* 0811 */
  EVENT_BREW_UNDEFINED_812                                                       = 0x32C, /* 0812 */
  EVENT_BREW_UNDEFINED_813                                                       = 0x32D, /* 0813 */
  EVENT_BREW_UNDEFINED_814                                                       = 0x32E, /* 0814 */
  EVENT_BREW_UNDEFINED_815                                                       = 0x32F, /* 0815 */
  EVENT_BREW_UNDEFINED_816                                                       = 0x330, /* 0816 */
  EVENT_BREW_UNDEFINED_817                                                       = 0x331, /* 0817 */
  EVENT_BREW_UNDEFINED_818                                                       = 0x332, /* 0818 */
  EVENT_BREW_UNDEFINED_819                                                       = 0x333, /* 0819 */
  EVENT_BREW_UNDEFINED_820                                                       = 0x334, /* 0820 */
  EVENT_BREW_UNDEFINED_821                                                       = 0x335, /* 0821 */
  EVENT_BREW_UNDEFINED_822                                                       = 0x336, /* 0822 */
  EVENT_BREW_UNDEFINED_823                                                       = 0x337, /* 0823 */
  EVENT_BREW_UNDEFINED_824                                                       = 0x338, /* 0824 */
  EVENT_BREW_UNDEFINED_825                                                       = 0x339, /* 0825 */
  EVENT_BREW_UNDEFINED_826                                                       = 0x33A, /* 0826 */
  EVENT_BREW_UNDEFINED_827                                                       = 0x33B, /* 0827 */
  EVENT_BREW_UNDEFINED_828                                                       = 0x33C, /* 0828 */
  EVENT_BREW_UNDEFINED_829                                                       = 0x33D, /* 0829 */
  EVENT_BREW_UNDEFINED_830                                                       = 0x33E, /* 0830 */
  EVENT_BREW_UNDEFINED_831                                                       = 0x33F, /* 0831 */
  EVENT_BREW_UNDEFINED_832                                                       = 0x340, /* 0832 */
  EVENT_BREW_UNDEFINED_833                                                       = 0x341, /* 0833 */
  EVENT_BREW_UNDEFINED_834                                                       = 0x342, /* 0834 */
  EVENT_BREW_UNDEFINED_835                                                       = 0x343, /* 0835 */
  EVENT_BREW_UNDEFINED_836                                                       = 0x344, /* 0836 */
  EVENT_BREW_UNDEFINED_837                                                       = 0x345, /* 0837 */
  EVENT_BREW_UNDEFINED_838                                                       = 0x346, /* 0838 */
  EVENT_BREW_UNDEFINED_839                                                       = 0x347, /* 0839 */
  EVENT_BREW_UNDEFINED_840                                                       = 0x348, /* 0840 */
  EVENT_BREW_UNDEFINED_841                                                       = 0x349, /* 0841 */
  EVENT_BREW_UNDEFINED_842                                                       = 0x34A, /* 0842 */
  EVENT_BREW_UNDEFINED_843                                                       = 0x34B, /* 0843 */
  EVENT_BREW_UNDEFINED_844                                                       = 0x34C, /* 0844 */
  EVENT_BREW_UNDEFINED_845                                                       = 0x34D, /* 0845 */
  EVENT_BREW_UNDEFINED_846                                                       = 0x34E, /* 0846 */
  EVENT_BREW_UNDEFINED_847                                                       = 0x34F, /* 0847 */
  EVENT_BREW_UNDEFINED_848                                                       = 0x350, /* 0848 */
  EVENT_BREW_UNDEFINED_849                                                       = 0x351, /* 0849 */
  EVENT_BREW_UNDEFINED_850                                                       = 0x352, /* 0850 */
  EVENT_BREW_UNDEFINED_851                                                       = 0x353, /* 0851 */
  EVENT_BREW_UNDEFINED_852                                                       = 0x354, /* 0852 */
  EVENT_BREW_UNDEFINED_853                                                       = 0x355, /* 0853 */
  EVENT_BREW_UNDEFINED_854                                                       = 0x356, /* 0854 */
  EVENT_BREW_UNDEFINED_855                                                       = 0x357, /* 0855 */
  EVENT_BREW_UNDEFINED_856                                                       = 0x358, /* 0856 */
  EVENT_BREW_UNDEFINED_857                                                       = 0x359, /* 0857 */
  EVENT_BREW_UNDEFINED_858                                                       = 0x35A, /* 0858 */
  EVENT_BREW_UNDEFINED_859                                                       = 0x35B, /* 0859 */
  EVENT_BREW_UNDEFINED_860                                                       = 0x35C, /* 0860 */
  EVENT_BREW_UNDEFINED_861                                                       = 0x35D, /* 0861 */
  EVENT_BREW_UNDEFINED_862                                                       = 0x35E, /* 0862 */
  EVENT_BREW_UNDEFINED_863                                                       = 0x35F, /* 0863 */
  EVENT_BREW_UNDEFINED_864                                                       = 0x360, /* 0864 */
  EVENT_BREW_UNDEFINED_865                                                       = 0x361, /* 0865 */
  EVENT_BREW_UNDEFINED_866                                                       = 0x362, /* 0866 */
  EVENT_BREW_UNDEFINED_867                                                       = 0x363, /* 0867 */
  EVENT_BREW_UNDEFINED_868                                                       = 0x364, /* 0868 */
  EVENT_BREW_UNDEFINED_869                                                       = 0x365, /* 0869 */
  EVENT_BREW_UNDEFINED_870                                                       = 0x366, /* 0870 */
  EVENT_BREW_UNDEFINED_871                                                       = 0x367, /* 0871 */
  EVENT_BREW_UNDEFINED_872                                                       = 0x368, /* 0872 */
  EVENT_BREW_UNDEFINED_873                                                       = 0x369, /* 0873 */
  EVENT_BREW_UNDEFINED_874                                                       = 0x36A, /* 0874 */
  EVENT_BREW_UNDEFINED_875                                                       = 0x36B, /* 0875 */
  EVENT_BREW_UNDEFINED_876                                                       = 0x36C, /* 0876 */
  EVENT_BREW_UNDEFINED_877                                                       = 0x36D, /* 0877 */
  EVENT_BREW_UNDEFINED_878                                                       = 0x36E, /* 0878 */
  EVENT_BREW_UNDEFINED_879                                                       = 0x36F, /* 0879 */
  EVENT_BREW_UNDEFINED_880                                                       = 0x370, /* 0880 */
  EVENT_BREW_UNDEFINED_881                                                       = 0x371, /* 0881 */
  EVENT_BREW_UNDEFINED_882                                                       = 0x372, /* 0882 */
  EVENT_BREW_UNDEFINED_883                                                       = 0x373, /* 0883 */
  EVENT_BREW_UNDEFINED_884                                                       = 0x374, /* 0884 */
  EVENT_BREW_UNDEFINED_885                                                       = 0x375, /* 0885 */
  EVENT_BREW_UNDEFINED_886                                                       = 0x376, /* 0886 */
  EVENT_BREW_UNDEFINED_887                                                       = 0x377, /* 0887 */
  EVENT_BREW_UNDEFINED_888                                                       = 0x378, /* 0888 */
  EVENT_BREW_UNDEFINED_889                                                       = 0x379, /* 0889 */
  EVENT_BREW_UNDEFINED_890                                                       = 0x37A, /* 0890 */
  EVENT_BREW_UNDEFINED_891                                                       = 0x37B, /* 0891 */
  EVENT_BREW_UNDEFINED_892                                                       = 0x37C, /* 0892 */
  EVENT_BREW_UNDEFINED_893                                                       = 0x37D, /* 0893 */
  EVENT_BREW_UNDEFINED_894                                                       = 0x37E, /* 0894 */
  EVENT_BREW_UNDEFINED_895                                                       = 0x37F, /* 0895 */
  EVENT_WCDMA_PS_DATA_RATE                                                       = 0x380, /* 0896 */
  EVENT_GSM_TO_WCDMA_RESELECT_END                                                = 0x381, /* 0897 */
  EVENT_PZID_HAI_ENABLED                                                         = 0x382, /* 0898 */
  EVENT_PZID_HAI_DISABLED                                                        = 0x383, /* 0899 */
  EVENT_GSM_TO_WCDMA_HANDOVER_START                                              = 0x384, /* 0900 */
  EVENT_WCDMA_RRC_MODE                                                           = 0x385, /* 0901 */
  EVENT_WCDMA_L1_ACQ_SUBSTATE                                                    = 0x386, /* 0902 */
  EVENT_WCDMA_PHYCHAN_CFG_CHANGED                                                = 0x387, /* 0903 */
  EVENT_QTV_CLIP_STARTED                                                         = 0x388, /* 0904 */
  EVENT_QTV_CLIP_ENDED                                                           = 0x389, /* 0905 */
  EVENT_QTV_SDP_PARSER_REJECT                                                    = 0x38A, /* 0906 */
  EVENT_QTV_CLIP_PAUSE                                                           = 0x38B, /* 0907 */
  EVENT_QTV_CLIP_REPOSITIONING                                                   = 0x38C, /* 0908 */
  EVENT_QTV_CLIP_ZOOM_IN                                                         = 0x38D, /* 0909 */
  EVENT_QTV_CLIP_ZOOM_OUT                                                        = 0x38E, /* 0910 */
  EVENT_QTV_CLIP_ROTATE                                                          = 0x38F, /* 0911 */
  EVENT_QTV_CLIP_PAUSE_RESUME                                                    = 0x390, /* 0912 */
  EVENT_QTV_CLIP_REPOSITION_RESUME                                               = 0x391, /* 0913 */
  EVENT_QTV_DSP_INIT                                                             = 0x392, /* 0914 */
  EVENT_QTV_STREAMING_SERVER_URL                                                 = 0x393, /* 0915 */
  EVENT_QTV_SERVER_PORTS_USED                                                    = 0x394, /* 0916 */
  EVENT_QTV_USING_PROXY_SERVER                                                   = 0x395, /* 0917 */
  EVENT_QTV_STREAMER_STATE_IDLE                                                  = 0x396, /* 0918 */
  EVENT_QTV_STREAMER_STATE_CONNECTING                                            = 0x397, /* 0919 */
  EVENT_QTV_STREAMER_STATE_SETTING_TRACKS                                        = 0x398, /* 0920 */
  EVENT_QTV_STREAMER_STATE_STREAMING                                             = 0x399, /* 0921 */
  EVENT_QTV_STREAMER_STATE_PAUSED                                                = 0x39A, /* 0922 */
  EVENT_QTV_STREAMER_STATE_SUSPENDED                                             = 0x39B, /* 0923 */
  EVENT_QTV_STREAMER_CONNECTED                                                   = 0x39C, /* 0924 */
  EVENT_QTV_STREAMER_INITSTREAM_FAIL                                             = 0x39D, /* 0925 */
  EVENT_QTV_BUFFERING_STARTED                                                    = 0x39E, /* 0926 */
  EVENT_QTV_BUFFERING_ENDED                                                      = 0x39F, /* 0927 */
  EVENT_QTV_CLIP_FULLSCREEN                                                      = 0x3A0, /* 0928 */
  EVENT_QTV_PS_DOWNLOAD_STARTED                                                  = 0x3A1, /* 0929 */
  EVENT_QTV_PSEUDO_STREAM_STARTED                                                = 0x3A2, /* 0930 */
  EVENT_QTV_PS_PLAYER_STATE_PSEUDO_PAUSE                                         = 0x3A3, /* 0931 */
  EVENT_QTV_PS_PLAYER_STATE_PSEUDO_RESUME                                        = 0x3A4, /* 0932 */
  EVENT_QTV_PARSER_STATE_READY                                                   = 0x3A5, /* 0933 */
  EVENT_QTV_FRAGMENT_PLAYBACK_BEGIN                                              = 0x3A6, /* 0934 */
  EVENT_QTV_FRAGMENT_PLAYBACK_COMPLETE                                           = 0x3A7, /* 0935 */
  EVENT_QTV_PARSER_STATE_PSEUDO_PAUSE                                            = 0x3A8, /* 0936 */
  EVENT_QTV_PLAYER_STATE_PSEUDO_PAUSE                                            = 0x3A9, /* 0937 */
  EVENT_QTV_PARSER_STATE_PSEUDO_RESUME                                           = 0x3AA, /* 0938 */
  EVENT_QTV_PLAYER_STATE_PSEUDO_RESUME                                           = 0x3AB, /* 0939 */
  EVENT_QTV_FRAGMENTED_FILE_DECODE_START                                         = 0x3AC, /* 0940 */
  EVENT_QTV_FRAGMENTED_FILE_END_SUCCESS                                          = 0x3AD, /* 0941 */
  EVENT_QTV_DOWNLOAD_DATA_REPORT                                                 = 0x3AE, /* 0942 */
  EVENT_QTV_VDEC_DIAG_DECODE_CALLBACK                                            = 0x3AF, /* 0943 */
  EVENT_QTV_URL_PLAYED_IS_MULTICAST                                              = 0x3B0, /* 0944 */
  EVENT_QTV_VDEC_DIAG_STATUS                                                     = 0x3B1, /* 0945 */
  EVENT_QTV_STREAMING_URL_OPEN                                                   = 0x3B2, /* 0946 */
  EVENT_QTV_STREAMING_URL_OPENING                                                = 0x3B3, /* 0947 */
  EVENT_QTV_CLIP_ENDED_VER2                                                      = 0x3B4, /* 0948 */
  EVENT_QTV_SILENCE_INSERTION_STARTED                                            = 0x3B5, /* 0949 */
  EVENT_QTV_SILENCE_INSERTION_ENDED                                              = 0x3B6, /* 0950 */
  EVENT_QTV_AUDIO_CHANNEL_SWITCH_FRAME                                           = 0x3B7, /* 0951 */
  EVENT_QTV_FIRST_VIDEO_FRAME_RENDERED                                           = 0x3B8, /* 0952 */
  EVENT_QTV_FIRST_VIDEO_I_FRAME_RENDERED                                         = 0x3B9, /* 0953 */
  EVENT_QTV_SDP_SELECTED                                                         = 0x3BA, /* 0954 */
  EVENT_QTV_DIAG_PLAYER_STATUS                                                   = 0x3BB, /* 0955 */
  EVENT_QTV_SILENCE_INSERTION_DURATION                                           = 0x3BC, /* 0956 */
  EVENT_QTV_UNDEFINED_957                                                        = 0x3BD, /* 0957 */
  EVENT_QTV_UNDEFINED_958                                                        = 0x3BE, /* 0958 */
  EVENT_QTV_UNDEFINED_959                                                        = 0x3BF, /* 0959 */
  EVENT_QTV_UNDEFINED_960                                                        = 0x3C0, /* 0960 */
  EVENT_QTV_UNDEFINED_961                                                        = 0x3C1, /* 0961 */
  EVENT_QTV_UNDEFINED_962                                                        = 0x3C2, /* 0962 */
  EVENT_QTV_UNDEFINED_963                                                        = 0x3C3, /* 0963 */
  EVENT_QTV_UNDEFINED_964                                                        = 0x3C4, /* 0964 */
  EVENT_QTV_UNDEFINED_965                                                        = 0x3C5, /* 0965 */
  EVENT_QTV_UNDEFINED_966                                                        = 0x3C6, /* 0966 */
  EVENT_QTV_UNDEFINED_967                                                        = 0x3C7, /* 0967 */
  EVENT_DS_SETS_ARM_CLOCK_FASTER                                                 = 0x3C8, /* 0968 */
  EVENT_DS_SETS_ARM_CLOCK_SLOWER                                                 = 0x3C9, /* 0969 */
  EVENT_SMS_STATISTICS                                                           = 0x3CA, /* 0970 */
  EVENT_SM_PDP_STATE                                                             = 0x3CB, /* 0971 */
  EVENT_MVS_STATE                                                                = 0x3CC, /* 0972 */
  EVENT_SECSSL                                                                   = 0x3CD, /* 0973 */
  EVENT_SECTEST                                                                  = 0x3CE, /* 0974 */
  EVENT_SECVPN                                                                   = 0x3CF, /* 0975 */
  EVENT_SECCRYPT                                                                 = 0x3D0, /* 0976 */
  EVENT_SECCRYPT_CMD                                                             = 0x3D1, /* 0977 */
  EVENT_SEC_RESERVED_978                                                         = 0x3D2, /* 0978 */
  EVENT_SEC_RESERVED_979                                                         = 0x3D3, /* 0979 */
  EVENT_SEC_RESERVED_980                                                         = 0x3D4, /* 0980 */
  EVENT_SEC_RESERVED_981                                                         = 0x3D5, /* 0981 */
  EVENT_ARM_CLK_FREQUENCY_CHANGE                                                 = 0x3D6, /* 0982 */
  EVENT_ADSP_CLK_FREQUENCY_CHANGE                                                = 0x3D7, /* 0983 */
  EVENT_MDSP_CLK_FREQUENCY_CHANGE                                                = 0x3D8, /* 0984 */
  EVENT_CELL_CHANGE_INDICATION                                                   = 0x3D9, /* 0985 */
  EVENT_CB_STATE_CHANGE                                                          = 0x3DA, /* 0986 */
  EVENT_SMSCB_L1_STATE_CHANGE                                                    = 0x3DB, /* 0987 */
  EVENT_SMSCB_L1_COLLISION                                                       = 0x3DC, /* 0988 */
  EVENT_WMS_SEARCH_REQUEST                                                       = 0x3DD, /* 0989 */
  EVENT_CM_GET_PASSWORD_IND                                                      = 0x3DE, /* 0990 */
  EVENT_CM_PASSWORD_AUTHENTICATION_STATUS                                        = 0x3DF, /* 0991 */
  EVENT_CM_USS_RESPONSE_NOTIFY_IND                                               = 0x3E0, /* 0992 */
  EVENT_CM_USS_CONF                                                              = 0x3E1, /* 0993 */
  EVENT_CM_RELEASE_USS_IND                                                       = 0x3E2, /* 0994 */
  EVENT_CM_FWD_AOC_IND                                                           = 0x3E3, /* 0995 */
  EVENT_PZID_ID                                                                  = 0x3E4, /* 0996 */
  EVENT_PZID_HT_VALUE                                                            = 0x3E5, /* 0997 */
  EVENT_PZID_EXISTS_IN_LIST                                                      = 0x3E6, /* 0998 */
  EVENT_GSDI_GET_FILE_ATTRIBUTES                                                 = 0x3E7, /* 0999 */
  EVENT_GSDI_SIM_READ                                                            = 0x3E8, /* 1000 */
  EVENT_GSDI_SIM_WRITE                                                           = 0x3E9, /* 1001 */
  EVENT_GSDI_GET_PIN_STATUS                                                      = 0x3EA, /* 1002 */
  EVENT_GSDI_VERIFY_PIN                                                          = 0x3EB, /* 1003 */
  EVENT_GSDI_UNBLOCK_PIN                                                         = 0x3EC, /* 1004 */
  EVENT_GSDI_DISABLE_PIN                                                         = 0x3ED, /* 1005 */
  EVENT_GSDI_ENABLE_PIN                                                          = 0x3EE, /* 1006 */
  EVENT_GSDI_SIM_INCREASE                                                        = 0x3EF, /* 1007 */
  EVENT_GSDI_EXECUTE_APDU_REQ                                                    = 0x3F0, /* 1008 */
  EVENT_SEG_UPM_ADDR_MISMATCH                                                    = 0x3F1, /* 1009 */
  EVENT_WCDMA_PRACH                                                              = 0x3F2, /* 1010 */
  EVENT_GSDI_SELECT                                                              = 0x3F3, /* 1011 */
  EVENT_WCDMA_RAB_RATE_RECONFIG                                                  = 0x3F4, /* 1012 */
  EVENT_WCDMA_RLC_RESETS                                                         = 0x3F5, /* 1013 */
  EVENT_WCDMA_RLC_OPEN_CLOSE                                                     = 0x3F6, /* 1014 */
  EVENT_WCDMA_RLC_MRW                                                            = 0x3F7, /* 1015 */
  EVENT_QVP_APP_PROCESS_EVENT                                                    = 0x3F8, /* 1016 */
  EVENT_QVP_APP_STATE_CHANGED_EVENT                                              = 0x3F9, /* 1017 */
  EVENT_QVP_APP_CALL_CONNECTED_EVENT                                             = 0x3FA, /* 1018 */
  EVENT_GSDI_CARD_EVENT_NOTIFICATION                                             = 0x3FB, /* 1019 */
  EVENT_CM_DATA_AVAILABLE                                                        = 0x3FC, /* 1020 */
  EVENT_CM_DS_INTERRAT_STATE                                                     = 0x3FD, /* 1021 */
  EVENT_MM_STATE                                                                 = 0x3FE, /* 1022 */
  EVENT_GMM_STATE                                                                = 0x3FF, /* 1023 */
  EVENT_PLMN_INFORMATION                                                         = 0x400, /* 1024 */
  EVENT_COREAPP_SET_VOICE_PRIVACY                                                = 0x401, /* 1025 */
  EVENT_COREAPP_GET_VOICE_PRIVACY                                                = 0x402, /* 1026 */
  EVENT_HARD_HANDOFF_LONG_CODE_MASK_CHANGE                                       = 0x403, /* 1027 */
  EVENT_VCTCXO_FREEZE                                                            = 0x404, /* 1028 */
  EVENT_VCTCXO_UNFREEZE                                                          = 0x405, /* 1029 */
  EVENT_SMS_SLOT_WAKEUP_V2                                                       = 0x406, /* 1030 */
  EVENT_QVP_RCVD_FIRST_VIDEO_FRAME                                               = 0x407, /* 1031 */
  EVENT_QVP_CALL_RELEASED                                                        = 0x408, /* 1032 */
  EVENT_CB_SMS_NOTIFY                                                            = 0x409, /* 1033 */
  EVENT_GPS_PDSM_EVENT_REPORT                                                    = 0x40A, /* 1034 */
  EVENT_LONG_CODE_MASK_CHANGED                                                   = 0x40B, /* 1035 */
  EVENT_DS707                                                                    = 0x40C, /* 1036 */
  EVENT_GSDI_ACTIVATE_FEATURE_IND                                                = 0x40D, /* 1037 */
  EVENT_GSDI_DEACTIVATE_FEATURE_IND                                              = 0x40E, /* 1038 */
  EVENT_GSDI_GET_FEATURE_IND                                                     = 0x40F, /* 1039 */
  EVENT_GSDI_SET_FEATURE_DATA                                                    = 0x410, /* 1040 */
  EVENT_GSDI_UNBLOCK_FEATURE_IND                                                 = 0x411, /* 1041 */
  EVENT_GSDI_GET_CONTROL_KEY                                                     = 0x412, /* 1042 */
  EVENT_GSDI_OTA_DEPERSO                                                         = 0x413, /* 1043 */
  EVENT_GSDI_GET_PERM_FEATURE_IND                                                = 0x414, /* 1044 */
  EVENT_GSDI_PERM_DISBALE_FEATURE_IND                                            = 0x415, /* 1045 */
  EVENT_GSM_L1_VOCODER_INITIALIZE                                                = 0x416, /* 1046 */
  EVENT_GSM_L1_ALIGN_VFR                                                         = 0x417, /* 1047 */
  EVENT_GSM_L1_VOCODER_ENABLED                                                   = 0x418, /* 1048 */
  EVENT_HDR_AMAC_PERSISTENCE_FAILED                                              = 0x419, /* 1049 */
  EVENT_HDR_AMAC_PERSISTENCE_PASSED                                              = 0x41A, /* 1050 */
  EVENT_MFLO_STREAM_STATE                                                        = 0x41B, /* 1051 */
  EVENT_MFLO_CONTROL_CHANNEL_STATE_CHANGE                                        = 0x41C, /* 1052 */
  EVENT_MFLO_SLEEP_STATE_CHANGE                                                  = 0x41D, /* 1053 */
  EVENT_MFLO_NETWORK_STATE_CHANGE                                                = 0x41E, /* 1054 */
  EVENT_MFLO_TRANS_STATE                                                         = 0x41F, /* 1055 */
  EVENT_MFLO_OIS_STATE                                                           = 0x420, /* 1056 */
  EVENT_MFLO_RXD_STATE                                                           = 0x421, /* 1057 */
  EVENT_MFLO_HIPRI_STATE_CHANGE                                                  = 0x422, /* 1058 */
  EVENT_MFLO_CAS_STATE                                                           = 0x423, /* 1059 */
  EVENT_MFLO_ACQ_STATE                                                           = 0x424, /* 1060 */
  EVENT_MFLO_OSCAR_FRAME_DECODED                                                 = 0x425, /* 1061 */
  EVENT_MFLO_CHAN_SWITCH_RENDERED                                                = 0x426, /* 1062 */
  EVENT_MFLO_OSCAR_DEC_EXCEPTION_DETECTED                                        = 0x427, /* 1063 */
  EVENT_MFLO_MFN_SUBSTATE                                                        = 0x428, /* 1064 */
  EVENT_MFLO_MFN_STATE                                                           = 0x429, /* 1065 */
  EVENT_MFLO_MFN_VERTICAL_HANDOFF                                                = 0x42A, /* 1066 */
  EVENT_MFLO_MFN_ACQ_STATE                                                       = 0x42B, /* 1067 */
  EVENT_MFLO_FLOW_STATUS                                                         = 0x42C, /* 1068 */
  EVENT_MFLO_NETWORK_STATUS                                                      = 0x42D, /* 1069 */
  EVENT_MFLO_UNDEFINED_1070                                                      = 0x42E, /* 1070 */
  EVENT_CM_LCS_MOLR_CONF                                                         = 0x42F, /* 1071 */
  EVENT_PPP_NETMODEL                                                             = 0x430, /* 1072 */
  EVENT_CAMERA_PROFILING                                                         = 0x431, /* 1073 */
  EVENT_MAC_HS_T1_EXPIRY                                                         = 0x432, /* 1074 */
  EVENT_ASYNC_DS707                                                              = 0x433, /* 1075 */
  EVENT_PKT_DS707                                                                = 0x434, /* 1076 */
  EVENT_GPRS_TIMER_EXPIRY                                                        = 0x435, /* 1077 */
  EVENT_GPRS_MAC_IDLE_IND                                                        = 0x436, /* 1078 */
  EVENT_GPRS_PACKET_CHANNEL_REQUEST                                              = 0x437, /* 1079 */
  EVENT_GPRS_ACCESS_REJECT                                                       = 0x438, /* 1080 */
  EVENT_GPRS_PACKET_RESOURCE_REQUEST                                             = 0x439, /* 1081 */
  EVENT_GPRS_PACKET_UPLINK_ASSIGNMENT                                            = 0x43A, /* 1082 */
  EVENT_GPRS_PACKET_DOWNLINK_ASSIGNMENT                                          = 0x43B, /* 1083 */
  EVENT_PACKET_TIMESLOT_RECONFIGURE                                              = 0x43C, /* 1084 */
  EVENT_GPRS_TBF_RELEASE                                                         = 0x43D, /* 1085 */
  EVENT_GPRS_CELL_CHANGE_ORDER                                                   = 0x43E, /* 1086 */
  EVENT_GPRS_CELL_CHANGE_FAILURE                                                 = 0x43F, /* 1087 */
  EVENT_GSM_AMR_RATSCCH_REQ                                                      = 0x440, /* 1088 */
  EVENT_GSM_AMR_RATSCCH_RSP                                                      = 0x441, /* 1089 */
  EVENT_SD_SRV_IND_HYBR_WLAN                                                     = 0x442, /* 1090 */
  EVENT_SD_EVENT_ACTION_HYBR_WLAN                                                = 0x443, /* 1091 */
  EVENT_GPS_PD_DEMOD_SESS_START                                                  = 0x444, /* 1092 */
  EVENT_GPS_PD_DEMOD_SESS_END                                                    = 0x445, /* 1093 */
  EVENT_GPS_SV_ACQUIRED                                                          = 0x446, /* 1094 */
  EVENT_GPS_SV_BIT_EDGE_FOUND                                                    = 0x447, /* 1095 */
  EVENT_GPS_DEMOD_STARTED                                                        = 0x448, /* 1096 */
  EVENT_GPS_DEMOD_OUT_OF_LOCK                                                    = 0x449, /* 1097 */
  EVENT_GPS_DEMOD_STOPPED                                                        = 0x44A, /* 1098 */
  EVENT_GPS_DEMOD_PREAMBLE_FOUND                                                 = 0x44B, /* 1099 */
  EVENT_GPS_DEMOD_FRAME_SYNC_STATUS                                              = 0x44C, /* 1100 */
  EVENT_GPS_DEMOD_SUBFRAME                                                       = 0x44D, /* 1101 */
  EVENT_GPS_DEMOD_EPHEMERIS_COMPLETE                                             = 0x44E, /* 1102 */
  EVENT_GPS_DEMOD_ALMANAC_COMPLETE                                               = 0x44F, /* 1103 */
  EVENT_GPS_DEMOD_BIT_EDGE_STATUS                                                = 0x450, /* 1104 */
  EVENT_RAT_CHANGE                                                               = 0x451, /* 1105 */
  EVENT_REGISTRATION_SUPPRESSED                                                  = 0x452, /* 1106 */
  EVENT_HDR_RUP_DIST_BASED_REG                                                   = 0x453, /* 1107 */
  EVENT_GPS_DIAG_APP_TRACKING_START                                              = 0x454, /* 1108 */
  EVENT_GPS_DIAG_APP_TRACKING_END                                                = 0x455, /* 1109 */
  EVENT_GPS_DIAG_APP_POSITION_SUCCESS                                            = 0x456, /* 1110 */
  EVENT_GPS_DIAG_APP_POSITION_FAILURE                                            = 0x457, /* 1111 */
  EVENT_GSM_AMR_MULTIRATE_IE                                                     = 0x458, /* 1112 */
  EVENT_EPZID_HYSTERESIS_ENABLED                                                 = 0x459, /* 1113 */
  EVENT_EPZID_HYSTERESIS_DISABLED                                                = 0x45A, /* 1114 */
  EVENT_EPZID_HT_STARTED                                                         = 0x45B, /* 1115 */
  EVENT_EPZID_HT_EXPIRED                                                         = 0x45C, /* 1116 */
  EVENT_HDR_BCMCS_FLOW_STATE_CHANGE                                              = 0x45D, /* 1117 */
  EVENT_HDR_LMAC_UPDATE_BC_STATUS                                                = 0x45E, /* 1118 */
  EVENT_DS_CAM_TIMER                                                             = 0x45F, /* 1119 */
  EVENT_DS_RDUD_TIMER                                                            = 0x460, /* 1120 */
  EVENT_DS_CTA_TIMER                                                             = 0x461, /* 1121 */
  EVENT_DS_FALLBACK                                                              = 0x462, /* 1122 */
  EVENT_DS3G_CAM_FLOW_CTRL_TIMER                                                 = 0x463, /* 1123 */
  EVENT_GPS_JAMMER_DETECTION_TEST_PASS                                           = 0x464, /* 1124 */
  EVENT_GPS_JAMMER_DETECTION_TEST_FAILURE                                        = 0x465, /* 1125 */
  EVENT_JAMMER_DETECT_NOISE_STATS                                                = 0x466, /* 1126 */
  EVENT_GPS_GET_PARAM                                                            = 0x467, /* 1127 */
  EVENT_GPS_GET_PARAM_BS_INFO                                                    = 0x468, /* 1128 */
  EVENT_HS_SERVING_CELL_CHANGE                                                   = 0x469, /* 1129 */
  EVENT_HS_DSCH_STATUS                                                           = 0x46A, /* 1130 */
  EVENT_SMGMM_REQUEST_SENT                                                       = 0x46B, /* 1131 */
  EVENT_SMGMM_REJECT_RECEIVED                                                    = 0x46C, /* 1132 */
  EVENT_LINUX_APP_STOP                                                           = 0x46D, /* 1133 */
  EVENT_GPS_PD_CME_SESSION_START                                                 = 0x46E, /* 1134 */
  EVENT_GPS_PD_CME_SESSION_END                                                   = 0x46F, /* 1135 */
  EVENT_SIP_REGISTER_START                                                       = 0x470, /* 1136 */
  EVENT_SIP_REGISTER_DONE                                                        = 0x471, /* 1137 */
  EVENT_SIP_CALL_SETUP_START                                                     = 0x472, /* 1138 */
  EVENT_SIP_CALL_SETUP_DONE                                                      = 0x473, /* 1139 */
  EVENT_SIP_CALL_RELEASE_START                                                   = 0x474, /* 1140 */
  EVENT_SIP_CALL_RELEASE_DONE                                                    = 0x475, /* 1141 */
  EVENT_AUDIO_FRAME_SENT_TO_DECODER                                              = 0x476, /* 1142 */
  EVENT_VIDEO_FRAME_SENT_TO_DECODER                                              = 0x477, /* 1143 */
  EVENT_DEC_RENDER_FRAME                                                         = 0x478, /* 1144 */
  EVENT_DEC_RENDER_DONE                                                          = 0x479, /* 1145 */
  EVENT_DEC_START_DECODING                                                       = 0x47A, /* 1146 */
  EVENT_DEC_FRAME_DECODED                                                        = 0x47B, /* 1147 */
  EVENT_V_ENCODED                                                                = 0x47C, /* 1148 */
  EVENT_DEC_START_DECODING_EXT                                                   = 0x47D, /* 1149 */
  EVENT_DEC_FRAME_DECODED_EXT                                                    = 0x47E, /* 1150 */
  EVENT_QVIDEOPHONE_UNDEFINED_1151                                               = 0x47F, /* 1151 */
  EVENT_QVIDEOPHONE_UNDEFINED_1152                                               = 0x480, /* 1152 */
  EVENT_QVIDEOPHONE_UNDEFINED_1153                                               = 0x481, /* 1153 */
  EVENT_QVIDEOPHONE_UNDEFINED_1154                                               = 0x482, /* 1154 */
  EVENT_QVIDEOPHONE_UNDEFINED_1155                                               = 0x483, /* 1155 */
  EVENT_GPS_CME_POS_REQ                                                          = 0x484, /* 1156 */
  EVENT_GPS_CME_FIX_START                                                        = 0x485, /* 1157 */
  EVENT_GPS_CME_FIX_END                                                          = 0x486, /* 1158 */
  EVENT_GPS_SEED_CLM                                                             = 0x487, /* 1159 */
  EVENT_GPS_SEED_SID                                                             = 0x488, /* 1160 */
  EVENT_GPS_SEED_SL                                                              = 0x489, /* 1161 */
  EVENT_GPS_SEED_GET                                                             = 0x48A, /* 1162 */
  EVENT_HDR_OVHD_BC_MSG_RX                                                       = 0x48B, /* 1163 */
  EVENT_HDR_OVHD_T_BC_SUPERVISION                                                = 0x48C, /* 1164 */
  EVENT_HDR_LMAC_SET_BCMCS_PAGE_CYCLE                                            = 0x48D, /* 1165 */
  EVENT_HDR_HMP_SESSION_CLOSED                                                   = 0x48E, /* 1166 */
  EVENT_WLAN_CP                                                                  = 0x48F, /* 1167 */
  EVENT_ARP                                                                      = 0x490, /* 1168 */
  EVENT_DHCP                                                                     = 0x491, /* 1169 */
  EVENT_WLAN_WPA                                                                 = 0x492, /* 1170 */
  EVENT_EAP                                                                      = 0x493, /* 1171 */
  EVENT_LAN_1X                                                                   = 0x494, /* 1172 */
  EVENT_CAMERA_SVCS_START                                                        = 0x495, /* 1173 */
  EVENT_CAMERA_SVCS_STOP                                                         = 0x496, /* 1174 */
  EVENT_BCMCS_SRVC_AVAILABLE                                                     = 0x497, /* 1175 */
  EVENT_BCMCS_SRVC_LOST                                                          = 0x498, /* 1176 */
  EVENT_BCMCS_FLOW_REGISTERED                                                    = 0x499, /* 1177 */
  EVENT_BCMCS_FLOW_DEREGISTERED                                                  = 0x49A, /* 1178 */
  EVENT_BCMCS_FLOW_STATUS_CHANGED                                                = 0x49B, /* 1179 */
  EVENT_CAMERA_SVCS_X                                                            = 0x49C, /* 1180 */
  EVENT_CM_CALL_EVENT_ORIG_THR                                                   = 0x49D, /* 1181 */
  EVENT_VFE_MSG_CONFIG_COMPLETE                                                  = 0x49E, /* 1182 */
  EVENT_VFE_MSG_IDLE_COMPLETE                                                    = 0x49F, /* 1183 */
  EVENT_VFE_MSG_UPDATE_COMPLETE                                                  = 0x4A0, /* 1184 */
  EVENT_VFE_MSG_AE_AWB_STATS                                                     = 0x4A1, /* 1185 */
  EVENT_DSP_VIDEO_ENC_DOWNLOAD_DONE                                              = 0x4A2, /* 1186 */
  EVENT_DSP_VIDEO_ENC_SELECTION_DONE                                             = 0x4A3, /* 1187 */
  EVENT_DSP_VIDEO_ENC_CONFIG_DONE                                                = 0x4A4, /* 1188 */
  EVENT_DSP_VIDEO_ENC_FRAME_DONE                                                 = 0x4A5, /* 1189 */
  EVENT_HDR_OVHD_BCMCS_CHAN_CHANGE                                               = 0x4A6, /* 1190 */
  EVENT_QVS_REGISTER_START                                                       = 0x4A7, /* 1191 */
  EVENT_QVS_REGISTER_DONE                                                        = 0x4A8, /* 1192 */
  EVENT_QVS_REGISTER_FAILED                                                      = 0x4A9, /* 1193 */
  EVENT_QVS_CALL_SETUP_START                                                     = 0x4AA, /* 1194 */
  EVENT_QVS_CALL_SETUP_DONE                                                      = 0x4AB, /* 1195 */
  EVENT_QVS_CALL_SETUP_FAILED                                                    = 0x4AC, /* 1196 */
  EVENT_QVS_CALL_RELEASE_START                                                   = 0x4AD, /* 1197 */
  EVENT_QVS_CALL_RELEASE_DONE                                                    = 0x4AE, /* 1198 */
  EVENT_QVS_CALL_RELEASE_FAILED                                                  = 0x4AF, /* 1199 */
  EVENT_CAMCORDER_START_RECORD                                                   = 0x4B0, /* 1200 */
  EVENT_CAMCORDER_START_TRANSCODE                                                = 0x4B1, /* 1201 */
  EVENT_CAMCORDER_FRAME_DROP                                                     = 0x4B2, /* 1202 */
  EVENT_CAMCORDER_AUDIODUB                                                       = 0x4B3, /* 1203 */
  EVENT_PSMM_SENT                                                                = 0x4B4, /* 1204 */
  EVENT_GPS_PD_FALLBACK_MODE                                                     = 0x4B5, /* 1205 */
  EVENT_PEAP                                                                     = 0x4B6, /* 1206 */
  EVENT_TTLS                                                                     = 0x4B7, /* 1207 */
  EVENT_TLS                                                                      = 0x4B8, /* 1208 */
  EVENT_WCDMA_TO_WCDMA_RESELECTION_VER2_START                                    = 0x4B9, /* 1209 */
  EVENT_EUL_RECONFIG_OR_ASU                                                      = 0x4BA, /* 1210 */
  EVENT_EUL_SERVING_CELL_CHANGE                                                  = 0x4BB, /* 1211 */
  EVENT_EUL_PHYSICAL_LAYER_RECONFIG                                              = 0x4BC, /* 1212 */
  EVENT_DRM_ROAP_TRIGGER_RECIEVED                                                = 0x4BD, /* 1213 */
  EVENT_DRM_ROAP_PROTOCOL_START                                                  = 0x4BE, /* 1214 */
  EVENT_DRM_ROAP_REQUEST                                                         = 0x4BF, /* 1215 */
  EVENT_DRM_ROAP_REQUEST_EXTENSION                                               = 0x4C0, /* 1216 */
  EVENT_DRM_ROAP_RESPONSE                                                        = 0x4C1, /* 1217 */
  EVENT_DRM_ROAP_RESPONSE_EXTENSION                                              = 0x4C2, /* 1218 */
  EVENT_DRM_ROAP_RI_CONTEXT                                                      = 0x4C3, /* 1219 */
  EVENT_DRM_ROAP_ERROR                                                           = 0x4C4, /* 1220 */
  EVENT_DRM_ROAP_RSP_VALIDATION                                                  = 0x4C5, /* 1221 */
  EVENT_DRM_ROAP_PROTOCOL_END                                                    = 0x4C6, /* 1222 */
  EVENT_DS_WMK_ALLOCATED                                                         = 0x4C7, /* 1223 */
  EVENT_DS_WMK_DEALLOCATED                                                       = 0x4C8, /* 1224 */
  EVENT_DS_WMK_FLUSHED                                                           = 0x4C9, /* 1225 */
  EVENT_DS_WMK_FLOW_ENABLED                                                      = 0x4CA, /* 1226 */
  EVENT_DS_WMK_FLOW_DISABLED                                                     = 0x4CB, /* 1227 */
  EVENT_HDR_IDLE_SET_SLEEP_DURATION                                              = 0x4CC, /* 1228 */
  EVENT_HDR_SCM_SESSION_CHANGED                                                  = 0x4CD, /* 1229 */
  EVENT_UMTS_TO_CDMA_DATA_HANDOVER                                               = 0x4CE, /* 1230 */
  EVENT_UMTS_TO_CDMA_VOICE_HANDOVER                                              = 0x4CF, /* 1231 */
  EVENT_MO_SMS_RETRY_ATTEMPT                                                     = 0x4D0, /* 1232 */
  EVENT_HDR_LMAC_UPDATE_QSM_STATUS                                               = 0x4D1, /* 1233 */
  EVENT_CM_CELL_SRV_IND                                                          = 0x4D2, /* 1234 */
  EVENT_RLP_NAK_ABORT                                                            = 0x4D3, /* 1235 */
  EVENT_DRM_RIGHTS_OPERATION                                                     = 0x4D4, /* 1236 */
  EVENT_DS_RESV_MSG_SENT_REV_FLOWS                                               = 0x4D5, /* 1237 */
  EVENT_DS_RESV_MSG_SENT_FWD_FLOWS                                               = 0x4D6, /* 1238 */
  EVENT_DS_RESV_RESP_SUCCESS_RECD                                                = 0x4D7, /* 1239 */
  EVENT_DS_RESV_RESP_FAILURE_RECD                                                = 0x4D8, /* 1240 */
  EVENT_GPS_PD_COMM_FAILURE                                                      = 0x4D9, /* 1241 */
  EVENT_GPS_PD_COMM_DONE                                                         = 0x4DA, /* 1242 */
  EVENT_GPS_PD_EVENT_END                                                         = 0x4DB, /* 1243 */
  EVENT_GPS_PA_EVENT_CALLBACK                                                    = 0x4DC, /* 1244 */
  EVENT_GPS_PD_CMD_ERR_CALLBACK                                                  = 0x4DD, /* 1245 */
  EVENT_GPS_PA_CMD_ERR_CALLBACK                                                  = 0x4DE, /* 1246 */
  EVENT_GPS_LM_ENTER_SA_RF_VERIF                                                 = 0x4DF, /* 1247 */
  EVENT_GPS_LM_EXIT_SA_RF_VERIF                                                  = 0x4E0, /* 1248 */
  EVENT_GPS_LM_ERROR_SA_RF_VERIF                                                 = 0x4E1, /* 1249 */
  EVENT_GPS_LM_PD_COMPLETE                                                       = 0x4E2, /* 1250 */
  EVENT_GPS_LM_IQ_TEST_COMPLETE                                                  = 0x4E3, /* 1251 */
  EVENT_PM_APP_OTG_INIT                                                          = 0x4E4, /* 1252 */
  EVENT_PM_APP_OTG_RESET                                                         = 0x4E5, /* 1253 */
  EVENT_PM_APP_OTG_ACQUIRE_BUS_REQ                                               = 0x4E6, /* 1254 */
  EVENT_PM_APP_OTG_RELINQUISH_BUS_REQ                                            = 0x4E7, /* 1255 */
  EVENT_PM_APP_OTG_SUSPEND                                                       = 0x4E8, /* 1256 */
  EVENT_PM_APP_OTG_RESUME                                                        = 0x4E9, /* 1257 */
  EVENT_PM_APP_OTG_DEVICE_ATTACHED                                               = 0x4EA, /* 1258 */
  EVENT_PM_APP_OTG_DEVICE_DETACHED                                               = 0x4EB, /* 1259 */
  EVENT_PM_APP_OTG_HOST_MODE_REM_PERI_DIS                                        = 0x4EC, /* 1260 */
  EVENT_PM_APP_OTG_PERI_MODE_PREPARE_FOR_REM_HOST_WAKEUP_SIG                     = 0x4ED, /* 1261 */
  EVENT_PM_APP_OTG_PERI_MODE_REM_HOST_WAKEUP_SIG_DONE                            = 0x4EE, /* 1262 */
  EVENT_PM_APP_OTG_SET_REM_WAKEUP_CAPABILITY                                     = 0x4EF, /* 1263 */
  EVENT_PM_APP_OTG_OPERATIONAL_ERROR                                             = 0x4F0, /* 1264 */
  EVENT_PM_APP_OTG_CONFIGURE_USB_POWER_CONSUMER                                  = 0x4F1, /* 1265 */
  EVENT_PM_APP_OTG_SET_USB_POWER_CONSUMPTION_REQUIREMENT                         = 0x4F2, /* 1266 */
  EVENT_PM_APP_OTG_PERI_MODE_PROCESS_USB_POWER_LINE_CONT_REQ                     = 0x4F3, /* 1267 */
  EVENT_PM_APP_OTG_PERI_MODE_SET_REM_A_DEV_INFO                                  = 0x4F4, /* 1268 */
  EVENT_PM_APP_OTG_STATE_TRANSITION                                              = 0x4F5, /* 1269 */
  EVENT_DTV_TABLE_ACQ_SUCCESS                                                    = 0x4F6, /* 1270 */
  EVENT_DTV_TABLE_ACQ_FAIL                                                       = 0x4F7, /* 1271 */
  EVENT_DTV_DVBH_SEL_PLTFM_REQ_RCVD                                              = 0x4F8, /* 1272 */
  EVENT_DTV_DVBH_PLTFM_ACQ_SUCCESS                                               = 0x4F9, /* 1273 */
  EVENT_DTV_DVBH_PLTFM_ACQ_FAIL                                                  = 0x4FA, /* 1274 */
  EVENT_DTV_DVBH_TBL_MGR_STATE_CHANGED                                           = 0x4FB, /* 1275 */
  EVENT_DTV_DVBH_CE_STATE_CHANGED                                                = 0x4FC, /* 1276 */
  EVENT_DTV_DVBH_MCAST_JOIN_REQ_RCVD                                             = 0x4FD, /* 1277 */
  EVENT_DTV_DVBH_MCAST_LEAVE_REQ_RCVD                                            = 0x4FE, /* 1278 */
  EVENT_DTV_DVBH_INIT_REQ_RCVD                                                   = 0x4FF, /* 1279 */
  EVENT_DTV_DVBH_MCAST_JOIN_SUCCESS                                              = 0x500, /* 1280 */
  EVENT_DTV_DVBH_MCAST_JOIN_FAILURE                                              = 0x501, /* 1281 */
  EVENT_DTV_DVBH_MCAST_LEAVE_SUCCESS                                             = 0x502, /* 1282 */
  EVENT_DTV_DVBH_MCAST_LEAVE_FAILURE                                             = 0x503, /* 1283 */
  EVENT_DTV_DVBH_INIT_SUCCESS                                                    = 0x504, /* 1284 */
  EVENT_DTV_DVBH_INIT_FAILURE                                                    = 0x505, /* 1285 */
  EVENT_GPS_LM_SESSION_START                                                     = 0x506, /* 1286 */
  EVENT_GPS_LM_SESSION_END                                                       = 0x507, /* 1287 */
  EVENT_GPS_LM_FIX_REQUEST_START                                                 = 0x508, /* 1288 */
  EVENT_GPS_LM_FIX_REQUEST_END                                                   = 0x509, /* 1289 */
  EVENT_GPS_LM_PRM_REQUEST_START                                                 = 0x50A, /* 1290 */
  EVENT_GPS_LM_PRM_REQUEST_END                                                   = 0x50B, /* 1291 */
  EVENT_GPS_LM_SESSION_CONTINUE                                                  = 0x50C, /* 1292 */
  EVENT_GPS_LM_FIX_REQUEST_CONTINUE                                              = 0x50D, /* 1293 */
  EVENT_GPS_LM_PRM_REQUEST_CONTINUE                                              = 0x50E, /* 1294 */
  EVENT_GPS_LM_PPM_REQUEST_CONTINUE                                              = 0x50F, /* 1295 */
  EVENT_GPS_LM_AIDING_DATA_RECEIVED                                              = 0x510, /* 1296 */
  EVENT_GPS_LM_RC_ON_TIMER_TIMEOUT                                               = 0x511, /* 1297 */
  EVENT_GPS_LM_SHUT_OFF_TIMER_TIMEOUT                                            = 0x512, /* 1298 */
  EVENT_GPS_LM_MGP_ON                                                            = 0x513, /* 1299 */
  EVENT_GPS_LM_MGP_IDLE                                                          = 0x514, /* 1300 */
  EVENT_GPS_LM_MGP_OFF                                                           = 0x515, /* 1301 */
  EVENT_DRM_RO_CONSUMPTION_VALIDATION                                            = 0x516, /* 1302 */
  EVENT_DRM_RO_INSTALLATION_VALIDATION                                           = 0x517, /* 1303 */
  EVENT_FLUTE_FDT_INST_RCVD                                                      = 0x518, /* 1304 */
  EVENT_FLUTE_FDT_INST_RCV_FAIL                                                  = 0x519, /* 1305 */
  EVENT_FLUTE_FDT_INST_EXPIRED                                                   = 0x51A, /* 1306 */
  EVENT_FLUTE_JOIN_SESSION_REQ_RCVD                                              = 0x51B, /* 1307 */
  EVENT_FLUTE_LEAVE_SESSION_REQ_RCVD                                             = 0x51C, /* 1308 */
  EVENT_FLUTE_SESSION_CLOSED                                                     = 0x51D, /* 1309 */
  EVENT_FLUTE_SESSION_CLOSED_BY_APP                                              = 0x51E, /* 1310 */
  EVENT_FLUTE_B_FLAG_RCVD                                                        = 0x51F, /* 1311 */
  EVENT_FLUTE_GET_FILE_REQUEST_RCVD                                              = 0x520, /* 1312 */
  EVENT_FLUTE_JOIN_SESSION_RSP                                                   = 0x521, /* 1313 */
  EVENT_FLUTE_FILE_STATUS_RSP                                                    = 0x522, /* 1314 */
  EVENT_FLUTE_CANCEL_FILE_REQ_RCVD                                               = 0x523, /* 1315 */
  EVENT_DTV_DVBH_DEINIT_REQ_RCVD                                                 = 0x524, /* 1316 */
  EVENT_DTV_DVBH_DEINIT_SUCCESS                                                  = 0x525, /* 1317 */
  EVENT_DTV_DVBH_DEINIT_FAILURE                                                  = 0x526, /* 1318 */
  EVENT_CONTENT_INSTALL_BEGIN                                                    = 0x527, /* 1319 */
  EVENT_CONTENT_INSTALL_COMPLETE                                                 = 0x528, /* 1320 */
  EVENT_CONTENT_RETRIEVAL_BEGIN                                                  = 0x529, /* 1321 */
  EVENT_CONTENT_RETRIEVAL_COMPLETE                                               = 0x52A, /* 1322 */
  EVENT_CONTENT_BACKUP_BEGIN                                                     = 0x52B, /* 1323 */
  EVENT_CONTENT_BACKUP_COMPLETE                                                  = 0x52C, /* 1324 */
  EVENT_CONTENT_FWD_BEGIN                                                        = 0x52D, /* 1325 */
  EVENT_CONTENT_FWD_COMPLETE                                                     = 0x52E, /* 1326 */
  EVENT_HARD_HANDOFF_VOIP_TO_CDMA                                                = 0x52F, /* 1327 */
  EVENT_EAP_SIM_AKA                                                              = 0x530, /* 1328 */
  EVENT_WLAN_CP_MEAS                                                             = 0x531, /* 1329 */
  EVENT_WLAN_CP_HO                                                               = 0x532, /* 1330 */
  EVENT_WLAN_CP_11D                                                              = 0x533, /* 1331 */
  EVENT_WLAN_MC                                                                  = 0x534, /* 1332 */
  EVENT_SVG_CONTENT_SET                                                          = 0x535, /* 1333 */
  EVENT_SVG_CONTENT_PLAY                                                         = 0x536, /* 1334 */
  EVENT_SVG_CONTENT_RESUME                                                       = 0x537, /* 1335 */
  EVENT_SVG_CONTENT_PAUSE                                                        = 0x538, /* 1336 */
  EVENT_SVG_CONTENT_STOP                                                         = 0x539, /* 1337 */
  EVENT_SVG_CONTENT_USEREVENT                                                    = 0x53A, /* 1338 */
  EVENT_SVG_CONTENT_GETURIDATA                                                   = 0x53B, /* 1339 */
  EVENT_SVG_CONTENT_TRANSFORM                                                    = 0x53C, /* 1340 */
  EVENT_SVG_GET_PARAM                                                            = 0x53D, /* 1341 */
  EVENT_SVG_SET_PARAM                                                            = 0x53E, /* 1342 */
  EVENT_WLAN_WPA2                                                                = 0x53F, /* 1343 */
  EVENT_WCDMA_PSC_SCANNER_STOP                                                   = 0x540, /* 1344 */
  EVENT_MEDIA_PLAYER_KEYPRESS                                                    = 0x541, /* 1345 */
  EVENT_WLAN_MC_QOS                                                              = 0x542, /* 1346 */
  EVENT_WCDMA_PSC_SCANNER_STATE                                                  = 0x543, /* 1347 */
  EVENT_WLAN_CP_ADHOC                                                            = 0x544, /* 1348 */
  EVENT_DMB_STACK_SHUTDOWN                                                       = 0x545, /* 1349 */
  EVENT_DMB_TUNE_DONE_SUCCESS                                                    = 0x546, /* 1350 */
  EVENT_DMB_TUNE_DONE_FAILURE                                                    = 0x547, /* 1351 */
  EVENT_DMB_SEARCH_DONE                                                          = 0x548, /* 1352 */
  EVENT_DMB_SCAN_DONE                                                            = 0x549, /* 1353 */
  EVENT_DMB_RECEPTION_INFO_CHANGED                                               = 0x54A, /* 1354 */
  EVENT_DMB_DMB_GUIDE_CHANGED                                                    = 0x54B, /* 1355 */
  EVENT_DMB_LOCATION_INFO_CHANGED                                                = 0x54C, /* 1356 */
  EVENT_DMB_LOST_ENSEMBLE                                                        = 0x54D, /* 1357 */
  EVENT_DMB_STREAM_TERMINATED                                                    = 0x54E, /* 1358 */
  EVENT_DMB_STREAM_DATA_AVAILABLE                                                = 0x54F, /* 1359 */
  EVENT_DMB_RESERVED1                                                            = 0x550, /* 1360 */
  EVENT_DMB_RESERVED2                                                            = 0x551, /* 1361 */
  EVENT_DMB_RESERVED3                                                            = 0x552, /* 1362 */
  EVENT_DMB_RESERVED4                                                            = 0x553, /* 1363 */
  EVENT_DMB_RESERVED5                                                            = 0x554, /* 1364 */
  EVENT_DMB_RESERVED6                                                            = 0x555, /* 1365 */
  EVENT_DMB_RESERVED7                                                            = 0x556, /* 1366 */
  EVENT_DMB_RESERVED8                                                            = 0x557, /* 1367 */
  EVENT_DMB_RESERVED9                                                            = 0x558, /* 1368 */
  EVENT_DMB_RESERVED10                                                           = 0x559, /* 1369 */
  EVENT_MOBILEVIEW_RESERVED1                                                     = 0x55A, /* 1370 */
  EVENT_MOBILEVIEW_RESERVED2                                                     = 0x55B, /* 1371 */
  EVENT_MOBILEVIEW_RESERVED3                                                     = 0x55C, /* 1372 */
  EVENT_MOBILEVIEW_RESERVED4                                                     = 0x55D, /* 1373 */
  EVENT_MOBILEVIEW_RESERVED5                                                     = 0x55E, /* 1374 */
  EVENT_HDR_DOS_MO_DOS_STATUS                                                    = 0x55F, /* 1375 */
  EVENT_GPSONEXTRA_START_DOWNLOAD                                                = 0x560, /* 1376 */
  EVENT_GPSONEXTRA_END_DOWNLOAD                                                  = 0x561, /* 1377 */
  EVENT_SNSD_GENERIC                                                             = 0x562, /* 1378 */
  EVENT_SNSD_DEVICE_INIT                                                         = 0x563, /* 1379 */
  EVENT_SNSD_DEVICE_CONFIGURED                                                   = 0x564, /* 1380 */
  EVENT_SNSD_EVENT_DATA_READY                                                    = 0x565, /* 1381 */
  EVENT_SNSD_EVENT_COND_MET                                                      = 0x566, /* 1382 */
  EVENT_SNSD_DEVICE_DOWN                                                         = 0x567, /* 1383 */
  EVENT_SNSD_ERROR                                                               = 0x568, /* 1384 */
  EVENT_CM_COUNTRY_SELECTED                                                      = 0x569, /* 1385 */
  EVENT_CM_SELECT_COUNTRY                                                        = 0x56A, /* 1386 */
  EVENT_GPS_DCME_NEW_SV_ADDED_IN_AA                                              = 0x56B, /* 1387 */
  EVENT_GPS_DCME_SV_REMOVED_FROM_AA                                              = 0x56C, /* 1388 */
  EVENT_ESG_GET_PROV_LIST_REQ_RCVD                                               = 0x56D, /* 1389 */
  EVENT_ESG_GET_PROV_LIST_REQ_FAIL                                               = 0x56E, /* 1390 */
  EVENT_ESG_PROV_LIST_AVAILABLE                                                  = 0x56F, /* 1391 */
  EVENT_ESG_ACQ_REQ_RCVD                                                         = 0x570, /* 1392 */
  EVENT_ESG_ACQ_REQ_FAIL                                                         = 0x571, /* 1393 */
  EVENT_ESG_STOP_REQ_RCVD                                                        = 0x572, /* 1394 */
  EVENT_ESG_STOP_REQ_FAIL                                                        = 0x573, /* 1395 */
  EVENT_ESG_STOP_COMPLETE                                                        = 0x574, /* 1396 */
  EVENT_ADC_ONDIE_THERM_READ                                                     = 0x575, /* 1397 */
  EVENT_CONTENT_NO_VALID_OR_EXPIRED_RIGHTS                                       = 0x576, /* 1398 */
  EVENT_MOBILEVIEW_RESERVED30                                                    = 0x577, /* 1399 */
  EVENT_MOBILEVIEW_RESERVED31                                                    = 0x578, /* 1400 */
  EVENT_MOBILEVIEW_RESERVED32                                                    = 0x579, /* 1401 */
  EVENT_GPS_DCME_MEAS_CYCLE_START                                                = 0x57A, /* 1402 */
  EVENT_GPS_DCME_MEAS_CYCLE_END                                                  = 0x57B, /* 1403 */
  EVENT_GPS_CME_ENGAGED                                                          = 0x57C, /* 1404 */
  EVENT_GPS_CME_NOT_ENGAGED                                                      = 0x57D, /* 1405 */
  EVENT_GPS_DCME_ENGAGED                                                         = 0x57E, /* 1406 */
  EVENT_GPS_DCME_NOT_ENGAGED                                                     = 0x57F, /* 1407 */
  EVENT_HS_USB_DEVICE_ATTACHED                                                   = 0x580, /* 1408 */
  EVENT_HS_USB_HID_DISCONECT                                                     = 0x581, /* 1409 */
  EVENT_HS_USB_HID_CONNECT                                                       = 0x582, /* 1410 */
  EVENT_HS_USB_MSD_CONNECT                                                       = 0x583, /* 1411 */
  EVENT_HS_USB_MSD_DISCONECT                                                     = 0x584, /* 1412 */
  EVENT_HS_USB_STACK_SUSPENDED                                                   = 0x585, /* 1413 */
  EVENT_HS_USB_STACK_RESUMED                                                     = 0x586, /* 1414 */
  EVENT_HS_USB_ENTER_HOST_MODE                                                   = 0x587, /* 1415 */
  EVENT_HS_USB_OPERATIONAL_ERROR                                                 = 0x588, /* 1416 */
  EVENT_DTV_L1_ACQ_DONE                                                          = 0x589, /* 1417 */
  EVENT_DTV_L1_SCAN                                                              = 0x58A, /* 1418 */
  EVENT_DTV_L1_ONLINE                                                            = 0x58B, /* 1419 */
  EVENT_DTV_L1_SNOOZE                                                            = 0x58C, /* 1420 */
  EVENT_DTV_L1_SLEEP                                                             = 0x58D, /* 1421 */
  EVENT_DTV_L1_HANDOFF                                                           = 0x58E, /* 1422 */
  EVENT_DTV_L1_SIGNAL_LOST                                                       = 0x58F, /* 1423 */
  EVENT_IMS_SIP_REGISTRATION_START                                               = 0x590, /* 1424 */
  EVENT_IMS_SIP_REGISTER_END                                                     = 0x591, /* 1425 */
  EVENT_IMS_SIP_DEREGISTER_START                                                 = 0x592, /* 1426 */
  EVENT_IMS_SIP_DEREGISTER_END                                                   = 0x593, /* 1427 */
  EVENT_IMS_SIP_SESSION_START                                                    = 0x594, /* 1428 */
  EVENT_IMS_SIP_SESSION_RINGING                                                  = 0x595, /* 1429 */
  EVENT_IMS_SIP_SESSION_ESTABLISHED                                              = 0x596, /* 1430 */
  EVENT_IMS_SIP_SESSION_TERMINATED                                               = 0x597, /* 1431 */
  EVENT_IMS_SIP_SESSION_CANCEL                                                   = 0x598, /* 1432 */
  EVENT_IMS_SIP_SESSION_FAILURE                                                  = 0x599, /* 1433 */
  EVENT_IMS_SIP_RESPONSE_RECV                                                    = 0x59A, /* 1434 */
  EVENT_IMS_SIP_REQUEST_RECV                                                     = 0x59B, /* 1435 */
  EVENT_IMS_SIP_RESPONSE_SEND                                                    = 0x59C, /* 1436 */
  EVENT_IMS_SIP_REQUEST_SEND                                                     = 0x59D, /* 1437 */
  EVENT_WLAN_TKIP_COUNTER_MEAS                                                   = 0x59E, /* 1438 */
  EVENT_GPS_BLANKING_OFF                                                         = 0x59F, /* 1439 */
  EVENT_GPS_BLANKING_ON                                                          = 0x5A0, /* 1440 */
  EVENT_MMGSDI_EVENT                                                             = 0x5A1, /* 1441 */
  EVENT_WLAN_CP_SYS_MGR_STATE_TRANS                                              = 0x5A2, /* 1442 */
  EVENT_GPS_OPTIMISTIC_PUNC_START                                                = 0x5A3, /* 1443 */
  EVENT_GPS_OPTIMISTIC_PUNC_END                                                  = 0x5A4, /* 1444 */
  EVENT_QVP_SEND_RTP_PACKET                                                      = 0x5A5, /* 1445 */
  EVENT_QVP_RECV_RTP_PACKET                                                      = 0x5A6, /* 1446 */
  EVENT_HDR_IDLE_REACQ_FAIL_DDARF                                                = 0x5A7, /* 1447 */
  EVENT_BCAST_SEC_STKM_PARSE_STATUS                                              = 0x5A8, /* 1448 */
  EVENT_BCAST_SEC_STKM_RECEIVED                                                  = 0x5A9, /* 1449 */
  EVENT_BCAST_SEC_SDP_PARSE_STATUS                                               = 0x5AA, /* 1450 */
  EVENT_CGPS_ME_DPO_STATUS                                                       = 0x5AB, /* 1451 */
  EVENT_GPS_SV_SEARCH_STATE                                                      = 0x5AC, /* 1452 */
  EVENT_GPS_TM_ON_DEMAND_MODE_CHANGE                                             = 0x5AD, /* 1453 */
  EVENT_GPS_TM_ON_DEMAND_BEGIN                                                   = 0x5AE, /* 1454 */
  EVENT_GPS_TM_ON_DEMAND_DONE                                                    = 0x5AF, /* 1455 */
  EVENT_RMAC_CARRIER_STATE_CHANGED                                               = 0x5B0, /* 1456 */
  EVENT_GPS_SBAS_DEMOD_REPORT                                                    = 0x5B1, /* 1457 */
  EVENT_GPS_EXTERN_COARSE_POS_INJ_START                                          = 0x5B2, /* 1458 */
  EVENT_GPS_EXTERN_COARSE_POS_INJ_END                                            = 0x5B3, /* 1459 */
  EVENT_GPS_EPH_REREQUEST_TIME                                                   = 0x5B4, /* 1460 */
  EVENT_WLAN_QOS_PSTREAM                                                         = 0x5B5, /* 1461 */
  EVENT_WLAN_CP_VCC                                                              = 0x5B6, /* 1462 */
  EVENT_CGPS_DIAG_FIRST_SUCCESSFUL_FIX                                           = 0x5B7, /* 1463 */
  EVENT_EUL_RECONFIG_OR_ASU_OR_TTI_RECFG                                         = 0x5B8, /* 1464 */
  EVENT_DS707_PKT_LN_UPDATE                                                      = 0x5B9, /* 1465 */
  EVENT_DS707_PKT_IDM_CHANGE                                                     = 0x5BA, /* 1466 */
  EVENT_RLP_QN_ADD                                                               = 0x5BB, /* 1467 */
  EVENT_RLP_QN_DROP                                                              = 0x5BC, /* 1468 */
  EVENT_RLP_MULTILINK_NAK                                                        = 0x5BD, /* 1469 */
  EVENT_RLP_REV_LINK_NAK                                                         = 0x5BE, /* 1470 */
  EVENT_GSTK_EVENT                                                               = 0x5BF, /* 1471 */
  EVENT_GAN_REGISTRATION_REQUEST                                                 = 0x5C0, /* 1472 */
  EVENT_GAN_REGISTER_ACCEPT                                                      = 0x5C1, /* 1473 */
  EVENT_CALL_RINGING_ALERT                                                       = 0x5C2, /* 1474 */
  EVENT_GAN_PAGING_RECEIVED                                                      = 0x5C3, /* 1475 */
  EVENT_GAN_CALL_DISCONNECT                                                      = 0x5C4, /* 1476 */
  EVENT_GAN_CALL_RELEASE_COMPLETE                                                = 0x5C5, /* 1477 */
  EVENT_GAN_HANDIN_COMMAND                                                       = 0x5C6, /* 1478 */
  EVENT_GAN_HANDIN_COMPLETE                                                      = 0x5C7, /* 1479 */
  EVENT_GAN_HANDOUT_COMMAND                                                      = 0x5C8, /* 1480 */
  EVENT_GAN_HANDOUT_COMPLETE                                                     = 0x5C9, /* 1481 */
  EVENT_GAN_SMS_START                                                            = 0x5CA, /* 1482 */
  EVENT_GAN_SMS_ACK                                                              = 0x5CB, /* 1483 */
  EVENT_GAN_QDJ_ENQUEUE                                                          = 0x5CC, /* 1484 */
  EVENT_GAN_QDJ_DEQUEUE                                                          = 0x5CD, /* 1485 */
  EVENT_GAN_ACTIVATE_DATA_CHANNEL                                                = 0x5CE, /* 1486 */
  EVENT_GAN_DATA_CHANNEL_CONNECTED                                               = 0x5CF, /* 1487 */
  EVENT_GAN_RLP_SUSPEND                                                          = 0x5D0, /* 1488 */
  EVENT_GAN_RLP_RESUME                                                           = 0x5D1, /* 1489 */
  EVENT_GAN_WAKEUP_REQ                                                           = 0x5D2, /* 1490 */
  EVENT_GAN_WAKEUP_CNF                                                           = 0x5D3, /* 1491 */
  EVENT_GAN_HIBERNATION_REQ                                                      = 0x5D4, /* 1492 */
  EVENT_GAN_HIBERNATION_CNF                                                      = 0x5D5, /* 1493 */
  EVENT_WCDMA_UL_AMR_RATE                                                        = 0x5D6, /* 1494 */
  EVENT_EUL_TTI_RECONFIG                                                         = 0x5D7, /* 1495 */
  EVENT_WCDMA_CONN_REL_CAUSE                                                     = 0x5D8, /* 1496 */
  EVENT_WCDMA_CONN_REQ_CAUSE                                                     = 0x5D9, /* 1497 */
  EVENT_LTE_TIMING_ADVANCE                                                       = 0x5DA, /* 1498 */
  EVENT_LTE_UL_OUT_OF_SYNC                                                       = 0x5DB, /* 1499 */
  EVENT_LTE_SPS_DEACTIVATED                                                      = 0x5DC, /* 1500 */
  EVENT_LTE_RACH_ACCESS_START                                                    = 0x5DD, /* 1501 */
  EVENT_LTE_RACH_RAID_MATCH                                                      = 0x5DE, /* 1502 */
  EVENT_LTE_RACH_ACCESS_RESULT                                                   = 0x5DF, /* 1503 */
  EVENT_DTV_L1_POWERUP                                                           = 0x5E0, /* 1504 */
  EVENT_DTV_L1_POWERDOWN                                                         = 0x5E1, /* 1505 */
  EVENT_DTV_L1_SOFT_RESET                                                        = 0x5E2, /* 1506 */
  EVENT_DTV_L1_STATE_CHANGE                                                      = 0x5E3, /* 1507 */
  EVENT_DTV_L1_ACQ_TUNE_STATUS                                                   = 0x5E4, /* 1508 */
  EVENT_DTV_L1_ACQ_DONE_STATUS                                                   = 0x5E5, /* 1509 */
  EVENT_DTV_L1_ACQ_FAIL                                                          = 0x5E6, /* 1510 */
  EVENT_DTV_L1_TRAFFIC_STARTED                                                   = 0x5E7, /* 1511 */
  EVENT_DTV_L1_BAD_FRAME_RECEIVED                                                = 0x5E8, /* 1512 */
  EVENT_DTV_L1_TMCC_FAILURE                                                      = 0x5E9, /* 1513 */
  EVENT_DTV_L1_RECOVERY_STATUS                                                   = 0x5EA, /* 1514 */
  EVENT_DTV_L1_INTERRUPT_LOG_RECEIVED                                            = 0x5EB, /* 1515 */
  EVENT_DTV_L1_L3_API_COMMAND                                                    = 0x5EC, /* 1516 */
  EVENT_DTV_L1_MODEM_FAILURE                                                     = 0x5ED, /* 1517 */
  EVENT_GSM_CALL_DROP                                                            = 0x5EE, /* 1518 */
  EVENT_GSM_ACCESS_FAILURE                                                       = 0x5EF, /* 1519 */
  EVENT_DTV_ISDB_ACTIVATE                                                        = 0x5F0, /* 1520 */
  EVENT_DTV_ISDB_DEACTIVATE                                                      = 0x5F1, /* 1521 */
  EVENT_DTV_ISDB_TUNE                                                            = 0x5F2, /* 1522 */
  EVENT_DTV_ISDB_UNTUNE                                                          = 0x5F3, /* 1523 */
  EVENT_DTV_ISDB_SELECT_SERVICE                                                  = 0x5F4, /* 1524 */
  EVENT_DTV_ISDB_SERVICE_AVAILABLE                                               = 0x5F5, /* 1525 */
  EVENT_DTV_ISDB_TRAFFIC_LOST                                                    = 0x5F6, /* 1526 */
  EVENT_DTV_ISDB_TABLE_UPDATE                                                    = 0x5F7, /* 1527 */
  EVENT_DTV_ISDB_TRACKS_SELECTED                                                 = 0x5F8, /* 1528 */
  EVENT_DTV_ISDB_PES_BUFFER_OVERFLOW                                             = 0x5F9, /* 1529 */
  EVENT_DTV_ISDB_PES_BUFFER_UNDERFLOW                                            = 0x5FA, /* 1530 */
  EVENT_DTV_ISDB_ACQUIRE_DATA_COMPONENT                                          = 0x5FB, /* 1531 */
  EVENT_DTV_ISDB_STOP_COMPONENT_ACQUISITION                                      = 0x5FC, /* 1532 */
  EVENT_DTV_ISDB_DII_CHANGED                                                     = 0x5FD, /* 1533 */
  EVENT_DTV_ISDB_DATA_EVENT_MESSAGE                                              = 0x5FE, /* 1534 */
  EVENT_DTV_ISDB_MODULE_CONSTRUCTION                                             = 0x5FF, /* 1535 */
  EVENT_DTV_ISDB_PARSING_ERROR                                                   = 0x600, /* 1536 */
  EVENT_HDR_SLP_SLPQH_TIMER_STARTED                                              = 0x601, /* 1537 */
  EVENT_HDR_SLP_SLPQH_TIMER_STOPPED                                              = 0x602, /* 1538 */
  EVENT_HDR_SLP_SLPQH_NUM_PENDING_MSGS                                           = 0x603, /* 1539 */
  EVENT_HDR_OVHD_FIND_CACHED_MSG                                                 = 0x604, /* 1540 */
  EVENT_WCDMA_RRC_TIMER_EXPIRED                                                  = 0x605, /* 1541 */
  EVENT_WCDMA_UOOS_TIMER_USED                                                    = 0x606, /* 1542 */
  EVENT_WCDMA_UOOS_TIMER_START                                                   = 0x607, /* 1543 */
  EVENT_WCDMA_UOOS_TIMER_STOP                                                    = 0x608, /* 1544 */
  EVENT_WCDMA_UOOS_TIME_REMAINING                                                = 0x609, /* 1545 */
  EVENT_WCDMA_RRCCSP_SCAN_START                                                  = 0x60A, /* 1546 */
  EVENT_WCDMA_ACQUISITON_SUCCESS                                                 = 0x60B, /* 1547 */
  EVENT_WCDMA_CELL_SELECTION_FAIL                                                = 0x60C, /* 1548 */
  EVENT_WCDMA_BPLMN_START                                                        = 0x60D, /* 1549 */
  EVENT_WCDMA_BPLMN_END                                                          = 0x60E, /* 1550 */
  EVENT_WCDMA_BPLMN_SCAN_START                                                   = 0x60F, /* 1551 */
  EVENT_WCDMA_BPLMN_SCAN_END                                                     = 0x610, /* 1552 */
  EVENT_MSG_HIGH                                                                 = 0x611, /* 1553 */
  EVENT_MSG_MED                                                                  = 0x612, /* 1554 */
  EVENT_MSG_LOW                                                                  = 0x613, /* 1555 */
  EVENT_MSG_ERROR                                                                = 0x614, /* 1556 */
  EVENT_MSG_FATAL                                                                = 0x615, /* 1557 */
  EVENT_GAN_START_TU3910                                                         = 0x616, /* 1558 */
  EVENT_GAN_STOP_TU3910                                                          = 0x617, /* 1559 */
  EVENT_GAN_EXPIRY_TU3910                                                        = 0x618, /* 1560 */
  EVENT_GAN_START_TU3920                                                         = 0x619, /* 1561 */
  EVENT_GAN_STOP_TU3920                                                          = 0x61A, /* 1562 */
  EVENT_GAN_EXPIRY_TU3920                                                        = 0x61B, /* 1563 */
  EVENT_GAN_START_TU3906                                                         = 0x61C, /* 1564 */
  EVENT_GAN_STOP_TU3906                                                          = 0x61D, /* 1565 */
  EVENT_GAN_EXPIRY_TU3906                                                        = 0x61E, /* 1566 */
  EVENT_GAN_URR_REGISTER_UPDATE                                                  = 0x61F, /* 1567 */
  EVENT_IPSEC_IKE_SA_INIT_SENT                                                   = 0x620, /* 1568 */
  EVENT_IPSEC_IKE_SA_INIT_RECV                                                   = 0x621, /* 1569 */
  EVENT_IPSEC_IKE_SA_ESTABLISHED                                                 = 0x622, /* 1570 */
  EVENT_IPSEC_IKE_AUTH_SENT                                                      = 0x623, /* 1571 */
  EVENT_IPSEC_IKE_AUTH_RECV                                                      = 0x624, /* 1572 */
  EVENT_IPSEC_IKE_EAP_START                                                      = 0x625, /* 1573 */
  EVENT_IPSEC_IKE_EAP_FINISH                                                     = 0x626, /* 1574 */
  EVENT_IPSEC_CHILD_SA_ESTABLISHED                                               = 0x627, /* 1575 */
  EVENT_IPSEC_IKE_INFO_MSG_SENT                                                  = 0x628, /* 1576 */
  EVENT_IPSEC_IKE_INFO_MSG_RECV                                                  = 0x629, /* 1577 */
  EVENT_IPSEC_CREATE_CHILD_SA_SENT                                               = 0x62A, /* 1578 */
  EVENT_IPSEC_CREATE_CHILD_SA_RECV                                               = 0x62B, /* 1579 */
  EVENT_IPSEC_IKE_SA_DELETE_START                                                = 0x62C, /* 1580 */
  EVENT_IPSEC_IKE_SA_DELETE_DONE                                                 = 0x62D, /* 1581 */
  EVENT_IPSEC_CHILD_SA_DELETE_START                                              = 0x62E, /* 1582 */
  EVENT_IPSEC_CHILD_SA_DELETE_DONE                                               = 0x62F, /* 1583 */
  EVENT_IPSEC_IKE_SA_REKEY_START                                                 = 0x630, /* 1584 */
  EVENT_IPSEC_IKE_SA_REKEY_DONE                                                  = 0x631, /* 1585 */
  EVENT_IPSEC_CHILD_SA_REKEY_START                                               = 0x632, /* 1586 */
  EVENT_IPSEC_CHILD_SA_REKEY_DONE                                                = 0x633, /* 1587 */
  EVENT_IPSEC_IKE_MESG_RETRANSMIT                                                = 0x634, /* 1588 */
  EVENT_IPSEC_IKE_NAT_DETECTED                                                   = 0x635, /* 1589 */
  EVENT_IPSEC_IKE_NAT_KEEPALIVE_SENT                                             = 0x636, /* 1590 */
  EVENT_IPSEC_IKE_DPD_SENT                                                       = 0x637, /* 1591 */
  EVENT_IPSEC_IKE_ERR_NOTIFY_SENT                                                = 0x638, /* 1592 */
  EVENT_IPSEC_IKE_ERR_NOTIFY_RECV                                                = 0x639, /* 1593 */
  EVENT_GAN_ROVEIN_CNF                                                           = 0x63A, /* 1594 */
  EVENT_GAN_ROVEOUT_CNF                                                          = 0x63B, /* 1595 */
  EVENT_GAN_RRC_ROVEIN_CNF                                                       = 0x63C, /* 1596 */
  EVENT_GAN_RRC_ROVEIN_REJ                                                       = 0x63D, /* 1597 */
  EVENT_GAN_RRC_ROVEOUT_CNF                                                      = 0x63E, /* 1598 */
  EVENT_GAN_RRC_ROVEOUT_REJ                                                      = 0x63F, /* 1599 */
  EVENT_GPSXTRA_T_SESS_BEGIN                                                     = 0x640, /* 1600 */
  EVENT_GPSXTRA_T_SESS_DATA                                                      = 0x641, /* 1601 */
  EVENT_GPSXTRA_T_SESS_DONE                                                      = 0x642, /* 1602 */
  EVENT_GPSXTRA_T_SESS_END                                                       = 0x643, /* 1603 */
  EVENT_DS_GO_NULL_TIMER                                                         = 0x644, /* 1604 */
  EVENT_LTE_RRC_TIMER_STATUS                                                     = 0x645, /* 1605 */
  EVENT_LTE_RRC_STATE_CHANGE                                                     = 0x646, /* 1606 */
  EVENT_LTE_RRC_OUT_OF_SERVICE                                                   = 0x647, /* 1607 */
  EVENT_LTE_RRC_RADIO_LINK_FAILURE                                               = 0x648, /* 1608 */
  EVENT_LTE_RRC_DL_MSG                                                           = 0x649, /* 1609 */
  EVENT_LTE_RRC_UL_MSG                                                           = 0x64A, /* 1610 */
  EVENT_LTE_RRC_NEW_CELL_IND                                                     = 0x64B, /* 1611 */
  EVENT_LTE_RRC_CELL_RESEL_FAILURE                                               = 0x64C, /* 1612 */
  EVENT_LTE_RRC_HO_FAILURE                                                       = 0x64D, /* 1613 */
  EVENT_LTE_RRC_PAGING_DRX_CYCLE                                                 = 0x64E, /* 1614 */
  EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN                                              = 0x64F, /* 1615 */
  EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN_FAILURE                                      = 0x650, /* 1616 */
  EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN                                           = 0x651, /* 1617 */
  EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_FAILURE                                   = 0x652, /* 1618 */
  EVENT_LTE_RRC_SIB_READ_FAILURE                                                 = 0x653, /* 1619 */
  EVENT_GAN_ROVEIN_REQ                                                           = 0x654, /* 1620 */
  EVENT_GAN_ROVEOUT_REQ                                                          = 0x655, /* 1621 */
  EVENT_MBP_RF_ANALOG_JD_MODE_CHANGE                                             = 0x656, /* 1622 */
  EVENT_MBP_RF_ANALOG_JD_INT                                                     = 0x657, /* 1623 */
  EVENT_CGPS_QWIP_SYSD_TRANSITION                                                = 0x658, /* 1624 */
  EVENT_HPLMN_TIMER_EXPIRED                                                      = 0x659, /* 1625 */
  EVENT_GSDI_GET_FEATURE_INDICATOR_DATA                                          = 0x65A, /* 1626 */
  EVENT_LTE_CM_INCOMING_MSG                                                      = 0x65B, /* 1627 */
  EVENT_LTE_CM_OUTGOING_MSG                                                      = 0x65C, /* 1628 */
  EVENT_LTE_EMM_INCOMING_MSG                                                     = 0x65D, /* 1629 */
  EVENT_LTE_EMM_OUTGOING_MSG                                                     = 0x65E, /* 1630 */
  EVENT_LTE_EMM_TIMER_START                                                      = 0x65F, /* 1631 */
  EVENT_LTE_EMM_TIMER_EXPIRY                                                     = 0x660, /* 1632 */
  EVENT_LTE_REG_INCOMING_MSG                                                     = 0x661, /* 1633 */
  EVENT_LTE_REG_OUTGOING_MSG                                                     = 0x662, /* 1634 */
  EVENT_LTE_ESM_INCOMING_MSG                                                     = 0x663, /* 1635 */
  EVENT_LTE_ESM_OUTGOING_MSG                                                     = 0x664, /* 1636 */
  EVENT_LTE_ESM_TIMER_START                                                      = 0x665, /* 1637 */
  EVENT_LTE_ESM_TIMER_EXPIRY                                                     = 0x666, /* 1638 */
  EVENT_SNS_CONTEXT_OPEN                                                         = 0x667, /* 1639 */
  EVENT_SNS_CONTEXT_CLOSE                                                        = 0x668, /* 1640 */
  EVENT_SNS_COND_SET                                                             = 0x669, /* 1641 */
  EVENT_SNS_COND_CANCEL                                                          = 0x66A, /* 1642 */
  EVENT_SNS_COND_MET                                                             = 0x66B, /* 1643 */
  EVENT_SNS_DATA_START                                                           = 0x66C, /* 1644 */
  EVENT_SNS_DATA_STOP                                                            = 0x66D, /* 1645 */
  EVENT_WCDMA_RLC_CONFIG                                                         = 0x66E, /* 1646 */
  EVENT_HSPA_PLUS_CFG                                                            = 0x66F, /* 1647 */
  EVENT_SNS_DRIVER_STATE_CHANGE                                                  = 0x670, /* 1648 */
  EVENT_WCDMA_TIMER_DISCARD_EXPIRY                                               = 0x671, /* 1649 */
  EVENT_NAS_CB_PAGE_RECEIVED                                                     = 0x672, /* 1650 */
  EVENT_WCDMA_RLC_RESET                                                          = 0x673, /* 1651 */
  EVENT_HDR_MRLP_EHRPD_PERSONALITY_IS_ACTIVE                                     = 0x674, /* 1652 */
  EVENT_WLAN_SECURITY                                                            = 0x675, /* 1653 */
  EVENT_WLAN_STATUS                                                              = 0x676, /* 1654 */
  EVENT_WLAN_HANDOFF                                                             = 0x677, /* 1655 */
  EVENT_WLAN_VCC                                                                 = 0x678, /* 1656 */
  EVENT_WLAN_QOS                                                                 = 0x679, /* 1657 */
  EVENT_WLAN_PE                                                                  = 0x67A, /* 1658 */
  EVENT_WLAN_ADD_BLOCK_ACK_SUCCESS                                               = 0x67B, /* 1659 */
  EVENT_WLAN_ADD_BLOCK_ACK_FAILED                                                = 0x67C, /* 1660 */
  EVENT_WLAN_DELETE_BLOCK_ACK_SUCCESS                                            = 0x67D, /* 1661 */
  EVENT_WLAN_DELETE_BLOCK_ACK_FAILED                                             = 0x67E, /* 1662 */
  EVENT_WLAN_BSS_PROTECTION                                                      = 0x67F, /* 1663 */
  EVENT_WLAN_BRINGUP_STATUS                                                      = 0x680, /* 1664 */
  EVENT_WLAN_POWERSAVE_GENERIC                                                   = 0x681, /* 1665 */
  EVENT_WLAN_POWERSAVE_WOW                                                       = 0x682, /* 1666 */
  EVENT_WLAN_WCM                                                                 = 0x683, /* 1667 */
  EVENT_WLAN_WPS_SCAN_START                                                      = 0x684, /* 1668 */
  EVENT_WLAN_WPS_SCAN_COMPLETE                                                   = 0x685, /* 1669 */
  EVENT_WLAN_WPS_CONNECT_REQUEST                                                 = 0x686, /* 1670 */
  EVENT_WLAN_WPS_CONNECT_RESPONSE                                                = 0x687, /* 1671 */
  EVENT_WLAN_WPS_PBC_SESSION_OVERLAP                                             = 0x688, /* 1672 */
  EVENT_WLAN_WPS_PBC_WALK_TIMER_START                                            = 0x689, /* 1673 */
  EVENT_WLAN_WPS_PBC_WALK_TIMER_STOP                                             = 0x68A, /* 1674 */
  EVENT_WLAN_WPS_PBC_AP_DETECTED                                                 = 0x68B, /* 1675 */
  EVENT_WLAN_WPS_REGISTRATION_START                                              = 0x68C, /* 1676 */
  EVENT_WLAN_WPS_WSC_MESSAGE                                                     = 0x68D, /* 1677 */
  EVENT_WLAN_WPS_DISCOVERY                                                       = 0x68E, /* 1678 */
  EVENT_WLAN_WPS_REGISTRATION_COMPLETE                                           = 0x68F, /* 1679 */
  EVENT_WLAN_WPS_DISCONNECT                                                      = 0x690, /* 1680 */
  EVENT_WLAN_BTC                                                                 = 0x691, /* 1681 */
  EVENT_IPV6_SM_EVENT                                                            = 0x692, /* 1682 */
  EVENT_IPV6_SM_TRANSITION                                                       = 0x693, /* 1683 */
  EVENT_IPV6_PREFIX_UPDATE                                                       = 0x694, /* 1684 */
  EVENT_LTE_ML1_STATE_CHANGE                                                     = 0x695, /* 1685 */
  EVENT_AUTH_PROTO                                                               = 0x696, /* 1686 */
  EVENT_VSNCP                                                                    = 0x697, /* 1687 */
  EVENT_IID                                                                      = 0x698, /* 1688 */
  EVENT_IMS_VIDEOSHARE_REGISTRATION_SUCCESS                                      = 0x699, /* 1689 */
  EVENT_IMS_VIDEOSHARE_INVITE_SENT                                               = 0x69A, /* 1690 */
  EVENT_IMS_VIDEOSHARE_INCOMING_INVITE                                           = 0x69B, /* 1691 */
  EVENT_IMS_VIDEOSHARE_ACCEPT_REJECT_INVITE                                      = 0x69C, /* 1692 */
  EVENT_IMS_VIDEOSHARE_ACCEPTING_SESSION                                         = 0x69D, /* 1693 */
  EVENT_IMS_VIDEOSHARE_SESSION_ESTABLISHED                                       = 0x69E, /* 1694 */
  EVENT_IMS_VIDEOSHARE_END_SESSION                                               = 0x69F, /* 1695 */
  EVENT_IMS_VIDEOSHARE_PREVIEW_VIDEO_FRAME                                       = 0x6A0, /* 1696 */
  EVENT_IMS_VIDEOSHARE_DECODED_VIDEO_FRAME                                       = 0x6A1, /* 1697 */
  EVENT_IMS_VIDEOSHARE_RECEIVING                                                 = 0x6A2, /* 1698 */
  EVENT_IMS_VIDEOSHARE_START_APPLICATION                                         = 0x6A3, /* 1699 */
  EVENT_IMS_VIDEOSHARE_END_APPLICATION                                           = 0x6A4, /* 1700 */
  EVENT_IMS_VIDEOSHARE_CAPABILITY_SUCCESS                                        = 0x6A5, /* 1701 */
  EVENT_IMS_VIDEOSHARE_MEDIA_RECORDING_RESOURCE_ACQUIRED                         = 0x6A6, /* 1702 */
  EVENT_IMS_VIDEOSHARE_MEDIA_RECORDING_RESOURCE_RELEASED                         = 0x6A7, /* 1703 */
  EVENT_IMS_VIDEOSHARE_SENDING                                                   = 0x6A8, /* 1704 */
  EVENT_IMS_VIDEOSHARE_INCOMING_OPTION_RECEIVED                                  = 0x6A9, /* 1705 */
  EVENT_IMS_VIDEOSHARE_INCOMING_OPTION_RESPONDED                                 = 0x6AA, /* 1706 */
  EVENT_IMS_VIDEOSHARE_ERR_CALL_FAILED                                           = 0x6AB, /* 1707 */
  EVENT_IMS_VIDEOSHARE_ERR_REGISTRATION_FAILED                                   = 0x6AC, /* 1708 */
  EVENT_IMS_VIDEOSHARE_ERR_RECORDER_ERROR                                        = 0x6AD, /* 1709 */
  EVENT_IMS_VIDEOSHARE_ERR_PLAYER_ERROR                                          = 0x6AE, /* 1710 */
  EVENT_IMS_VIDEOSHARE_ERR_MEDIA_SESSION_FAILURE                                 = 0x6AF, /* 1711 */
  EVENT_IMS_VIDEOSHARE_ERR_CAPABILITY_FAILURE                                    = 0x6B0, /* 1712 */
  EVENT_IMS_VIDEOSHARE_ERR_MEDIA_RECORDING_FAILED                                = 0x6B1, /* 1713 */
  EVENT_WLAN_PE_FRAME                                                            = 0x6B2, /* 1714 */
  EVENT_SNS_VCPS_HEADING_COMPUTED                                                = 0x6B3, /* 1715 */
  EVENT_SNS_VCPS_TRACKED_CAL_SET_SAVED                                           = 0x6B4, /* 1716 */
  EVENT_GNSS_PRESC_DWELL_COMPLETE                                                = 0x6B5, /* 1717 */
  EVENT_LTE_MAC_RESET                                                            = 0x6B6, /* 1718 */
  EVENT_LTE_BSR_SR_REQUEST                                                       = 0x6B7, /* 1719 */
  EVENT_LTE_MAC_TIMER                                                            = 0x6B8, /* 1720 */
  EVENT_CM_DS_OPERATIONAL_MODE                                                   = 0x6B9, /* 1721 */
  EVENT_CM_DS_MODE_PREF                                                          = 0x6BA, /* 1722 */
  EVENT_CM_DS_GW_ACQ_ORDER_PREF                                                  = 0x6BB, /* 1723 */
  EVENT_CM_DS_SRV_DOMAIN_PREF                                                    = 0x6BC, /* 1724 */
  EVENT_CM_DS_BAND_PREF                                                          = 0x6BD, /* 1725 */
  EVENT_CM_DS_ROAM_PREF                                                          = 0x6BE, /* 1726 */
  EVENT_CM_DS_HYBRID_PREF                                                        = 0x6BF, /* 1727 */
  EVENT_CM_DS_NETWORK_SEL_MODE_PREF                                              = 0x6C0, /* 1728 */
  EVENT_CM_DS_CALL_EVENT_ORIG                                                    = 0x6C1, /* 1729 */
  EVENT_CM_DS_CALL_EVENT_CONNECT                                                 = 0x6C2, /* 1730 */
  EVENT_CM_DS_CALL_EVENT_END                                                     = 0x6C3, /* 1731 */
  EVENT_CM_DS_ENTER_EMERGENCY_CB                                                 = 0x6C4, /* 1732 */
  EVENT_CM_DS_EXIT_EMERGENCY_CB                                                  = 0x6C5, /* 1733 */
  EVENT_CM_DS_CALL_STATE                                                         = 0x6C6, /* 1734 */
  EVENT_CM_DS_DS_INTERRAT_STATE                                                  = 0x6C7, /* 1735 */
  EVENT_CM_DS_CELL_SRV_IND                                                       = 0x6C8, /* 1736 */
  EVENT_CM_DS_COUNTRY_SELECTED                                                   = 0x6C9, /* 1737 */
  EVENT_CM_DS_DATA_AVAILABLE                                                     = 0x6CA, /* 1738 */
  EVENT_CM_DS_SELECT_COUNTRY                                                     = 0x6CB, /* 1739 */
  EVENT_CM_DS_CALL_EVENT_ORIG_THR                                                = 0x6CC, /* 1740 */
  EVENT_CM_DS_PLMN_FOUND                                                         = 0x6CD, /* 1741 */
  EVENT_CM_DS_SERVICE_CONFIRMED                                                  = 0x6CE, /* 1742 */
  EVENT_CM_DS_GET_PASSWORD_IND                                                   = 0x6CF, /* 1743 */
  EVENT_CM_DS_PASSWORD_AUTHENTICATION_STATUS                                     = 0x6D0, /* 1744 */
  EVENT_CM_DS_USS_RESPONSE_NOTIFY_IND                                            = 0x6D1, /* 1745 */
  EVENT_CM_DS_LCS_MOLR_CONF                                                      = 0x6D2, /* 1746 */
  EVENT_DS_NAS_MESSAGE_SENT                                                      = 0x6D3, /* 1747 */
  EVENT_DS_NAS_MESSAGE_RECEIVED                                                  = 0x6D4, /* 1748 */
  EVENT_DS_MM_STATE                                                              = 0x6D5, /* 1749 */
  EVENT_DS_GMM_STATE                                                             = 0x6D6, /* 1750 */
  EVENT_DS_PLMN_INFORMATION                                                      = 0x6D7, /* 1751 */
  EVENT_DIAG_STRESS_TEST_COMPLETED                                               = 0x6D8, /* 1752 */
  EVENT_GNSS_CC_STATUS                                                           = 0x6D9, /* 1753 */
  EVENT_SNS_USER_STATE_CHANGE                                                    = 0x6DA, /* 1754 */
  EVENT_DS_HPLMN_TIMER_EXPIRED                                                   = 0x6DB, /* 1755 */
  EVENT_DS_RAT_CHANGE                                                            = 0x6DC, /* 1756 */
  EVENT_DTV_CMMB_API_CALL_ACTIVATE                                               = 0x6DD, /* 1757 */
  EVENT_DTV_CMMB_API_CALL_DEACTIVATE                                             = 0x6DE, /* 1758 */
  EVENT_DTV_CMMB_API_CALL_TUNE                                                   = 0x6DF, /* 1759 */
  EVENT_DTV_CMMB_API_CALL_SELECT_SERVICE                                         = 0x6E0, /* 1760 */
  EVENT_DTV_CMMB_API_CALL_DESELECT_SERVICE                                       = 0x6E1, /* 1761 */
  EVENT_DTV_CMMB_API_CALL_GET_SIGNAL_PARAMETERS                                  = 0x6E2, /* 1762 */
  EVENT_DTV_CMMB_API_CALL_GET_NIT                                                = 0x6E3, /* 1763 */
  EVENT_DTV_CMMB_API_CALL_GET_CMCT                                               = 0x6E4, /* 1764 */
  EVENT_DTV_CMMB_API_CALL_GET_SMCT                                               = 0x6E5, /* 1765 */
  EVENT_DTV_CMMB_API_CALL_GET_CSCT                                               = 0x6E6, /* 1766 */
  EVENT_DTV_CMMB_API_CALL_GET_SSCT                                               = 0x6E7, /* 1767 */
  EVENT_DTV_CMMB_API_CALL_GET_EADT                                               = 0x6E8, /* 1768 */
  EVENT_DTV_CMMB_API_CALL_REQUEST_CA_CARD_NUMBER                                 = 0x6E9, /* 1769 */
  EVENT_DTV_CMMB_API_CALL_REQUEST_CAS_ID                                         = 0x6EA, /* 1770 */
  EVENT_DTV_CMMB_API_CALL_REGISTER_FOR_CONTROL_NOTIFICATIONS                     = 0x6EB, /* 1771 */
  EVENT_DTV_CMMB_API_CALL_DEREGISTER_FROM_CONTROL_NOTIFICATIONS                  = 0x6EC, /* 1772 */
  EVENT_DTV_CMMB_API_NOTIFICATION_ACTIVATE                                       = 0x6ED, /* 1773 */
  EVENT_DTV_CMMB_API_NOTIFICATION_DEACTIVATE                                     = 0x6EE, /* 1774 */
  EVENT_DTV_CMMB_API_NOTIFICATION_TUNE                                           = 0x6EF, /* 1775 */
  EVENT_DTV_CMMB_API_NOTIFICATION_SELECT_SERVICE                                 = 0x6F0, /* 1776 */
  EVENT_DTV_CMMB_API_NOTIFICATION_DESELECT_SERVICE                               = 0x6F1, /* 1777 */
  EVENT_DTV_CMMB_API_NOTIFICATION_TABLE_UPDATE                                   = 0x6F2, /* 1778 */
  EVENT_DTV_CMMB_API_NOTIFICATION_SIGNAL_PARAMETERS                              = 0x6F3, /* 1779 */
  EVENT_DTV_CMMB_API_NOTIFICATION_AUTHORIZATION_FAILURE                          = 0x6F4, /* 1780 */
  EVENT_DTV_CMMB_API_NOTIFICATION_REGISTER_FOR_CONTROL_NOTIFICATIONS_COMPLETE    = 0x6F5, /* 1781 */
  EVENT_DTV_CMMB_API_NOTIFICATION_DEREGISTER_FROM_CONTROL_NOTIFICATIONS_COMPLETE = 0x6F6, /* 1782 */
  EVENT_DTV_CMMB_API_NOTIFICATION_CA_CARD_NUMBER                                 = 0x6F7, /* 1783 */
  EVENT_DTV_CMMB_API_NOTIFICATION_CAS_ID                                         = 0x6F8, /* 1784 */
  EVENT_DTV_CMMB_API_NOTIFICATION_EMERGENCY_BROADCASTING_TRIGGER                 = 0x6F9, /* 1785 */
  EVENT_DTV_CMMB_API_NOTIFICATION_EMERGENCY_BROADCASTING_MESSAGE                 = 0x6FA, /* 1786 */
  EVENT_DTV_CMMB_API_CALL_REGISTER_FOR_ESG_NOTIFICATIONS                         = 0x6FB, /* 1787 */
  EVENT_DTV_CMMB_API_CALL_DEREGISTER_FROM_ESG_NOTIFICATIONS                      = 0x6FC, /* 1788 */
  EVENT_DTV_CMMB_API_CALL_GET_BASIC_DESCRIPTION_INFORMATION                      = 0x6FD, /* 1789 */
  EVENT_DTV_CMMB_API_CALL_SET_OUTPUT_PATH                                        = 0x6FE, /* 1790 */
  EVENT_DTV_CMMB_API_NOTIFICATION_ESG_DATA_INFORMATION                           = 0x6FF, /* 1791 */
  EVENT_DTV_CMMB_API_NOTIFICATION_ESG_DATA_INFORMATION_DOWNLOAD_COMPLETE         = 0x700, /* 1792 */
  EVENT_DTV_CMMB_API_NOTIFICATION_ESG_PROGRAM_INDICATION_INFORMATION             = 0x701, /* 1793 */
  EVENT_DTV_CMMB_API_NOTIFICATION_REGISTER_FOR_ESG_NOTIFICATIONS_COMPLETE        = 0x702, /* 1794 */
  EVENT_DTV_CMMB_API_NOTIFICATION_DEREGISTER_FROM_ESG_NOTIFICATIONS_COMPLETE     = 0x703, /* 1795 */
  EVENT_DTV_CMMB_CAS_INITIALIZED                                                 = 0x704, /* 1796 */
  EVENT_DTV_CMMB_CAS_EMM_RECEIVED_AND_PROCESSED                                  = 0x705, /* 1797 */
  EVENT_DTV_CMMB_CAS_ECM_RECEIVED_AND_PROCESSED                                  = 0x706, /* 1798 */
  EVENT_ECALL_START                                                              = 0x707, /* 1799 */
  EVENT_ECALL_STOP                                                               = 0x708, /* 1800 */
  EVENT_ECALL_SESSION_START                                                      = 0x709, /* 1801 */
  EVENT_ECALL_SESSION_FAILURE                                                    = 0x70A, /* 1802 */
  EVENT_ECALL_SESSION_COMPLETE                                                   = 0x70B, /* 1803 */
  EVENT_ECALL_SESSION_RESET                                                      = 0x70C, /* 1804 */
  EVENT_ECALL_PSAP_MSD_DECODE_SUCCESS                                            = 0x70D, /* 1805 */
  EVENT_ECALL_PSAP_LOST_SYNC                                                     = 0x70E, /* 1806 */
  EVENT_LTE_RRC_IRAT_REDIR_FROM_EUTRAN_START                                     = 0x70F, /* 1807 */
  EVENT_LTE_RRC_IRAT_REDIR_FROM_EUTRAN_END                                       = 0x710, /* 1808 */
  EVENT_GPRS_DS_CELL_CHANGE_ORDER                                                = 0x711, /* 1809 */
  EVENT_GSM_DS_CELL_SELECTION_END                                                = 0x712, /* 1810 */
  EVENT_GSM_DS_L1_STATE                                                          = 0x713, /* 1811 */
  EVENT_GSM_DS_PLMN_LIST_START                                                   = 0x714, /* 1812 */
  EVENT_GSM_DS_PLMN_LIST_END                                                     = 0x715, /* 1813 */
  EVENT_GSM_DS_POWER_SCAN_STATUS                                                 = 0x716, /* 1814 */
  EVENT_GSM_DS_RESELECT_START                                                    = 0x717, /* 1815 */
  EVENT_GSM_DS_RR_IN_SERVICE                                                     = 0x718, /* 1816 */
  EVENT_GSM_DS_RR_OUT_OF_SERVICE                                                 = 0x719, /* 1817 */
  EVENT_GSM_DS_TIMER_EXPIRED                                                     = 0x71A, /* 1818 */
  EVENT_GSM_DS_TO_WCDMA_RESELECT_END                                             = 0x71B, /* 1819 */
  EVENT_CM_DS_SYSTEM_MODE                                                        = 0x71C, /* 1820 */
  EVENT_SD_DS_EVENT_ACTION                                                       = 0x71D, /* 1821 */
  EVENT_SMGMM_DS_REQUEST_SENT                                                    = 0x71E, /* 1822 */
  EVENT_IFACE                                                                    = 0x71F, /* 1823 */
  EVENTS_DS_GSM_L1_ALIGN_VFR                                                     = 0x720, /* 1824 */
  EVENTS_DS_GSM_L1_STATE                                                         = 0x721, /* 1825 */
  EVENTS_DS_GSM_RATSCCH_IN_DTX                                                   = 0x722, /* 1826 */
  EVENTS_DS_GSM_FACCH_IN_DTX                                                     = 0x723, /* 1827 */
  EVENTS_DS_GSM_FACCH_AND_RATSCCH_COLLISION                                      = 0x724, /* 1828 */
  EVENTS_DS_GSM_FACCH_AND_SID_UPDATE_COLLISION                                   = 0x725, /* 1829 */
  EVENTS_DS_GSM_RATSCCH_AND_SID_UPDATE_COLLISION                                 = 0x726, /* 1830 */
  EVENTS_DS_GSM_AMR_STATE_CHANGE                                                 = 0x727, /* 1831 */
  EVENTS_DS_GSM_RATSCCH_CMI_PHASE_CHANGE                                         = 0x728, /* 1832 */
  EVENTS_DS_GSM_RATSCCH_REQ_ACT_TIMER_EXPIRY                                     = 0x729, /* 1833 */
  EVENTS_DS_GSM_RATSCCH_ACK_ACT_TIMER_EXPIRY                                     = 0x72A, /* 1834 */
  EVENTS_DS_GSM_AMR_RATSCCH_REQ                                                  = 0x72B, /* 1835 */
  EVENTS_DS_GSM_AMR_RATSCCH_RSP                                                  = 0x72C, /* 1836 */
  EVENTS_DS_GSM_AMR_CMC_TURNAROUND_TIME                                          = 0x72D, /* 1837 */
  EVENTS_DS_GPRS_SMGMM_MSG_RECEIVED                                              = 0x72E, /* 1838 */
  EVENTS_DS_GPRS_SMGMM_MSG_SENT                                                  = 0x72F, /* 1839 */
  EVENTS_DS_GPRS_LLC_READY_TIMER_START                                           = 0x730, /* 1840 */
  EVENTS_DS_GPRS_LLC_READY_TIMER_END                                             = 0x731, /* 1841 */
  EVENTS_DS_PACKET_TIMESLOT_RECONFIGURE                                          = 0x732, /* 1842 */
  EVENTS_DS_GPRS_MAC_MSG_RECEIVED                                                = 0x733, /* 1843 */
  EVENTS_DS_GPRS_MAC_MSG_SENT                                                    = 0x734, /* 1844 */
  EVENTS_DS_GPRS_MAC_CAMPED_ON_CELL                                              = 0x735, /* 1845 */
  EVENTS_DS_GPRS_CELL_CHANGE_FAILURE                                             = 0x736, /* 1846 */
  EVENTS_DS_GPRS_PACKET_CHANNEL_REQUEST                                          = 0x737, /* 1847 */
  EVENTS_DS_GPRS_PACKET_UPLINK_ASSIGNMENT                                        = 0x738, /* 1848 */
  EVENTS_DS_GPRS_PACKET_DOWNLINK_ASSIGNMENT                                      = 0x739, /* 1849 */
  EVENTS_DS_GPRS_TBF_RELEASE                                                     = 0x73A, /* 1850 */
  EVENTS_DS_GPRS_TIMER_EXPIRY                                                    = 0x73B, /* 1851 */
  EVENTS_DS_GPRS_PACKET_RESOURCE_REQUEST                                         = 0x73C, /* 1852 */
  EVENTS_DS_RANDOM_ACCESS_REQUEST                                                = 0x73D, /* 1853 */
  EVENTS_DS_GSM_HANDOVER_START                                                   = 0x73E, /* 1854 */
  EVENTS_DS_GSM_HANDOVER_END                                                     = 0x73F, /* 1855 */
  EVENTS_DS_GSM_RESELECT_START                                                   = 0x740, /* 1856 */
  EVENTS_DS_GSM_RESELECT_END                                                     = 0x741, /* 1857 */
  EVENTS_DS_GSM_TO_WCDMA_RESELECT_END                                            = 0x742, /* 1858 */
  EVENTS_DS_GSM_MESSAGE_RECEIVED                                                 = 0x743, /* 1859 */
  EVENTS_DS_GSM_RR_IN_SERVICE                                                    = 0x744, /* 1860 */
  EVENTS_DS_GSM_RR_OUT_OF_SERVICE                                                = 0x745, /* 1861 */
  EVENTS_DS_GSM_PAGE_RECEIVED                                                    = 0x746, /* 1862 */
  EVENTS_DS_GSM_CAMP_ATTEMPT_START                                               = 0x747, /* 1863 */
  EVENTS_DS_GSM_CAMP_ATTEMPT_END                                                 = 0x748, /* 1864 */
  EVENTS_DS_GSM_CALL_DROP                                                        = 0x749, /* 1865 */
  EVENTS_DS_GSM_ACCESS_FAILURE                                                   = 0x74A, /* 1866 */
  EVENTS_DS_GSM_CELL_SELECTION_START                                             = 0x74B, /* 1867 */
  EVENTS_DS_GSM_CELL_SELECTION_END                                               = 0x74C, /* 1868 */
  EVENTS_DS_GSM_POWER_SCAN_STATUS                                                = 0x74D, /* 1869 */
  EVENTS_DS_GSM_PLMN_LIST_START                                                  = 0x74E, /* 1870 */
  EVENTS_DS_GSM_PLMN_LIST_END                                                    = 0x74F, /* 1871 */
  EVENTS_DS_GSM_AMR_MULTIRATE_IE                                                 = 0x750, /* 1872 */
  EVENTS_DS_GPRS_LINK_FAILURE                                                    = 0x751, /* 1873 */
  EVENTS_DS_GPRS_PAGE_RECEIVED                                                   = 0x752, /* 1874 */
  EVENTS_DS_GPRS_SURROUND_SEARCH_START                                           = 0x753, /* 1875 */
  EVENTS_DS_GPRS_SURROUND_SEARCH_END                                             = 0x754, /* 1876 */
  EVENTS_DS_GPRS_EARLY_CAMPING                                                   = 0x755, /* 1877 */
  EVENTS_DS_GSM_LINK_FAILURE                                                     = 0x756, /* 1878 */
  EVENT_MTP_FILE_DELETED                                                         = 0x757, /* 1879 */
  EVENT_MTP_PLAYLIST_REMOVED_OBJECT                                              = 0x758, /* 1880 */
  EVENT_MTP_SYNC_STARTED                                                         = 0x759, /* 1881 */
  EVENT_MTP_SYNC_FINISHED                                                        = 0x75A, /* 1882 */
  EVENT_MTP_SAVE_ALBUMART_STARTED                                                = 0x75B, /* 1883 */
  EVENT_MTP_SAVE_ALBUMART_FINISHED                                               = 0x75C, /* 1884 */
  EVENT_MTP_FORMAT_STORE_STARTED                                                 = 0x75D, /* 1885 */
  EVENT_MTP_FORMAT_STORE_DONE                                                    = 0x75E, /* 1886 */
  EVENT_MTP_FORMAT_STORE_ERROR                                                   = 0x75F, /* 1887 */
  EVENT_LTE_RRC_SECURITY_CONFIG                                                  = 0x760, /* 1888 */
  EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_START                                     = 0x761, /* 1889 */
  EVENT_LTE_RRC_IRAT_RESEL_FROM_EUTRAN_END                                       = 0x762, /* 1890 */
  EVENT_SNS_REST_DETECT_ACCEL_ACTIVE_TS                                          = 0x763, /* 1891 */
  EVENT_SNS_REST_DETECT_ACCEL_STOP_TS                                            = 0x764, /* 1892 */
  EVENT_CPC_CONFIG_ACTION                                                        = 0x765, /* 1893 */
  EVENT_FDPCH_CONFIG_ACTION                                                      = 0x766, /* 1894 */
  EVENT_SNS_DRV_MOTION_DETECT_SIG                                                = 0x767, /* 1895 */
  EVENT_SNS_DRV_OPMODE_CHANGE                                                    = 0x768, /* 1896 */
  EVENT_PM_BATT_CONNECT                                                          = 0x769, /* 1897 */
  EVENT_PM_BATT_DISCONNECT                                                       = 0x76A, /* 1898 */
  EVENT_PM_BATT_TEMP_OUT_OF_RANGE                                                = 0x76B, /* 1899 */
  EVENT_PM_CHARGE_STATE_CHANGED                                                  = 0x76C, /* 1900 */
  EVENT_PM_CHARGE_DONE                                                           = 0x76D, /* 1901 */
  EVENT_PM_CHARGE_FAIL                                                           = 0x76E, /* 1902 */
  EVENT_PM_VBAT_DET                                                              = 0x76F, /* 1903 */
  EVENT_PM_AUTO_CHARGING_EOC_ITERM_SW_TIMER                                      = 0x770, /* 1904 */
  EVENT_PM_AUTO_CHARGING_EOC_DETECTION_SW_TIMER                                  = 0x771, /* 1905 */
  EVENT_PM_AUTO_CHARGING_MAX_CHARGE_SW_TIMER                                     = 0x772, /* 1906 */
  EVENT_PM_AUTO_CHARGING_RESUME_CHARGE_DETECTION_TIMER                           = 0x773, /* 1907 */
  EVENT_PM_OVP_TRIGGERED                                                         = 0x774, /* 1908 */
  EVENT_PM_GEN_VERIFY_REGISTER_DEFAULTS                                          = 0x775, /* 1909 */
  EVENT_1X_FPC_MODE                                                              = 0x776, /* 1910 */
  EVENT_1X_FPC_RATCHET                                                           = 0x777, /* 1911 */
  EVENT_1X_FSCH_ASSIGN                                                           = 0x778, /* 1912 */
  EVENT_1X_RSCH_ASSIGN                                                           = 0x779, /* 1913 */
  EVENT_1X_RSCH_REQUEST                                                          = 0x77A, /* 1914 */
  EVENT_1X_ADV_FL_SB_STATUS                                                      = 0x77B, /* 1915 */
  EVENT_1X_ADV_RL_SB_STATUS                                                      = 0x77C, /* 1916 */
  EVENT_1X_ADV_N2M_CHANGE                                                        = 0x77D, /* 1917 */
  EVENT_PM_COMMON_TEST                                                           = 0x77E, /* 1918 */
  EVENT_PM_COMMON_TEST_PAYLOAD                                                   = 0x77F, /* 1919 */
  EVENT_CGPS_PREEMPTION_FLAG                                                     = 0x780, /* 1920 */
  EVENT_CM_LTE_BAND_PREF                                                         = 0x781, /* 1921 */
  EVENT_PS_ARBITRATION                                                           = 0x782, /* 1922 */
  EVENT_SD_AVOIDANCE_LOG                                                         = 0x783, /* 1923 */
  EVENT_HSPAPLUS_DC                                                              = 0x784, /* 1924 */
  EVENT_HS_SCCH_ORDER                                                            = 0x785, /* 1925 */
  EVENT_DSM_POOL_LEVEL                                                           = 0x786, /* 1926 */
  EVENT_GPSONEXTRA_DATA_ACK                                                      = 0x787, /* 1927 */
  EVENT_MCS_MSGR_SEND                                                            = 0x788, /* 1928 */
  EVENT_MCS_MSGR_RECV                                                            = 0x789, /* 1929 */
  EVENT_WCDMA_TO_LTE_RESELECTION_START                                           = 0x78A, /* 1930 */
  EVENT_WCDMA_TO_LTE_RESELECTION_END                                             = 0x78B, /* 1931 */
  EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_START                                    = 0x78C, /* 1932 */
  EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_STOP                                     = 0x78D, /* 1933 */
  EVENT_WCDMA_EOOS_SKIP_FULL_SCAN_TIMER_EXPIRED                                  = 0x78E, /* 1934 */
  EVENT_LTE_RRC_CELL_BLACKLIST_IND                                               = 0x78F, /* 1935 */
  EVENT_LTE_RRC_AS_RESET                                                         = 0x790, /* 1936 */
  EVENT_WCDMA_OL_MTD_CONFIG_ACTION                                               = 0x791, /* 1937 */
  EVENT_LTE_ML1_PHR_REPORT                                                       = 0x792, /* 1938 */
  EVENT_SMS_COMMAND_PROCESSED                                                    = 0x793, /* 1939 */
  EVENT_SMS_MT_NOTIFY                                                            = 0x794, /* 1940 */
  EVENT_GPSXTRA_T_CONN_BEGIN                                                     = 0x795, /* 1941 */
  EVENT_GPSXTRA_T_CONN_CONNECT                                                   = 0x796, /* 1942 */
  EVENT_GPSXTRA_T_CONN_DISCONNET                                                 = 0x797, /* 1943 */
  EVENT_GPSXTRA_T_CONN_DONE                                                      = 0x798, /* 1944 */
  EVENT_GPSXTRA_T_CONN_FAILURE                                                   = 0x799, /* 1945 */
  EVENT_GNSS_TLE_SRV_CHANGE_C                                                    = 0x79A, /* 1946 */
  EVENT_GNSS_TLE_CELL_CHANGE_C                                                   = 0x79B, /* 1947 */
  EVENT_GNSS_TLE_POS_UPDATE_C                                                    = 0x79C, /* 1948 */
  EVENT_GNSS_TLE_TIME_TAG_C                                                      = 0x79D, /* 1949 */
  EVENT_GNSS_TLE_DELETE_C                                                        = 0x79E, /* 1950 */
  EVENT_GNSS_TLE_TIME_UPDATE_C                                                   = 0x79F, /* 1951 */
  EVENT_GNSS_TLE_POSITION_REPORT                                                 = 0x7A0, /* 1952 */
  EVENT_WCDMA_TO_LTE_REDIRECTION_START                                           = 0x7A1, /* 1953 */
  EVENT_WCDMA_TO_LTE_REDIRECTION_END                                             = 0x7A2, /* 1954 */
  EVENT_WCDMA_DED_PRIORITIES_VALIDITY_TIMER_START                                = 0x7A3, /* 1955 */
  EVENT_WCDMA_DED_PRIORITIES_VALIDITY_TIMER_EXPIRED                              = 0x7A4, /* 1956 */
  EVENT_LTE_RRC_IRAT_RTT_FROM_EUTRAN_START                                       = 0x7A5, /* 1957 */
  EVENT_LTE_RRC_IRAT_RTT_FROM_EUTRAN_END                                         = 0x7A6, /* 1958 */
  EVENT_WCDMA_RRC_DSIM_TUNEAWAY_START                                            = 0x7A7, /* 1959 */
  EVENT_WCDMA_RRC_DSIM_TUNEAWAY_STOP                                             = 0x7A8, /* 1960 */
  EVENT_SMS_ETWS_PRIM_RECEIVED                                                   = 0x7A9, /* 1961 */
  EVENT_SMS_CBS_MSG_RECEIVED                                                     = 0x7AA, /* 1962 */
  EVENT_LTE_ML1_TX_POWER_BACKOFF                                                 = 0x7AB, /* 1963 */
  EVENT_WCDMA_CELL_EFACH_EPCH_ERACH_SUPPORT                                      = 0x7AC, /* 1964 */
  EVENT_GPSXTRA_T_CONN_TYPE                                                      = 0x7AD, /* 1965 */
  EVENT_LTE_EMM_OTA_INCOMING_MSG                                                 = 0x7AE, /* 1966 */
  EVENT_LTE_EMM_OTA_OUTGOING_MSG                                                 = 0x7AF, /* 1967 */
  EVENT_LTE_ESM_OTA_INCOMING_MSG                                                 = 0x7B0, /* 1968 */
  EVENT_LTE_ESM_OTA_OUTGOING_MSG                                                 = 0x7B1, /* 1969 */
  EVENT_LTE_RRC_PLMN_SEARCH_START                                                = 0x7B2, /* 1970 */
  EVENT_LTE_RRC_PLMN_SEARCH_STOP                                                 = 0x7B3, /* 1971 */
  EVENT_LTE_RRC_BG_TO_FG_PLMN_SEARCH                                             = 0x7B4, /* 1972 */
  EVENT_LTE_RRC_LATE_PLMN_SEARCH_RESPONSE                                        = 0x7B5, /* 1973 */
  EVENT_WCDMA_RRC_CRNTI                                                          = 0x7B6, /* 1974 */
  EVENT_WCDMA_RRC_URNTI                                                          = 0x7B7, /* 1975 */
  EVENT_DS_EPC_PDN                                                               = 0x7B8, /* 1976 */
  EVENT_DS_EPC_SRAT_CLEANUP_TIMER                                                = 0x7B9, /* 1977 */
  EVENT_DS_EPC_EDCT_TIMER                                                        = 0x7BA, /* 1978 */
  EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_STARTED                                   = 0x7BB, /* 1979 */
  EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_COMPLETED                                 = 0x7BC, /* 1980 */
  EVENT_GERAN_GRR_PLMN_LIST_RAT_SEARCH_ABORTED                                   = 0x7BD, /* 1981 */
  EVENT_GERAN_GRR_REDIR_STARTED                                                  = 0x7BE, /* 1982 */
  EVENT_GERAN_GRR_REDIR_COMPLETED                                                = 0x7BF, /* 1983 */
  EVENT_GERAN_GRR_REDIR_ABORTED                                                  = 0x7C0, /* 1984 */
  EVENT_1X_FSCH0_BURST_ASSIGN                                                    = 0x7C1, /* 1985 */
  EVENT_1X_RSCH0_BURST_ASSIGN                                                    = 0x7C2, /* 1986 */
  EVENT_SENSOR_STATE                                                             = 0x7C3, /* 1987 */
  EVENT_SENSOR_TIMELINE                                                          = 0x7C4, /* 1988 */
  EVENT_GSM_TO_LTE_RESEL_STARTED                                                 = 0x7C5, /* 1989 */
  EVENT_GSM_TO_LTE_RESEL_ENDED                                                   = 0x7C6, /* 1990 */
  EVENT_GSM_TO_LTE_REDIR_STARTED                                                 = 0x7C7, /* 1991 */
  EVENT_GSM_TO_LTE_REDIR_ENDED                                                   = 0x7C8, /* 1992 */
  EVENT_SD_SS_TIMER_LOG                                                          = 0x7C9, /* 1993 */
  EVENT_LTE_RRC_STATE_CHANGE_TRIGGER                                             = 0x7CA, /* 1994 */
  EVENT_LTE_RRC_RADIO_LINK_FAILURE_STAT                                          = 0x7CB, /* 1995 */
  EVENT_TDSCDMA_MAC_UL_AMR_RATE                                                  = 0x7CC, /* 1996 */
  EVENT_TDSCDMA_MAC_HS_T1_EXPIRY                                                 = 0x7CD, /* 1997 */
  EVENT_TDSCDMA_RLC_MAX_RESET                                                    = 0x7CE, /* 1998 */
  EVENT_TDSCDMA_RLC_RESETS                                                       = 0x7CF, /* 1999 */
  EVENT_TDSCDMA_RLC_OPEN_CLOSE                                                   = 0x7D0, /* 2000 */
  EVENT_TDSCDMA_RLC_MRW                                                          = 0x7D1, /* 2001 */
  EVENT_TDSCDMA_RLC_CONFIG                                                       = 0x7D2, /* 2002 */
  EVENT_TDSCDMA_RLC_TIMER_DISCARD_EXPIRY                                         = 0x7D3, /* 2003 */
  EVENT_TDSCDMA_RRC_INTER_RAT_HANDOVER_START                                     = 0x7D4, /* 2004 */
  EVENT_TDSCDMA_RRC_INTER_RAT_HANDOVER_END                                       = 0x7D5, /* 2005 */
  EVENT_TDSCDMA_RRC_TDSCDMA_TO_GSM_RESELECTION_START                             = 0x7D6, /* 2006 */
  EVENT_TDSCDMA_RRC_TDSCDMA_TO_GSM_RESELECTION_END                               = 0x7D7, /* 2007 */
  EVENT_TDSCDMA_RRC_CELL_SELECTED                                                = 0x7D8, /* 2008 */
  EVENT_TDSCDMA_RRC_PAGE_RECEIVED                                                = 0x7D9, /* 2009 */
  EVENT_TDSCDMA_RRC_RL_FAILURE                                                   = 0x7DA, /* 2010 */
  EVENT_TDSCDMA_RRC_STATE                                                        = 0x7DB, /* 2011 */
  EVENT_TDSCDMA_RRC_OUT_OF_SERVICE                                               = 0x7DC, /* 2012 */
  EVENT_TDSCDMA_RRC_RB0_SETUP_FAILURE                                            = 0x7DD, /* 2013 */
  EVENT_TDSCDMA_RRC_PHYCHAN_EST_FAILURE                                          = 0x7DE, /* 2014 */
  EVENT_TDSCDMA_RRC_GSM_TO_TDSCDMA_HANDOVER_START                                = 0x7DF, /* 2015 */
  EVENT_TDSCDMA_RRC_MODE                                                         = 0x7E0, /* 2016 */
  EVENT_TDSCDMA_RRC_PHYCHAN_CFG_CHANGED                                          = 0x7E1, /* 2017 */
  EVENT_TDSCDMA_RRC_CONN_REL_CAUSE                                               = 0x7E2, /* 2018 */
  EVENT_TDSCDMA_RRC_CONN_REQ_CAUSE                                               = 0x7E3, /* 2019 */
  EVENT_TDSCDMA_RRC_TIMER_EXPIRED                                                = 0x7E4, /* 2020 */
  EVENT_TDSCDMA_RRC_UOOS_TIMER_USED                                              = 0x7E5, /* 2021 */
  EVENT_TDSCDMA_RRC_UOOS_TIMER_START                                             = 0x7E6, /* 2022 */
  EVENT_TDSCDMA_RRC_UOOS_TIMER_STOP                                              = 0x7E7, /* 2023 */
  EVENT_TDSCDMA_RRC_CSP_SCAN_START                                               = 0x7E8, /* 2024 */
  EVENT_TDSCDMA_RRC_CELL_SELECTION_FAIL                                          = 0x7E9, /* 2025 */
  EVENT_TDSCDMA_RRC_BPLMN_START                                                  = 0x7EA, /* 2026 */
  EVENT_TDSCDMA_RRC_BPLMN_END                                                    = 0x7EB, /* 2027 */
  EVENT_TDSCDMA_RRC_BPLMN_SCAN_START                                             = 0x7EC, /* 2028 */
  EVENT_TDSCDMA_RRC_BPLMN_SCAN_END                                               = 0x7ED, /* 2029 */
  EVENT_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_START                              = 0x7EE, /* 2030 */
  EVENT_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_STOP                               = 0x7EF, /* 2031 */
  EVENT_TDSCDMA_RRC_EOOS_SKIP_FULL_SCAN_TIMER_EXPIRED                            = 0x7F0, /* 2032 */
  EVENT_TDSCDMA_RRC_MESSAGE_SENT                                                 = 0x7F1, /* 2033 */
  EVENT_TDSCDMA_RRC_MESSAGE_RECEIVED                                             = 0x7F2, /* 2034 */
  EVENT_LTE_ML1_UL_SPS_REPORT                                                    = 0x7F8, /* 2040 */
  EVENT_LTE_ML1_DL_SPS_REPORT                                                    = 0x7F9, /* 2041 */
  EVENT_TDSCDMA_RRC_CSP_STATE                                                    = 0x7FA, /* 2042 */
  EVENT_TDSCDMA_RRC_HSDPA_START                                                  = 0x7FB, /* 2043 */
  EVENT_TDSCDMA_RRC_HSDPA_STOP                                                   = 0x7FC, /* 2044 */
  EVENT_TDSCDMA_RRC_HSUPA_START                                                  = 0x7FD, /* 2045 */
  EVENT_TDSCDMA_RRC_HSUPA_STOP                                                   = 0x7FE, /* 2046 */
  EVENT_TDSCDMA_RRC_SIB_RCVD                                                     = 0x7FF, /* 2047 */
  EVENT_RSVD_START                                                               = 0x800, /* 2048 */ /* reserved range - start */
  EVENT_RSVD_END                                                                 = 0x83F, /* 2111 */ /* reserved range - end */
  EVENT_TDSCDMA_RRC_LLC_SUBSTATE                                                 = 0x840, /* 2112 */
  EVENT_TDSCDMA_RRC_MCM_SUBSTATE                                                 = 0x841, /* 2113 */
  EVENT_TDSCDMA_RRC_CCM_SUBSTATE                                                 = 0x842, /* 2114 */
  EVENT_TDSCDMA_RRC_CU_SUBSTATE                                                  = 0x843, /* 2115 */
  EVENT_TDSCDMA_RRC_NV_RRC_VERSION                                               = 0x844, /* 2116 */
  EVENT_TDSCDMA_RRC_LLC_TOC_USAGE                                                = 0x845, /* 2117 */
  EVENT_TDSCDMA_RRC_LLC_OC_STATUS                                                = 0x846, /* 2118 */
  EVENT_TDSCDMA_RRC_OOS_TRIGGERED                                                = 0x847, /* 2119 */
  EVENT_WCDMA_RRC_RELEASE_CAUSE                                                  = 0x848, /* 2120 */
  EVENT_WCDMA_RRC_REJECT_CAUSE                                                   = 0x849, /* 2121 */
  EVENT_DS_MO_SMS_STATUS                                                         = 0x84A, /* 2122 */
  EVENT_DS_MO_SMS_RETRY_ATTEMPT                                                  = 0x84B, /* 2123 */
  EVENT_DS_MT_SMS_NOTIFY                                                         = 0x84C, /* 2124 */
  EVENT_DS_WMS_SEARCH_REQUEST                                                    = 0x84D, /* 2125 */
  EVENT_DS_SMS_COMMAND_PROCESSED                                                 = 0x84E, /* 2126 */
  EVENT_DS_SMS_MT_NOTIFY                                                         = 0x84F, /* 2127 */
  EVENT_DS_SMS_CBS_MSG_RECEIVED                                                  = 0x850, /* 2128 */
  EVENT_DS_SMS_ETWS_PRIM_RECEIVED                                                = 0x851, /* 2129 */
  EVENT_TDSCDMA_RRC_ACQUISITION_COMPLETE                                         = 0x852, /* 2130 */
  EVENT_TDSCDMA_L1_STATE                                                         = 0x853, /* 2131 */
  EVENT_TDSCDMA_NEW_SERVING_CELL                                                 = 0x854, /* 2132 */
  EVENT_TDSCDMA_L1_SUSPEND                                                       = 0x855, /* 2133 */
  EVENT_TDSCDMA_L1_RESUME                                                        = 0x856, /* 2134 */
  EVENT_TDSCDMA_L1_STOPPED                                                       = 0x857, /* 2135 */
  EVENT_TDSCDMA_L1_ACQ_SUBSTATE                                                  = 0x858, /* 2136 */
  EVENT_TDSCDMA_PHYCHAN_CFG_CHANGED                                              = 0x859, /* 2137 */
  EVENT_TDSCDMA_RACH_STATUS                                                      = 0x85A, /* 2138 */
  EVENT_TDSCDMA_MEASUREMENT_EVENT                                                = 0x85B, /* 2139 */
  EVENT_GNSS_FAST_TCAL_END                                                       = 0x85C, /* 2140 */
  EVENT_IMS_CODEC_INITIALIZATION                                                 = 0x85D, /* 2141 */
  EVENT_IMS_CODEC_RATE_CHANGE_EVENT                                              = 0x85E, /* 2142 */
  EVENT_T_HDR_CSNA_DUP_3G1X_SRV_MSG                                              = 0x85F, /* 2143 */
  EVENT_T_HDR_IDLE_CONNECT_REASON                                                = 0x860, /* 2144 */
  EVENT_T_HDR_IDLE_CONNECTION_DENIED_REASON                                      = 0x861, /* 2145 */
  EVENT_T_HDR_IDLE_CONNECTION_SETUP_FAIL_REASON                                  = 0x862, /* 2146 */
  EVENT_T_HDR_OVHD_PRE_REG_IS_ALLOWED                                            = 0x863, /* 2147 */
  EVENT_T_HDR_SAP_TUNNEL_IS_ENABLED                                              = 0x864, /* 2148 */
  EVENT_T_HDR_SAP_CONNECTION_IS_OPEN                                             = 0x865, /* 2149 */
  EVENT_T_HDR_ALMP_LTE_RESELECT                                                  = 0x866, /* 2150 */
  EVENT_T_HDR_OVHD_ORNL_IS_UPDATED                                               = 0x867, /* 2151 */
  EVENT_T_HDR_LTE_RESEL_STATUS                                                   = 0x868, /* 2152 */
  EVENT_LTE_TO_1X_TT                                                             = 0x869, /* 2153 */
  EVENT_LTE_TO_1X_HO                                                             = 0x86A, /* 2154 */
  EVENT_LTE_TO_1X_DL_GCSNA_MSG                                                   = 0x86B, /* 2155 */
  EVENT_LTE_TO_1X_UL_GCSNA_MSG                                                   = 0x86C, /* 2156 */
  EVENT_LTE_RRC_UL_MSG_MEAS_REPORT                                               = 0x86D, /* 2157 */
  EVENT_IMS_QIPCALL_SIP_SESSION_EVENT                                            = 0x86E, /* 2158 */
  EVENT_SIP_REG_START_EVENT                                                      = 0x86F, /* 2159 */
  EVENT_SIP_REG_REQ_SENT_EVENT                                                   = 0x870, /* 2160 */
  EVENT_SIP_REG_RESP_RCVD_EVENT                                                  = 0x871, /* 2161 */
  EVENT_SIP_REG_END_EVENT                                                        = 0x872, /* 2162 */
  EVENT_SIP_REG_DREG_START_EVENT                                                 = 0x873, /* 2163 */
  EVENT_SIP_REG_DREG_END_EVENT                                                   = 0x874, /* 2164 */
  EVENT_WCDMA_FACH_DRX_ACTION                                                    = 0x875, /* 2165 */
  EVENT_RRC_COMPLETE_SIB_RECEIVED                                                = 0x876, /* 2166 */
  EVENT_1X_TO_LTE_RESEL_DONE                                                     = 0x877, /* 2167 */
  EVENT_SSR_SUBSYS_PWR_DOWN                                                      = 0x878, /* 2168 */
  EVENT_SSR_SUBSYS_PWR_UP                                                        = 0x879, /* 2169 */
  EVENT_DS_DSD_PREFERRED_RADIO                                                   = 0x87A, /* 2170 */
  EVENT_DS_DSD_TIMER_STARTED                                                     = 0x87B, /* 2171 */
  EVENT_DS_DSD_TIMER_STOPPED                                                     = 0x87C, /* 2172 */
  EVENT_DS_DSD_TIMER_EXPIRED                                                     = 0x87D, /* 2173 */
  EVENT_DS_DSD_RADIO_THROTTLE                                                    = 0x87E, /* 2174 */
  EVENT_DS_DSD_RADIO_UNTHROTTLE                                                  = 0x87F, /* 2175 */
  EVENT_TDSCDMA_TO_TDSCDMA_RESELECTION_START                                     = 0x880, /* 2176 */
  EVENT_TDSCDMA_TO_TDSCDMA_RESELECTION_END                                       = 0x881, /* 2177 */
  EVENT_GSM_CS_CALL_ESTABLISHMENT_FAILURE                                        = 0x882, /* 2178 */
  EVENT_GSM_CS_CALL_DROPPED                                                      = 0x883, /* 2179 */
  EVENT_GSM_LOST_SERVICE                                                         = 0x884, /* 2180 */
  EVENT_GSM_IN_SERVICE                                                           = 0x885, /* 2181 */
  EVENT_GSM_PLMN_LIST_GSM_SUB_SEARCH_ENDED                                       = 0x886, /* 2182 */
  EVENT_SD_WRLF_2MIN_TIMER_EXPIRY                                                = 0x887, /* 2183 */
  EVENT_CM_RLF_RECOVERY_START                                                    = 0x888, /* 2184 */
  EVENT_CM_RLF_RECOVERY_END                                                      = 0x889, /* 2185 */
  EVENT_T_HDR_CONN_ATTEMPT_ENDED                                                 = 0x88A, /* 2186 */
  EVENT_T_HDR_CONN_TERMINATED                                                    = 0x88B, /* 2187 */
  EVENT_MM_TIMER_EXPIRY                                                          = 0x88C, /* 2188 */
  EVENT_GNSS_RESET_LOCATION_SERVICE_RECEIVED                                     = 0x88D, /* 2189 */
  EVENT_GNSS_RESET_LOCATION_SERVICE_DONE                                         = 0x88E, /* 2190 */
  EVENT_TDSCDMA_HANDOVER_START                                                   = 0x88F, /* 2191 */
  EVENT_TDSCDMA_HANDOVER_END                                                     = 0x890, /* 2192 */
  EVENT_TDSCDMA_TS0_JDS_UPDATE                                                   = 0x891, /* 2193 */
  EVENT_TDSCDMA_NONTS0_JDS_UPDATE                                                = 0x892, /* 2194 */
  EVENT_TDSCDMA_UE_PAGED                                                         = 0x893, /* 2195 */
  EVENT_TDSCDMA_DRX_REACQ                                                        = 0x894, /* 2196 */
  EVENT_TDSCDMA_DL_SYNC_STATUS                                                   = 0x895, /* 2197 */
  EVENT_TDSCDMA_HSDPA_STATUS                                                     = 0x896, /* 2198 */
  EVENT_TDSCDMA_HSUPA_STATUS                                                     = 0x897, /* 2199 */
  EVENT_GHDI_MVS_STATE                                                           = 0x898, /* 2200 */
  EVENT_LTE_RRC_CELL_RESEL_STARTED                                               = 0x899, /* 2201 */
  EVENT_WCDMA_CM_STATE_CHANGE                                                    = 0x89A, /* 2202 */
  EVENT_TDSCDMA_TO_LTE_RESELECTION_START                                         = 0x89B, /* 2203 */
  EVENT_TDSCDMA_TO_LTE_RESELECTION_END                                           = 0x89C, /* 2204 */
  EVENT_TDSCDMA_TO_LTE_REDIRECTION_START                                         = 0x89D, /* 2205 */
  EVENT_TDSCDMA_TO_LTE_REDIRECTION_END                                           = 0x89E, /* 2206 */
  EVENT_TDSCDMA_DED_PRIORITIES_VALIDITY_TIMER_START                              = 0x89F, /* 2207 */
  EVENT_TDSCDMA_DED_PRIORITIES_VALIDITY_TIMER_EXPIRED                            = 0x8A0, /* 2208 */
  EVENT_LTE_RRC_IRAT_CCO_FROM_EUTRAN_START                                       = 0x8A1, /* 2209 */
  EVENT_LTE_RRC_IRAT_CCO_FROM_EUTRAN_END                                         = 0x8A2, /* 2210 */
  EVENT_HOCM_TRANSMITTED                                                         = 0x8A3, /* 2211 */
  EVENT_RESERVED_000                                                             = 0x8A4, /* 2212 */
  EVENT_RESERVED_001                                                             = 0x8A5, /* 2213 */
  EVENT_RESERVED_002                                                             = 0x8A6, /* 2214 */
  EVENT_RESERVED_003                                                             = 0x8A7, /* 2215 */
  EVENT_RESERVED_004                                                             = 0x8A8, /* 2216 */
  EVENT_RESERVED_005                                                             = 0x8A9, /* 2217 */
  EVENT_RESERVED_006                                                             = 0x8AA, /* 2218 */
  EVENT_RESERVED_007                                                             = 0x8AB, /* 2219 */
  EVENT_RESERVED_008                                                             = 0x8AC, /* 2220 */
  EVENT_RESERVED_009                                                             = 0x8AD, /* 2221 */
  EVENT_DS_DSD_ATTACH_PDN_CHANGE                                                 = 0x8AE, /* 2222 */
  EVENT_TDSCDMA_INTER_RAT_PFR_START                                              = 0x8AF, /* 2223 */
  EVENT_TDSCDMA_INTER_RAT_PFR_END                                                = 0x8B0, /* 2224 */
  EVENT_TDSCDMA_RRC_INTER_RAT_CCO_START                                          = 0x8B1, /* 2225 */
  EVENT_WCDMA_RRC_CSFB_SIB_CONTAINER                                             = 0x8B2, /* 2226 */
  EVENT_LTE_RRC_EMBMS_OOS_WARN_IND                                               = 0x8B3, /* 2227 */
  EVENT_LTE_RRC_EMBMS_ACT_TMGI_LIST_IND                                          = 0x8B4, /* 2228 */
  EVENT_LTE_RRC_EMBMS_AVAIL_TMGI_LIST_IND                                        = 0x8B5, /* 2229 */
  EVENT_LTE_RRC_MCCH_CHANGE_NOTIFICATION                                         = 0x8B6, /* 2230 */
  EVENT_RPM_MCC_MNC_VALUE                                                        = 0x8B7, /* 2231 */
  EVENT_RPM_ENABLED                                                              = 0x8B8, /* 2232 */
  EVENT_CPDP_COUNTERS_UPDATE                                                     = 0x8B9, /* 2233 */
  EVENT_RPM_START_LR3_TIMER                                                      = 0x8BA, /* 2234 */
  EVENT_RPM_LR3_TIMER_EXPIRED                                                    = 0x8BB, /* 2235 */
  EVENT_RPM_BACKOFF_TIMER_VAL                                                    = 0x8BC, /* 2236 */
  EVENT_RPM_READ_ALL_PARAM                                                       = 0x8BD, /* 2237 */
  EVENT_RPM_BACKOFF_TIMER_EXP                                                    = 0x8BE, /* 2238 */
  EVENT_LTE_SCELL_CONFIGURATION                                                  = 0x8BF, /* 2239 */
  EVENT_LTE_SCELL_ACTIVATION_COMMAND                                             = 0x8C0, /* 2240 */
  EVENT_LTE_SCELL_DEACTIVATION_TIMER_EXPIRY                                      = 0x8C1, /* 2241 */
  EVENT_SCELL_STATE_CHANGE                                                       = 0x8C2, /* 2242 */
  EVENT_GNSS_SPECTRUM_ANALYZER_STATUS                                            = 0x8C3, /* 2243 */
  EVENT_GSM_TO_TDSCDMA_RESEL_START                                               = 0x8C4, /* 2244 */
  EVENT_GSM_TO_TDSCDMA_RESEL_END                                                 = 0x8C5, /* 2245 */
  EVENT_AUDIO_MWS_DIAG_SERVICE                                                   = 0x8C6, /* 2246 */
  EVENT_WCDMA_ASF_TIMER_EXPIRED                                                  = 0x8C7, /* 2247 */
  EVENT_ASF_SCAN_START                                                           = 0x8C8, /* 2248 */
  EVENT_ASF_SCAN_END                                                             = 0x8C9, /* 2249 */
  EVENT_TDSCDMA_RRC_INTER_RAT_CCO_END                                            = 0x8CA, /* 2250 */
  EVENT_SECAPITEST_TESTCASE_START                                                = 0x8CB, /* 2251 */
  EVENT_SECAPITEST_TESTCASE_END                                                  = 0x8CC, /* 2252 */
  EVENT_TDSCDMA_RXD_STATE                                                        = 0x8CD, /* 2253 */
  EVENT_WCDMA_RRC_ASF_TIMER_STATUS                                               = 0x8CE, /* 2254 */
  EVENT_WCDMA_RRC_CSG_DETECTED                                                   = 0x8CF, /* 2255 */
  EVENT_CM_SSAC_CALL                                                             = 0x8D0, /* 2256 */
  EVENT_CM_SSAC_TIME                                                             = 0x8D1, /* 2257 */
  EVENT_PAGE_MATCH                                                               = 0x8D2, /* 2258 */
  EVENT_CSFB_CALL_TYPE                                                           = 0x8D3, /* 2259 */
  EVENT_OEM_START_ID                                                             = 0x8D4, /* 2260 */ /* reserved range - start */
  EVENT_OEM_END_ID                                                               = 0x99B, /* 2459 */ /* reserved range - end */
  EVENT_WCDMA_ASF_MEAS_REQ_RCVD                                                  = 0x99C, /* 2460 */
  EVENT_SECAPITEST_TESTCASE_SUCCESS                                              = 0x99D, /* 2461 */
  EVENT_SECAPITEST_TESTCASE_FAILURE                                              = 0x99E, /* 2462 */
  EVENT_HDR_MSG_RX_PAGE                                                          = 0x99F, /* 2463 */
  EVENT_TDSCDMA_RRC_HANDOVER_START                                               = 0x9A0, /* 2464 */
  EVENT_TDSCDMA_RRC_HANDOVER_END                                                 = 0x9A1, /* 2465 */
  EVENT_CODEC_INIT                                                               = 0x9A2, /* 2466 */
  EVENT_CODEC_RATE_CHANGE                                                        = 0x9A3, /* 2467 */
  EVENT_GPSXTRA_T_POSITION_INJECTION                                             = 0x9A4, /* 2468 */
  EVENT_TDSCDMA_RRC_X_TO_TDSCDMA_HANDOVER_START                                  = 0x9A5, /* 2469 */
  EVENT_WCDMA_ENH_L1_STATE                                                       = 0x9A6, /* 2470 */
  EVENT_CM_CALL_EVENT_ORIG_2                                                     = 0x9A7, /* 2471 */
  EVENT_CM_CALL_EVENT_CONNECT_2                                                  = 0x9A8, /* 2472 */
  EVENT_CM_CALL_EVENT_END_2                                                      = 0x9A9, /* 2473 */
  EVENT_TDSCDMA_RRC_X_TO_TDSCDMA_HANDOVER_END                                    = 0x9AA, /* 2474 */
  EVENT_1X_TO_LTE_RESEL_START                                                    = 0x9AB, /* 2475 */
  EVENT_DS_DORMANCY_STATUS_UM_QUEUE_STATS                                        = 0x9AC, /* 2476 */
  EVENT_DS_DORMANCY_STATUS_RM_QUEUE_STATS                                        = 0x9AD, /* 2477 */
  EVENT_DS_CALL_STATUS                                                           = 0x9AE, /* 2478 */
  EVENT_LTE_RRC_IRAT_HO_FROM_EUTRAN_END                                          = 0x9AF, /* 2479 */
  EVENT_LTE_RRC_IRAT_HO_TO_EUTRAN_START                                          = 0x9B0, /* 2480 */
  EVENT_LTE_RRC_UL_MSG_MEAS_REPORT_MEASOBJ_MODE                                  = 0x9B1, /* 2481 */
  EVENT_TDSCDMA_RRC_ACQUISITION_START                                            = 0x9B2, /* 2482 */
  EVENT_LTE_SCELL_STATE_CHANGE_ENHANCED                                          = 0x9B3, /* 2483 */
  EVENT_SD_EVENT_ACTION_HYBR2                                                    = 0x9B4, /* 2484 */
  EVENT_UMTS_NAS_CB_CTCH_START                                                   = 0x9B5, /* 2485 */
  EVENT_UMTS_NAS_CB_BMC_MSG_DECODE_FAIL                                          = 0x9B6, /* 2486 */
  EVENT_WCDMA_RLC_UL_CONFIG                                                      = 0x9B7, /* 2487 */
  EVENT_NAS_CB_CTCH_STOP                                                         = 0x9B8, /* 2488 */
  EVENT_GPS_PD_COMM_NW_CONNECTING                                                = 0x9B9, /* 2489 */
  EVENT_GPS_PD_COMM_NW_CONNECTED                                                 = 0x9BA, /* 2490 */
  EVENT_GPS_PD_COMM_SERVER_CONNECTING                                            = 0x9BB, /* 2491 */
  EVENT_GPS_PD_COMM_SERVER_CONNECTED                                             = 0x9BC, /* 2492 */
  EVENT_BROADCAST_CYCLE_DISABLED                                                 = 0x9BD, /* 2493 */
  EVENT_BROADCAST_CYCLE_ENABLED                                                  = 0x9BE, /* 2494 */
  EVENT_WCDMA_ASDIV_TYPE1_SWITCH_RSCP_BASED                                      = 0x9BF, /* 2495 */
  EVENT_WCDMA_ASDIV_TYPE1_SWITCH_TXAGC_BASED                                     = 0x9C0, /* 2496 */
  EVENT_WCDMA_ASDIV_TYPE1_SWITCHBACK_MTPL_BASED                                  = 0x9C1, /* 2497 */
  EVENT_WCDMA_ASDIV_TYPE1_SWITCHBACK_TXAGC_BASED                                 = 0x9C2, /* 2498 */
  EVENT_WCDMA_ASDIV_TYPE2_SWITCH_RSCP_BASED                                      = 0x9C3, /* 2499 */
  EVENT_WCDMA_ASDIV_TYPE2_SWITCH_MTPL_BASED                                      = 0x9C4, /* 2500 */
  EVENT_WCDMA_ASDIV_TYPE2_SWITCH_RSCP_LOOPBACK_BASED                             = 0x9C5, /* 2501 */
  EVENT_WCDMA_ASDIV_TYPE2_SWITCHBACK_DEGRADATION_BASED                           = 0x9C6, /* 2502 */
  EVENT_WCDMA_ASDIV_PROBE_BOTH_ANTENNAS                                          = 0x9C7, /* 2503 */
  EVENT_TDSCDMA_RRC_HSUPA_SUPPORT_STATUS                                         = 0x9C8, /* 2504 */
  EVENT_WCDMA_HS_RACH_OP                                                         = 0x9C9, /* 2505 */
  EVENT_WLAN_FW_SLM_CONS_BCN_MISS                                                = 0x9CA, /* 2506 */
  EVENT_WLAN_FW_SLM_RSSI_MONITOR                                                 = 0x9CB, /* 2507 */
  EVENT_SD_HYBR2_BSR_START                                                       = 0x9CC, /* 2508 */
  EVENT_SD_HYBR2_BSR_END                                                         = 0x9CD, /* 2509 */
  EVENT_IWLAN_S2B_CALL_TRACER_LOGGING                                            = 0x9CE, /* 2510 */
  EVENT_WCDMA_RRC_FAILURE                                                        = 0x9CF, /* 2511 */
  EVENT_WCDMA_CME_STATE                                                          = 0x9D0, /* 2512 */
  EVENT_WCDMA_RxD_STATE                                                          = 0x9D1, /* 2513 */
  EVENT_WCDMA_RACH_ABORT_CAUSE                                                   = 0x9D2, /* 2514 */
  EVENT_CM_PH_DYN_SWITCH                                                         = 0x9D3, /* 2515 */
  EVENT_TDSCDMA_RRC_DMCR_ENABLED                                                 = 0x9D4, /* 2516 */
  EVENT_ASDIV_TESTMODE1_SWITCH                                                   = 0x9D5, /* 2517 */
  EVENT_PM_UE_MODE                                                               = 0x9D6, /* 2518 */
  EVENT_TDSCDMA_SELF_HOSTING                                                     = 0x9D7, /* 2519 */
  EVENT_LTE_ML1_SEARCH_IDLE                                                      = 0x9D8, /* 2520 */
  EVENT_GSTK_BIP_STATUS                                                          = 0x9D9, /* 2521 */
  EVENT_TDSCDMA_RRC_DSDS_TA_BLOCK                                                = 0x9DA, /* 2522 */
  EVENT_PS_SYSTEM_STATUS                                                         = 0x9DB, /* 2523 */
  EVENT_QMI_SYSTEM_STATUS                                                        = 0x9DC, /* 2524 */
  EVENT_PS_SYSTEM_STATUS_EX                                                      = 0x9DD, /* 2525 */
  EVENT_QMI_SYSTEM_STATUS_EX                                                     = 0x9DE, /* 2526 */
  EVENT_ASDIV_IDLE_SWITCH_FACH_INIT                                              = 0x9DF, /* 2527 */
  EVENT_ASDIV_IDLE_SWITCHBACK_FACH_INIT                                          = 0x9E0, /* 2528 */
  EVENT_ASDIV_IDLE_SWITCH_OOS_TIMER                                              = 0x9E1, /* 2529 */
  EVENT_ASDIV_IDLE_SWITCHBACK_OOS_TIMER                                          = 0x9E2, /* 2530 */
  EVENT_ASDIV_IDLE_SWITCH_RACH_NACK                                              = 0x9E3, /* 2531 */
  EVENT_ASDIV_IDLE_SWITCHBACK_RACH_NACK                                          = 0x9E4, /* 2532 */
  EVENT_ASDIV_ACQ_SWITCH                                                         = 0x9E5, /* 2533 */
  EVENT_ASDIV_ACQ_SWITCHBACK                                                     = 0x9E6, /* 2534 */
  EVENT_LTE_RRC_PAGING_UE_ID                                                     = 0x9E7, /* 2535 */
  EVENT_LTE_ML1_ASDIV                                                            = 0x9E8, /* 2536 */
  EVENT_LTE_RRC_CGI_START_INDI                                                   = 0x9E9, /* 2537 */
  EVENT_DS_UM_QUEUE_STATS_EX                                                     = 0x9EA, /* 2538 */
  EVENT_HSPA                                                                     = 0x9EB, /* 2539 */
  EVENT_TDSCDMA_TO_GSM_REDIRECTION_START                                         = 0x9EC, /* 2540 */
  EVENT_TDSCDMA_TO_GSM_REDIRECTION_END                                           = 0x9ED, /* 2541 */
  EVENT_LTE_RRC_EMBMS_AVAIL_SAI_LIST_IND                                         = 0x9EE, /* 2542 */
  EVENT_LTE_RRC_EMBMS_INTEREST_IND                                               = 0x9EF, /* 2543 */
  EVENT_LTE_RRC_EMBMS_SIGNAL_STRENGTH_REPORTING                                  = 0x9F0, /* 2544 */
  EVENT_GSM_VS_INTERFACE_TYPE_1                                                  = 0x9F1, /* 2545 */
  EVENT_GSM_VS_INTERFACE_TYPE_2                                                  = 0x9F2, /* 2546 */
  EVENT_GSM_VS_INTERFACE_GHDI_CONTROL                                            = 0x9F3, /* 2547 */
  EVENT_WCDMA_EUL_REL7_FEAT_OP                                                   = 0x9F4, /* 2548 */
  EVENT_WCDMA_RRC_CU_STATUS                                                      = 0x9F5, /* 2549 */
  EVENT_WCDMA_HS_SCCH_ORDER_VER2                                                 = 0x9F6, /* 2550 */
  EVENT_AUDIO_PATH_DELAY_CHANGE                                                  = 0x9F7, /* 2551 */
  EVENT_LTE_RRC_CAMPED_CELL_STATUS                                               = 0x9F8, /* 2552 */
  EVENT_DATAMODEM_IPA_DROP_PKT_DL                                                = 0x9F9, /* 2553 */
  EVENT_DATAMODEM_IPA_DROP_PKT_UL                                                = 0x9FA, /* 2554 */
  EVENT_NAS_LAU                                                                  = 0x9FB, /* 2555 */
  EVENT_NAS_ATTACH                                                               = 0x9FC, /* 2556 */
  EVENT_NAS_RAU                                                                  = 0x9FD, /* 2557 */
  EVENT_NAS_MO_DETACH                                                            = 0x9FE, /* 2558 */
  EVENT_NAS_MT_DETACH                                                            = 0x9FF, /* 2559 */
  EVENT_NAS_TAU                                                                  = 0xA00, /* 2560 */
  EVENT_GSM_CELL_SELECTED                                                        = 0xA01, /* 2561 */
  EVENT_GSM_DS_CELL_SELECTED                                                     = 0xA02, /* 2562 */
  EVENT_WLAN_QCA_BMISS                                                           = 0xA03, /* 2563 */
  EVENT_WLAN_QCA_RSSI_MONITOR                                                    = 0xA04, /* 2564 */
  EVENT_DS_EPC_PDN_EX                                                            = 0xA05, /* 2565 */
  EVENT_DS_EPC_SRAT_CLEANUP_TIMER_EX                                             = 0xA06, /* 2566 */
  EVENT_DS_DSD_PREFERRED_RADIO_INFO                                              = 0xA07, /* 2567 */
  EVENT_LTE_RRC_NEW_CELL_IND_EXT_EARFCN                                          = 0xA08, /* 2568 */
  EVENT_LTE_RRC_CELL_RESEL_FAILURE_EXT_EARFCN                                    = 0xA09, /* 2569 */
  EVENT_LTE_RRC_HO_FAILURE_EXT_EARFCN                                            = 0xA0A, /* 2570 */
  EVENT_LTE_RRC_SIB_READ_FAILURE_EXT_EARFCN                                      = 0xA0B, /* 2571 */
  EVENT_LTE_RRC_CELL_RESEL_STARTED_EXT_EARFCN                                    = 0xA0C, /* 2572 */
  EVENT_LTE_RRC_MCCH_CHANGE_NOTIFICATION_EXT_EARFCN                              = 0xA0D, /* 2573 */
  EVENT_LTE_RRC_CELL_BLACKLIST_IND_EXT_EARFCN                                    = 0xA0E, /* 2574 */
  EVENT_WCDMA_RRC_INTER_FREQ_HHO_STATUS                                          = 0xA0F, /* 2575 */
  EVENT_DS_DSD_TIMER                                                             = 0xA10, /* 2576 */
  EVENT_TDSCDMA_TO_TDSCDMA_REDIRECTION_START                                     = 0xA11, /* 2577 */
  EVENT_TDSCDMA_TO_TDSCDMA_REDIRECTION_END                                       = 0xA12, /* 2578 */
  EVENT_WLAN_QCA_HEARTBEAT_FAILURE                                               = 0xA13, /* 2579 */
  EVENT_DS_3GPP_SVC_THROTTLE                                                     = 0xA14, /* 2580 */
  EVENT_DS_3GPP_PDN_THROTTLE                                                     = 0xA15, /* 2581 */
  EVENT_GSM_TO_TDSCDMA_REDIR_STARTED                                             = 0xA16, /* 2582 */
  EVENT_GSM_TO_TDSCDMA_REDIR_ENDED                                               = 0xA17, /* 2583 */
  EVENTS_DS_GSM_PAGE_MISSED                                                      = 0xA18, /* 2584 */
  EVENT_GSM_TO_WCDMA_REDIR_STARTED                                               = 0xA19, /* 2585 */
  EVENT_GSM_TO_WCDMA_REDIR_ENDED                                                 = 0xA1A, /* 2586 */
  EVENT_DS_RADIO_STACK_STATE                                                     = 0xA1B, /* 2587 */
  EVENT_DS_CALL_CONTROL_STATE                                                    = 0xA1C, /* 2588 */
  EVENT_DS_BEARER_CONTROL_STATE                                                  = 0xA1D, /* 2589 */
  EVENT_LTE_SCELL_STATE_CHANGE_ENHANCED2                                         = 0xA1E, /* 2590 */
  EVENT_LTE_SCELL_PCELL_TIME_DRIFT                                               = 0xA1F, /* 2591 */
  EVENT_LTE_SCELL_WB_NB_TIME_DRIFT                                               = 0xA20, /* 2592 */
  EVENTS_TDSCDMA_RRC_SIB_RCVD_V2                                                 = 0xA21, /* 2593 */
  EVENT_LTE_ML1_EPHR_REPORT                                                      = 0xA22, /* 2594 */
  EVENT_LTE_TO_LTE_REDIRECTION                                                   = 0xA23, /* 2595 */
  EVENT_TDSCDMA_DA_BACKOFF_TIMER_START                                           = 0xA24, /* 2596 */
  EVENT_TDSCDMA_DA_BACKOFF_TIMER_STOP                                            = 0xA25, /* 2597 */
  EVENT_TDSCDMA_DA_BACKOFF_TIMER_EXPIRED                                         = 0xA26, /* 2598 */
  EVENT_WCDMA_TO_GSM_REDIRECTION_START                                           = 0xA27, /* 2599 */
  EVENT_WCDMA_TO_GSM_REDIRECTION_END                                             = 0xA28, /* 2600 */
  EVENT_WCDMA_TO_WCDMA_REDIRECTION_START                                         = 0xA29, /* 2601 */
  EVENT_WCDMA_TO_WCDMA_REDIRECTION_END                                           = 0xA2A, /* 2602 */
  EVENT_GNSS_RCVR_STATE                                                          = 0xA2B, /* 2603 */
  EVENT_GSM_SI_CACHE_UPDATE_ENTRY                                                = 0xA2C, /* 2604 */
  EVENT_GSM_SI_CACHE_RETRIEVE                                                    = 0xA2D, /* 2605 */
  EVENT_GSM_SI_CACHE_FLUSH                                                       = 0xA2E, /* 2606 */
  EVENT_NAS_PLMN_FOUND                                                           = 0xA2F, /* 2607 */
  EVENT_LTE_SUB_FRAME_NUMBER                                                     = 0xA30, /* 2608 */
  EVENT_GNSS_POSITION_INCONSISTENCY                                              = 0xA31, /* 2609 */
  EVENT_IPV6_EXT_ADDRESS                                                         = 0xA32, /* 2610 */
  EVENT_DS3G_COEX_FLOW_CONTROL                                                   = 0xA33, /* 2611 */
  EVENT_NAS_LTE_IRAT_SHORT_TIMER_STARTED                                         = 0xA34, /* 2612 */
  EVENT_NAS_LTE_IRAT_LONG_TIMER_STARTED                                          = 0xA35, /* 2613 */
  EVENT_NAS_LTE_IRAT_SEARCH_STARTED                                              = 0xA36, /* 2614 */
  EVENT_NAS_HPLMN_IRAT_SEARCH_STARTED                                            = 0xA37, /* 2615 */
  EVENT_NAS_LTE_IRAT_NOTAVAIL_TO_AVAIL                                           = 0xA38, /* 2616 */
  EVENT_NAS_LTE_IRAT_AVAIL_TO_NOTAVAIL                                           = 0xA39, /* 2617 */
  EVENT_DIAG_DROP_DEBUG                                                          = 0xA3A, /* 2618 */
  EVENT_FULL_SRV_EMC_CALL                                                        = 0xA3B, /* 2619 */
  EVENT_LTE_EMM_TIMER_STOP                                                       = 0xA3C, /* 2620 */
  EVENT_LTE_ESM_TIMER_STOP                                                       = 0xA3D, /* 2621 */
  EVENT_MCS_TRM_ASDIV                                                            = 0xA3E, /* 2622 */
  EVENTS_DS_GSM_MESSAGE_SENT                                                     = 0xA3F, /* 2623 */
  EVENTS_DS_GSM_COUNTER_EXPIRED                                                  = 0xA40, /* 2624 */
  EVENTS_DS_GPRS_MAC_RESELECT_IND                                                = 0xA41, /* 2625 */
  EVENTS_DS_GPRS_CELL_UPDATE_START                                               = 0xA42, /* 2626 */
  EVENTS_DS_GPRS_CELL_UPDATE_END                                                 = 0xA43, /* 2627 */
  EVENTS_DS_PACKET_RANDOM_ACCESS_REQ                                             = 0xA44, /* 2628 */
  EVENTS_DS_GSM_L1_SUBSTATE                                                      = 0xA45, /* 2629 */
  EVENTS_DS_GSM_TO_WCDMA_HANDOVER_START                                          = 0xA46, /* 2630 */
  EVENTS_DS_GSM_L1_VOCODER_INITIALIZE                                            = 0xA47, /* 2631 */
  EVENTS_DS_GSM_L1_VOCODER_ENABLED                                               = 0xA48, /* 2632 */
  EVENTS_DS_GPRS_MAC_IDLE_IND                                                    = 0xA49, /* 2633 */
  EVENTS_DS_GPRS_ACCESS_REJECT                                                   = 0xA4A, /* 2634 */
  EVENTS_DS_GERAN_GRR_PLMN_LIST_RAT_SEARCH_STARTED                               = 0xA4B, /* 2635 */
  EVENTS_DS_GERAN_GRR_PLMN_LIST_RAT_SEARCH_COMPLETED                             = 0xA4C, /* 2636 */
  EVENTS_DS_GERAN_GRR_PLMN_LIST_RAT_SEARCH_ABORTED                               = 0xA4D, /* 2637 */
  EVENTS_DS_GERAN_GRR_REDIR_STARTED                                              = 0xA4E, /* 2638 */
  EVENTS_DS_GERAN_GRR_REDIR_COMPLETED                                            = 0xA4F, /* 2639 */
  EVENTS_DS_GERAN_GRR_REDIR_ABORTED                                              = 0xA50, /* 2640 */
  EVENTS_DS_GSM_TO_LTE_RESEL_STARTED                                             = 0xA51, /* 2641 */
  EVENTS_DS_GSM_TO_LTE_RESEL_ENDED                                               = 0xA52, /* 2642 */
  EVENTS_DS_GSM_TO_LTE_REDIR_STARTED                                             = 0xA53, /* 2643 */
  EVENTS_DS_GSM_TO_LTE_REDIR_ENDED                                               = 0xA54, /* 2644 */
  EVENTS_DS_GSM_CS_CALL_ESTABLISHMENT_FAILURE                                    = 0xA55, /* 2645 */
  EVENTS_DS_GSM_CS_CALL_DROPPED                                                  = 0xA56, /* 2646 */
  EVENTS_DS_GSM_LOST_SERVICE                                                     = 0xA57, /* 2647 */
  EVENTS_DS_GSM_IN_SERVICE                                                       = 0xA58, /* 2648 */
  EVENTS_DS_GSM_PLMN_LIST_GSM_SUB_SEARCH_ENDED                                   = 0xA59, /* 2649 */
  EVENTS_DS_GSM_TO_TDSCDMA_RESEL_START                                           = 0xA5A, /* 2650 */
  EVENTS_DS_GSM_TO_TDSCDMA_RESEL_END                                             = 0xA5B, /* 2651 */
  EVENTS_DS_GSM_VS_INTERFACE_TYPE_1                                              = 0xA5C, /* 2652 */
  EVENTS_DS_GSM_VS_INTERFACE_TYPE_2                                              = 0xA5D, /* 2653 */
  EVENTS_DS_GSM_VS_INTERFACE_GHDI_CONTROL                                        = 0xA5E, /* 2654 */
  EVENTS_DS_GSM_TO_TDSCDMA_REDIR_STARTED                                         = 0xA5F, /* 2655 */
  EVENTS_DS_GSM_TO_TDSCDMA_REDIR_ENDED                                           = 0xA60, /* 2656 */
  EVENTS_DS_GSM_TO_WCDMA_REDIR_STARTED                                           = 0xA61, /* 2657 */
  EVENTS_DS_GSM_TO_WCDMA_REDIR_ENDED                                             = 0xA62, /* 2658 */
  EVENT_GNSS_GDT_SESS_START_REQ                                                  = 0xA63, /* 2659 */
  EVENT_GNSS_GDT_SESS_START_RESP                                                 = 0xA64, /* 2660 */
  EVENT_GNSS_GDT_SEND_REQ                                                        = 0xA65, /* 2661 */
  EVENT_GNSS_GDT_SEND_RESP                                                       = 0xA66, /* 2662 */
  EVENT_GNSS_GDT_SESS_END_REQ                                                    = 0xA67, /* 2663 */
  EVENT_GNSS_GDT_SESS_END_RESP                                                   = 0xA68, /* 2664 */
  EVENT_GNSS_GDT_SESS_OPEN_REQ                                                   = 0xA69, /* 2665 */
  EVENT_GNSS_GDT_SESS_CLOSE_REQ                                                  = 0xA6A, /* 2666 */
  EVENT_GNSS_GTP_TDP_MEASURMENT_ENABLE                                           = 0xA6B, /* 2667 */
  EVENT_GNSS_GTP_TDP_MEASURMENT_DISABLE                                          = 0xA6C, /* 2668 */
  EVENT_GNSS_GTP_TDP_MEASURMENT_REQUEST                                          = 0xA6D, /* 2669 */
  EVENT_GNSS_GTP_TDP_MEASURMENT_RCVD                                             = 0xA6E, /* 2670 */
  EVENT_GPS_GTP_TDP_SESS_START                                                   = 0xA6F, /* 2671 */
  EVENT_GPS_GTP_TDP_SESS_END                                                     = 0xA70, /* 2672 */
  EVENT_WLAN_MAC_RESET                                                           = 0xA71, /* 2673 */
  EVENT_PM_RAT_CHANGE                                                            = 0xA72, /* 2674 */
  EVENT_DTM_ENABLED_UE                                                           = 0xA73, /* 2675 */
  EVENT_DTM_ENABLED_CELL                                                         = 0xA74, /* 2676 */
  EVENTS_DS_DTM_ENABLED_CELL                                                     = 0xA75, /* 2677 */
  EVENT_LTE_RRC_UL_MSG_MEAS_REPORT_EXT                                           = 0xA76, /* 2678 */
  EVENT_WCDMA_RRC_HSPA_RNTI                                                      = 0xA77, /* 2679 */
  EVENT_WCDMA_CSFB_CALL_OPT                                                      = 0xA78, /* 2680 */
  EVENT_GSM_RESELECT_END_V2                                                      = 0xA79, /* 2681 */
  EVENT_GSM_CAMP_ATTEMPT_START_V2                                                = 0xA7A, /* 2682 */
  EVENTS_DS_GSM_RESELECT_END_V2                                                  = 0xA7B, /* 2683 */
  EVENTS_DS_GSM_CAMP_ATTEMPT_START_V2                                            = 0xA7C, /* 2684 */
  EVENT_CM_MSIM_INFO_CHG                                                         = 0xA7D, /* 2685 */
  EVENT_LTE_TIMING_ADVANCE_V2                                                    = 0xA7E, /* 2686 */
  EVENT_LTE_UL_OUT_OF_SYNC_V2                                                    = 0xA7F, /* 2687 */
  EVENT_LTE_SPS_DEACTIVATED_V2                                                   = 0xA80, /* 2688 */
  EVENT_LTE_RACH_ACCESS_START_V2                                                 = 0xA81, /* 2689 */
  EVENT_LTE_RACH_ACCESS_RESULT_V2                                                = 0xA82, /* 2690 */
  EVENT_LTE_RACH_RAID_MATCH_V2                                                   = 0xA83, /* 2691 */
  EVENT_LTE_MAC_RESET_V2                                                         = 0xA84, /* 2692 */
  EVENT_LTE_BSR_SR_REQUEST_V2                                                    = 0xA85, /* 2693 */
  EVENT_LTE_MAC_TIMER_V2                                                         = 0xA86, /* 2694 */
  EVENT_CM_PLMN_BLOCK_REQ                                                        = 0xA87, /* 2695 */
  EVENT_NAS_CC                                                                   = 0xA88, /* 2696 */
  EVENT_NAS_SS                                                                   = 0xA89, /* 2697 */
  EVENT_NAS_SMS                                                                  = 0xA8A, /* 2698 */
  EVENT_NAS_SM                                                                   = 0xA8B, /* 2699 */
  EVENT_NAS_ESM                                                                  = 0xA8C, /* 2700 */
  EVENT_WLAN_EAPOL                                                               = 0xA8D, /* 2701 */
  EVENT_WLAN_EXTSCAN_FEATURE_STARTED                                             = 0xA8E, /* 2702 */
  EVENT_WLAN_EXTSCAN_FEATURE_CHANNEL_CONFIG                                      = 0xA8F, /* 2703 */
  EVENT_WLAN_EXTSCAN_CYCLE_STARTED                                               = 0xA90, /* 2704 */
  EVENT_WLAN_EXTSCAN_CYCLE_COMPLETED                                             = 0xA91, /* 2705 */
  EVENT_WLAN_EXTSCAN_BUCKET_STARTED                                              = 0xA92, /* 2706 */
  EVENT_WLAN_EXTSCAN_BUCKET_COMPLETED                                            = 0xA93, /* 2707 */
  EVENT_WLAN_ROAM_SCAN_STARTED                                                   = 0xA94, /* 2708 */
  EVENT_WLAN_ROAM_SCAN_COMPLETE                                                  = 0xA95, /* 2709 */
  EVENT_WLAN_ROAM_CANDIDATE_FOUND                                                = 0xA96, /* 2710 */
  EVENT_WLAN_ROAM_SCAN_CONFIG                                                    = 0xA97, /* 2711 */
  EVENT_WLAN_BT_COEX_BT_SCO_START                                                = 0xA98, /* 2712 */
  EVENT_WLAN_BT_COEX_BT_SCO_STOP                                                 = 0xA99, /* 2713 */
  EVENT_WLAN_BT_COEX_BT_SCAN_START                                               = 0xA9A, /* 2714 */
  EVENT_WLAN_BT_COEX_BT_SCAN_STOP                                                = 0xA9B, /* 2715 */
  EVENT_WIFI_BT_COEX_BT_HID_START                                                = 0xA9C, /* 2716 */
  EVENT_WIFI_BT_COEX_BT_HID_STOP                                                 = 0xA9D, /* 2717 */
  EVENT_IMS_FAR_END_RAT_TYPE_DETECTED                                            = 0xA9E, /* 2718 */
  EVENT_IMS_RTP_REDUN_START                                                      = 0xA9F, /* 2719 */
  EVENT_IMS_RTP_REDUN_END                                                        = 0xAA0, /* 2720 */
  EVENT_SRVCC_SYNC_IND_SENT                                                      = 0xAA1, /* 2721 */
  EVENT_WLAN_WAKE_LOCK                                                           = 0xAA2, /* 2722 */
  EVENT_WLAN_EXTSCAN_FEATURE_STOP                                                = 0xAA3, /* 2723 */
  EVENT_WLAN_EXTSCAN_RESULTS_AVAILABLE                                           = 0xAA4, /* 2724 */
  EVENT_WLAN_EXTSCAN_CAPABILITIES                                                = 0xAA5, /* 2725 */
  EVENT_WLAN_BEACON_RECEIVED                                                     = 0xAA6, /* 2726 */
  EVENT_WLAN_LOG_COMPLETE                                                        = 0xAA7, /* 2727 */
  EVENT_LTE_SCELL_STATE_CHANGE_ENHANCED3                                         = 0xAA8, /* 2728 */
  EVENT_GSM_PAGE_MISSED                                                          = 0xAA9, /* 2729 */
  EVENT_LTE_ML1_SLEEP                                                            = 0xAAA, /* 2730 */
  EVENT_DS_NAS_CB_PAGE_RECEIVED                                                  = 0xAAB, /* 2731 */
  EVENT_DS_SM_PDP_STATE                                                          = 0xAAC, /* 2732 */
  EVENT_DS_SMGMM_REQUEST_SENT                                                    = 0xAAD, /* 2733 */
  EVENT_DS_SMGMM_REJECT_RECEIVED                                                 = 0xAAE, /* 2734 */
  EVENT_DS_SMS_STATISTICS                                                        = 0xAAF, /* 2735 */
  EVENT_DS_UMTS_CALLS_STATISTICS                                                 = 0xAB0, /* 2736 */
  EVENT_DS_GHDI_MVS_STATE                                                        = 0xAB1, /* 2737 */
  EVENT_DS_MVS_STATE                                                             = 0xAB2, /* 2738 */
  EVENT_WLAN_STATUS_V2                                                           = 0xAB3, /* 2739 */
  EVENT_VS_VOCODER_STATE                                                         = 0xAB4, /* 2740 */
  EVENT_WLAN_TDLS_TEARDOWN                                                       = 0xAB5, /* 2741 */
  EVENT_WLAN_TDLS_ENABLE_LINK                                                    = 0xAB6, /* 2742 */
  EVENT_WLAN_SUSPEND_RESUME                                                      = 0xAB7, /* 2743 */
  EVENT_WLAN_OFFLOAD_REQ                                                         = 0xAB8, /* 2744 */
  EVENT_WLAN_TDLS_SCAN_BLOCK                                                     = 0xAB9, /* 2745 */
  EVENT_WLAN_TX_RX_MGMT                                                          = 0xABA, /* 2746 */
  EVENT_WLAN_LOW_RESOURCE_FAILURE                                                = 0xABB, /* 2747 */
  EVENT_WLAN_FW_CONN_MGMT_SEND                                                   = 0xABC, /* 2748 */
  EVENT_WLAN_FW_CONN_MGMT_SEND_FAILED                                            = 0xABD, /* 2749 */
  EVENT_WLAN_FW_CONN_MGMT_RECV                                                   = 0xABE, /* 2750 */
  EVENT_WLAN_FW_EAPOL_SEND                                                       = 0xABF, /* 2751 */
  EVENT_WLAN_FW_EAPOL_SEND_FAILED                                                = 0xAC0, /* 2752 */
  EVENT_WLAN_FW_KEY_INSTALL                                                      = 0xAC1, /* 2753 */
  EVENT_WLAN_FW_DISCONNECT                                                       = 0xAC2, /* 2754 */
  EVENT_WLAN_FW_ACTIVE_CONNECTIONS                                               = 0xAC3, /* 2755 */
  EVENT_WLAN_FW_BEACON_MISS                                                      = 0xAC4, /* 2756 */
  EVENT_WLAN_FW_PEER_UPDATE                                                      = 0xAC5, /* 2757 */
  EVENT_WLAN_FW_CONCURRENCY_UPDATE                                               = 0xAC6, /* 2758 */
  EVENT_WLAN_FW_SCAN_START                                                       = 0xAC7, /* 2759 */
  EVENT_WLAN_FW_SCAN_END                                                         = 0xAC8, /* 2760 */
  EVENT_WLAN_FW_ROAM_STATUS                                                      = 0xAC9, /* 2761 */
  EVENT_WLAN_FW_ROAM_FAIL                                                        = 0xACA, /* 2762 */
  EVENT_WLAN_FW_P2P_KEEPALIVE_START                                              = 0xACB, /* 2763 */
  EVENT_WLAN_FW_QUIET_START                                                      = 0xACC, /* 2764 */
  EVENT_WLAN_FW_QUIET_END                                                        = 0xACD, /* 2765 */
  EVENT_WLAN_FW_BEACON_START                                                     = 0xACE, /* 2766 */
  EVENT_WLAN_FW_RTT_MEAS_REQ                                                     = 0xACF, /* 2767 */
  EVENT_WLAN_FW_RTT_MEAS_ERR                                                     = 0xAD0, /* 2768 */
  EVENT_WLAN_FW_RTT_INIT_TX_ERR                                                  = 0xAD1, /* 2769 */
  EVENT_WLAN_FW_RTT_RESP_RX_FTMR                                                 = 0xAD2, /* 2770 */
  EVENT_WLAN_FW_RTT_RESP_TX_ERR_FTM                                              = 0xAD3, /* 2771 */
  EVENT_WLAN_FW_RTT_INIT_RX_FTM                                                  = 0xAD4, /* 2772 */
  EVENT_WLAN_FW_RTT_CH_REQ_ERROR                                                 = 0xAD5, /* 2773 */
  EVENT_WLAN_LPI_SNOOP_CFG                                                       = 0xAD6, /* 2774 */
  EVENT_WLAN_LPI_START_SCAN                                                      = 0xAD7, /* 2775 */
  EVENT_WLAN_LPI_SCAN_RESULT                                                     = 0xAD8, /* 2776 */
  EVENT_WLAN_LPI_STATUS                                                          = 0xAD9, /* 2777 */
  EVENT_WLAN_FW_TDLS_LINK_STATE                                                  = 0xADA, /* 2778 */
  EVENT_WLAN_FW_TDLS_TEARDOWNTRIGGER                                             = 0xADB, /* 2779 */
  EVENT_WLAN_FW_TDLS_INFO                                                        = 0xADC, /* 2780 */
  EVENT_WLAN_FW_TDLS_TXFAIL_INFO                                                 = 0xADD, /* 2781 */
  EVENT_WLAN_FW_RADARDETECT                                                      = 0xADE, /* 2782 */
  EVENT_WLAN_FW_CAC_START                                                        = 0xADF, /* 2783 */
  EVENT_WLAN_FW_CAC_END                                                          = 0xAE0, /* 2784 */
  EVENT_WLAN_FW_WOW_ENTER                                                        = 0xAE1, /* 2785 */
  EVENT_WLAN_FW_WOW_WAKE_UP                                                      = 0xAE2, /* 2786 */
  EVENT_WLAN_FW_WOW_EXIT                                                         = 0xAE3, /* 2787 */
  EVENT_WLAN_FW_OFFLOAD_NLO_CFG                                                  = 0xAE4, /* 2788 */
  EVENT_WLAN_FW_OFFLOAD_CSA_RECV_BEACON_ACTION                                   = 0xAE5, /* 2789 */
  EVENT_WLAN_FW_OFFLOAD_CSA_TIMEOUT_HANDLE_ERROR                                 = 0xAE6, /* 2790 */
  EVENT_WLAN_FW_OFFLOAD_GTK_CFG                                                  = 0xAE7, /* 2791 */
  EVENT_WLAN_FW_OFFLOAD_GTK_RECV_REKEY                                           = 0xAE8, /* 2792 */
  EVENT_WLAN_FW_OFFLOAD_ARP_NS_CFG                                               = 0xAE9, /* 2793 */
  EVENT_WLAN_FW_OFFLOAD_ARP_NS_RECV_HANDLE_ERROR                                 = 0xAEA, /* 2794 */
  EVENT_WLAN_FW_OFFLOAD_CHATTER_SWITCH_ERROR                                     = 0xAEB, /* 2795 */
  EVENT_WLAN_FW_OFFLOAD_CHATTER_HANDLE_ERROR                                     = 0xAEC, /* 2796 */
  EVENT_WLAN_FW_STA_POWER_STATEUPDATE                                            = 0xAED, /* 2797 */
  EVENT_WLAN_FW_POWER_VOTERCVD                                                   = 0xAEE, /* 2798 */
  EVENT_WLAN_FW_STA_POWER_STATE_EVENT                                            = 0xAEF, /* 2799 */
  EVENT_WLAN_FW_STA_POWERDOWN_ABORT                                              = 0xAF0, /* 2800 */
  EVENT_WLAN_FW_EBT                                                              = 0xAF1, /* 2801 */
  EVENT_WLAN_FW_COMMONSS_STATE                                                   = 0xAF2, /* 2802 */
  EVENT_WLAN_MAC_WPM_STATE                                                       = 0xAF3, /* 2803 */
  EVENT_WLAN_FW_WPM_STATE_EVENT                                                  = 0xAF4, /* 2804 */
  EVENT_WLAN_FW_WPM_VOTE                                                         = 0xAF5, /* 2805 */
  EVENT_WLAN_FW_WHAL_POWER_MODE                                                  = 0xAF6, /* 2806 */
  EVENT_WLAN_FW_PEER_CREATE                                                      = 0xAF7, /* 2807 */
  EVENT_WLAN_FW_PEER_DELETE                                                      = 0xAF8, /* 2808 */
  EVENT_WLAN_FW_AST_ADD                                                          = 0xAF9, /* 2809 */
  EVENT_WLAN_FW_AST_REMOVE                                                       = 0xAFA, /* 2810 */
  EVENT_WLAN_FW_CHANNEL_CHANGE_START                                             = 0xAFB, /* 2811 */
  EVENT_WLAN_FW_SWBA                                                             = 0xAFC, /* 2812 */
  EVENT_WLAN_FW_TBTT_OFFSET_UPDATE                                               = 0xAFD, /* 2813 */
  EVENT_WLAN_FW_CHAINMASK_UPDATE                                                 = 0xAFE, /* 2814 */
  EVENT_WLAN_FW_HWQ_EMPTY                                                        = 0xAFF, /* 2815 */
  EVENT_WLAN_FW_MAC_RESET                                                        = 0xB00, /* 2816 */
  EVENT_WLAN_FW_DESC_BIN_WM_HIT                                                  = 0xB01, /* 2817 */
  EVENT_WLAN_FW_MAC_WDOG                                                         = 0xB02, /* 2818 */
  EVENT_WLAN_FW_MODE_CHANGE                                                      = 0xB03, /* 2819 */
  EVENT_LTE_ML1_MODE_SWITCH                                                      = 0xB04, /* 2820 */
  EVENT_WLAN_PROXY_SM                                                            = 0xB05, /* 2821 */
  EVENT_WCDMA_DL_L1_RLF_IND                                                      = 0xB06, /* 2822 */
  EVENT_WLAN_PNO_START_STOP                                                      = 0xB07, /* 2823 */
  EVENT_LTE_RAR_TIMING_ADVANCE                                                   = 0xB08, /* 2824 */
  EVENT_IWLAN_S2B_SM                                                             = 0xB09, /* 2825 */
  EVENT_QDR_SENSOR_DATA_PRODUCED                                                 = 0xB0A, /* 2826 */
  EVENT_QDR_SENSOR_DATA_CONSUMED                                                 = 0xB0B, /* 2827 */
  EVENT_QDR_A6DOF_NF_STATE_REPORT                                                = 0xB0C, /* 2828 */
  EVENT_QDR_NAVLITE_START                                                        = 0xB0D, /* 2829 */
  EVENT_QDR_NAVLITE_END                                                          = 0xB0E, /* 2830 */
  EVENT_IPA_FLTR_INSTALLED_NOTIF_REQ_UL                                          = 0xB0F, /* 2831 */
  EVENT_IPA_FLTR_INSTALL_REQ_DL                                                  = 0xB10, /* 2832 */
  EVENT_IPA_FLOW_CONTROL                                                         = 0xB11, /* 2833 */
  EVENT_IPA_QUOTA_SET                                                            = 0xB12, /* 2834 */
  EVENT_IPA_QUOTA_REACH                                                          = 0xB13, /* 2835 */
  EVENT_IPA_TCP_ACK_COAL_SET                                                     = 0xB14, /* 2836 */
  EVENT_PROSE_TIMER_STATUS                                                       = 0xB15, /* 2837 */
  EVENT_PROSE_DISC_SERVICE_STATUS                                                = 0xB16, /* 2838 */
  EVENT_PROSE_DISC_SESSION_START                                                 = 0xB17, /* 2839 */
  EVENT_PROSE_DISC_SESSION_STOP                                                  = 0xB18, /* 2840 */
  EVENT_PROSE_DISC_SESSION_STATUS                                                = 0xB19, /* 2841 */
  EVENT_WLAN_SSR                                                                 = 0xB1A, /* 2842 */
  EVENT_WCDMA_ASDIV_PORT_SWITCH                                                  = 0xB1B, /* 2843 */
  EVENT_PM_FREQ_LIST                                                             = 0xB1C, /* 2844 */
  EVENT_PM_CALL_MODE                                                             = 0xB1D, /* 2845 */
  EVENT_PM_SVC_MODE                                                              = 0xB1E, /* 2846 */
  EVENT_PM_SCAN_OPT                                                              = 0xB1F, /* 2847 */
  EVENT_PM_RAT_ORDER                                                             = 0xB20, /* 2848 */
  EVENT_PM_RF_BANDS                                                              = 0xB21, /* 2849 */
  EVENT_PM_VOICE_DOMAIN_PREF                                                     = 0xB22, /* 2850 */
  EVENT_PM_FULL_RAT_EVAL                                                         = 0xB23, /* 2851 */
  EVENT_PM_ENTER_FULL_RAT                                                        = 0xB24, /* 2852 */
  EVENT_TDSCDMA_ASDIV_SWITCH_REQUEST                                             = 0xB25, /* 2853 */
  EVENT_TDSCDMA_ASDIV_SWITCH_COMPLETE_FW                                         = 0xB26, /* 2854 */
  EVENT_TDSCDMA_ASDIV_SWITCH_REQUEST_DENIED_BY_TRM                               = 0xB27, /* 2855 */
  EVENT_LTE_RRC_ALTCQI_TABLE_IN_OTA                                              = 0xB28, /* 2856 */
  EVENT_IWLAN_S2B_FAILURE                                                        = 0xB29, /* 2857 */
  EVENT_GSM_PAGE_MISSED_OTHER_SUB_IN_VOICE_CALL                                  = 0xB2A, /* 2858 */
  EVENT_DS3G_DDS_SWITCH                                                          = 0xB2B, /* 2859 */
  EVENT_DS3G_DATA_CALL_TRM_CONTROL                                               = 0xB2C, /* 2860 */
  EVENT_GNSS_UIMAGE_SUMMARY                                                      = 0xB2D, /* 2861 */
  EVENT_LTE_ML1_FW_DB_SETUP_START                                                = 0xB2E, /* 2862 */
  EVENT_LTE_ML1_FW_DB_SETUP_DONE                                                 = 0xB2F, /* 2863 */
  EVENT_MUTILS_PLT_COMMON_CUSTOM_EVENT_MSG                                       = 0xB30, /* 2864 */
  EVENT_DIAG_QSHRINK_ID                                                          = 0xB31, /* 2865 */
  EVENT_DIAG_PROCESS_NAME_ID                                                     = 0xB32, /* 2866 */
  EVENT_WLAN_POWERSAVE_WOW_STATS                                                 = 0xB33, /* 2867 */
  EVENT_WCDMA_TO_LTE_RESELECTION_START_EXTENDED                                  = 0xB34, /* 2868 */
  EVENT_TIME_SVC_TIMESTAMP_DATA                                                  = 0xB35, /* 2869 */
  EVENT_WLAN_QCA_QPOWER_ENABLE                                                   = 0xB36, /* 2870 */
  EVENT_WLAN_QCA_QPOWER_DISABLE                                                  = 0xB37, /* 2871 */
  EVENT_WLAN_QCA_ROUGE_AP_DETECTED                                               = 0xB38, /* 2872 */
  EVENT_WLAN_STA_KICKOUT                                                         = 0xB39, /* 2873 */
  EVENT_WLAN_STA_DATA_STALL                                                      = 0xB3A, /* 2874 */
  EVENT_WLAN_SOFTAP_DATASTALL                                                    = 0xB3B, /* 2875 */
  EVENT_WLAN_CRASH_SUB_SYSTEM                                                    = 0xB3C, /* 2876 */
  EVENT_WLAN_SSR_SHUTDOWN_SUBSYTEM                                               = 0xB3D, /* 2877 */
  EVENT_WLAN_REG                                                                 = 0xB3E, /* 2878 */
  EVENT_LTE_RRC_CELL_INFO                                                        = 0xB3F, /* 2879 */

  EVENT_LAST_ID    = 0xB3F,
  EVENT_NEXT_UNUSED_EVENT,

  EVENT_MAX_ID     = 0x0FFF
} event_id_enum_type;

/*===========================================================================

                        TYPE DEFINITIONS FOR EVENTS

          NOTE: Type definitions for new events are now added by
                the responsible engineer in the target VU:

                (Do not add payload definitions to this file).

===========================================================================*/
typedef unsigned char event_band_class_change_type;
typedef unsigned short event_cdma_ch_change_type;
typedef unsigned char event_bs_p_rev_change_type;
typedef unsigned char event_p_rev_in_use_change_type;
typedef unsigned short event_sid_change_type;
typedef unsigned short event_nid_change_type;
typedef unsigned short event_pzid_change_type;
typedef unsigned char event_op_mode_change_type;

typedef PACK(struct)
{
   unsigned char channel;
   unsigned char msg_id;
} event_message_type;

typedef unsigned char event_timer_expired_type;
typedef unsigned char event_counter_threshold_type;

typedef PACK(struct)
{
   unsigned char old_state;
   unsigned char new_state;
} event_call_processing_state_change_type;

typedef unsigned char event_call_control_instantiated_type;

typedef PACK(struct)
{
   unsigned con_ref      : 8;
   unsigned old_substate : 4;
   unsigned new_substate : 4;
} event_call_control_state_change_type;

typedef unsigned char event_call_control_terminated_type;
typedef unsigned short event_reg_zone_change_type;
typedef unsigned char event_slotted_mode_operation_type;
typedef unsigned char event_qpch_in_use_type;
typedef unsigned short event_idle_handoff_type;
typedef unsigned short event_ms_access_handoff_type;
typedef unsigned short event_ms_access_probe_handoff_type;

typedef PACK(struct)
{
  unsigned short pn[6];
  PACK(struct)
  {
    unsigned s1       : 1;
    unsigned s2       : 1;
    unsigned s3       : 1;
    unsigned s4       : 1;
    unsigned s5       : 1;
    unsigned s6       : 1;
    unsigned reserved : 10;
  } in_sch_aset;
} event_ms_handoff_type;

typedef unsigned long event_tmsi_assigned_type;
typedef unsigned char event_end_rev_supp_burst_assgn_type;
typedef unsigned char event_ch_ind_type;

typedef PACK(struct)
{
   unsigned char pagech;
   unsigned short pn_offset;
} event_pch_acquired_type;

typedef PACK(struct)
{
   unsigned char bcch;
   unsigned short pn_offset;
} event_bcch_acquired_type;

typedef unsigned char event_registration_performed_type;

typedef PACK(struct)
{
   unsigned char ecio;
   unsigned char ps;
} event_system_reselection_type;

/*!
@endcond
*/
#endif /* EVENT_DEFS_H */
