/* Copyright (c) 2010-2014 QUALCOMM Technologies, Inc. All Rights Reserved.
 * QUALCOMM Technologies Proprietary and Confidential.
 */

#ifndef ACDB_ID_MAPPER_H

/* ACDB ID for 8660 */
#define INVALID_ACDB_ID 0xff

#define DEVICE_HANDSET_RX_ACDB_ID			7 // HANDSET_SPKR
#define DEVICE_HANDSET_TX_ACDB_ID			4 // HANDSET_MIC
#define DEVICE_SPEAKER_RX_ACDB_ID			15// SPKR_PHONE_SPKR_STEREO
#define DEVICE_SPEAKER_MONO_RX_ACDB_ID                  14// SPKR_PHONE_SPKR_MONO
#define DEVICE_SPEAKER_TX_ACDB_ID			11// SPKR_PHONE_MIC
#define DEVICE_HEADSET_RX_ACDB_ID			10// HEADSET_SPKR_STEREO
#define DEVICE_HEADSET_MONO_RX_ACDB_ID                  9 // HEADSET_SPKR_MONO
#define DEVICE_HEADSET_TX_ACDB_ID			8 // HEADSET_MIC
#define DEVICE_FMRADIO_HANDSET_RX_ACDB_ID		INVALID_ACDB_ID // Not support yet
#define DEVICE_FMRADIO_HEADSET_RX_ACDB_ID		INVALID_ACDB_ID // Not support yet
#define DEVICE_FMRADIO_SPEAKER_RX_ACDB_ID		INVALID_ACDB_ID // Not support yet
#define DEVICE_DUALMIC_HANDSET_TX_BROADSIDE_ACDB_ID	5 // HANDSET_MIC_BROADSIDE
#define DEVICE_DUALMIC_HANDSET_TX_ENDFIRE_ACDB_ID	6 // HANDSET_MIC_ENDFIRE
#define DEVICE_DUALMIC_SPEAKER_TX_BROADSIDE_ACDB_ID	12// SPKR_PHONE_MIC_BROADSIDE
#define DEVICE_DUALMIC_SPEAKER_TX_ENDFIRE_ACDB_ID	13// SPKR_PHONE_MIC_ENDFIRE
#define DEVICE_DUALMIC_HANDSET_STEREO_ACDB_ID           34
#define DEVICE_DUALMIC_SPEAKER_PHONE_STEREO_ACDB_ID     35
#define DEVICE_TTY_HEADSET_MONO_RX_ACDB_ID		17// TTY_HEADSET_SPKR
#define DEVICE_TTY_HEADSET_MONO_TX_ACDB_ID		16// TTY_HEADSET_MIC
#define DEVICE_BT_SCO_RX_ACDB_ID			22// BT_SCO_SPKR
#define DEVICE_BT_SCO_TX_ACDB_ID			21// BT_SCO_SPKR
#define DEVICE_BT_SCO_RX_WB_ACDB_ID                     39// BT_SCO_WB_SPKR
#define DEVICE_BT_SCO_TX_WB_ACDB_ID                     38// BT_SCO_WB_MIC
#define DEVICE_SPEAKER_HEADSET_RX_ACDB_ID		DEVICE_HEADSET_RX_ACDB_ID // Use headset calibration
#define DEVICE_FMRADIO_STEREO_TX_ACDB_ID		INVALID_ACDB_ID // Not support yet
#define DEVICE_HDMI_STEREO_RX_ACDB_ID			18// HDMI_SPKR
#define DEVICE_ANC_HEADSET_STEREO_RX_ACDB_ID		26//ANC RX, same as regular headset
#define DEVICE_QUADMIC_ACDB_ID                          19// QUADMIC_SKPR
#define DEVICE_PROXY_RX_ACDB_ID   	               DEVICE_HDMI_STEREO_RX_ACDB_ID
#define DEVICE_TTY_VCO_HANDSET_TX_ACDB_ID		36 //TTY_VCO_HANDSET_MIC
#define DEVICE_TTY_HCO_HANDSET_RX_ACDB_ID               37 //TTY_HCO_HANDSET_SPRK
#define DEVICE_HANDSET_TX_FV5_ACDB_ID                   40
#define DEVICE_DUALMIC_HANDSET_TX_ENDFIRE_FV5_ACDB_ID   41
#define DEVICE_SPEAKER_TX_FV5_ACDB_ID                   42
#define DEVICE_DUALMIC_SPEAKER_TX_ENDFIRE_FV5_ACDB_ID   43
#define DEVICE_USB_TX_ACDB_ID                           44// USB_Tx
#define DEVICE_USB_RX_ACDB_ID                           45// USB_Rx
#define DEVICE_ANC_TEST_E_PATH_HANDSET_SPKR_ANC_MONO_ACDB_ID 89
#define DEVICE_ANC_TEST_S_PATH_HANDSET_SPKR_ANC_MONO_ACDB_ID 86
#define DEVICE_HANDSET_TX_MONO_LISTEN_LOW_ACDB_ID	100
#define DEVICE_SPEAKER_MONO_RX_PROT_ACDB_ID		101
#define DEVICE_SPEAKER_MONO_TX_PROT_ACDB_ID             102
#define DEVICE_HANDSET_RX_AANC_ACDB_ID			103
#define DEVICE_HANDSET_TX_AANC_ACDB_ID			104
#define DEVICE_DUALMIC_HANDSET_TX_ENDFIRE_AANC_ACDB_ID	105
#define DEVICE_HANDSET_TX_FV5_AEC_ACDB_ID		106
#define DEVICE_HANDSET_TX_FV5_NS_ACDB_ID		107
#define DEVICE_HANDSET_TX_FV5_AEC_NS_ACDB_ID		108
#define DEVICE_HANDSET_TX_ENDFIRE_FV5_AEC_ACDB_ID	109
#define DEVICE_HANDSET_TX_ENDFIRE_FV5_NS_ACDB_ID	110
#define DEVICE_HANDSET_TX_ENDFIRE_FV5_AEC_NS_ACDB_ID	111
#define DEVICE_SPEAKER_TX_FV5_AEC_ACDB_ID		112
#define DEVICE_SPEAKER_TX_FV5_NS_ACDB_ID		113
#define DEVICE_SPEAKER_TX_FV5_AEC_NS_ACDB_ID		114
#define DEVICE_SPEAKER_TX_ENDFIRE_FV5_AEC_ACDB_ID	115
#define DEVICE_SPEAKER_TX_ENDFIRE_FV5_NS_ACDB_ID	116
#define DEVICE_SPEAKER_TX_ENDFIRE_FV5_AEC_NS_ACDB_ID	117
#define DEVICE_BT_SCO_TX_NREC_ACDB_ID			122// BT_SCO_MIC_NREC
#define DEVICE_BT_SCO_TX_WB_NREC_ACDB_ID		123// BT_SCO_WB_MIC_NREC
#define DEVICE_HANDSET_MONO_LISTEN_HIGH_POWER_ACDB_ID   127
#define DEVICE_HANDSET_MONO_LISTEN_ULP_ACDB_ID          128
#define DEVICE_HANDSET_MONO_LISTEN_HIGH_POWER_DUTYCYCLE_ACDB_ID   130

#ifdef _NO_ACDB_MAPPER_LIB_
int acdb_mapper_get_acdb_id_from_dev_name(char *dev_name, int *acdb_id) {return 0;}
int acdb_mapper_get_acdb_id_from_dev_id(int dev_id, int *acdb_id) {return 0;}
#else
int acdb_mapper_get_acdb_id_from_dev_name(char *dev_name, int *acdb_id);
int acdb_mapper_get_acdb_id_from_dev_id(int dev_id, int *acdb_id);
#endif

#endif /* ACDB_ID_MAPPER_H */
